/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.BrokerConnector;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Service;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceList;

public class DeployServiceOperator
extends Operator {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private ServiceList services;
    private OperatorConfig configuration;

    public DeployServiceOperator(OperatorConfig configuration, ServiceList services, Operator.ACTION action) {
        this.services = services;
        this.configuration = configuration;
        this.action = action;
    }

    @Override
    public void exec() throws Exception {
        this.configuration.session.save();
        HashSet<ScopedDeployedService> servicesToDeploy = new HashSet<ScopedDeployedService>();
        HashSet<ScopedResource> servicesToUndeploy = new HashSet<ScopedResource>();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        for (ServiceItem serviceitem : this.services.getService()) {
            String serviceID = null;
            try {
                GCUBEServiceQuery query = (GCUBEServiceQuery)client.getQuery(GCUBEServiceQuery.class);
                query.addGenericCondition("$result/Profile/Name/string() eq '" + serviceitem.getServiceName() + "' and $result/Profile/Class/string() eq '" + serviceitem.getServiceClass() + "'");
                List profiles = client.execute((ISQuery)query, this.configuration.scope);
                if (profiles == null || profiles.size() == 0) {
                    this.logger.error((Object)"Failed to find the service");
                    continue;
                }
                this.logger.debug((Object)("Retrieved service ID " + ((GCUBEService)profiles.get(0)).getID()));
                serviceID = ((GCUBEService)profiles.get(0)).getID();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to retrieve the service ID from the IS ", (Throwable)e);
                continue;
            }
            ScopedDeployedService service = (ScopedDeployedService)ScopedResourceFactory.newResource(serviceID, "Service", this.configuration.scope);
            service.setSourceServiceName(Service.fromServiceItem(serviceitem));
            try {
                if (this.action == Operator.ACTION.ADD) {
                    service.findResource();
                    if (service.isSuccess()) {
                        servicesToDeploy.add(service);
                    }
                } else {
                    service.setCallbackID(this.configuration.session.getId());
                    servicesToUndeploy.add(service);
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to find the service", (Throwable)e);
            }
            this.configuration.session.addResource(service);
            this.configuration.session.addService(service);
        }
        if (this.action == Operator.ACTION.ADD && this.allocate(servicesToDeploy)) {
            HashSet<ScopedResource> resourcesToAdd = new HashSet<ScopedResource>();
            for (ScopedDeployedService service : servicesToDeploy) {
                if (service.getStatus() == ScopedResource.STATUS.LOST) continue;
                service.setCallbackID(this.configuration.session.getId());
                resourcesToAdd.add(service);
                if (this.configuration.scope.getType() != GCUBEScope.Type.VRE) continue;
                ScopedResource ghn = ScopedResourceFactory.newResource(service.getTargetGHNID(), "GHN", this.configuration.scope);
                resourcesToAdd.add(ghn);
                this.configuration.session.addResource(ghn);
            }
            if (servicesToDeploy.size() > 0) {
                this.configuration.scopeState.addResources(resourcesToAdd);
                final GCUBEScope tscope = this.configuration.scope;
                final Session tsession = this.configuration.session;
                new Thread(){

                    @Override
                    public void run() {
                        do {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (!tsession.isReportClosed() || tsession.getOperation() != Session.OPERATION.AddResources && tsession.getOperation() != Session.OPERATION.UpdateResources && tsession.getOperation() != Session.OPERATION.Create);
                        try {
                            BrokerConnector.getBroker(tscope).sendFeedback(tsession);
                        }
                        catch (Exception e) {
                            DeployServiceOperator.this.logger.error((Object)"Failed to send the feedback to the Broker", (Throwable)e);
                        }
                    }
                }.start();
            }
        }
        if (servicesToUndeploy.size() > 0) {
            this.configuration.scopeState.removeResources(servicesToUndeploy);
        }
        this.configuration.session.save();
    }

    private boolean allocate(Set<ScopedDeployedService> servicesToDeploy) {
        try {
            if (servicesToDeploy.size() > 0) {
                BrokerConnector.getBroker(this.configuration.scope).makePlan(this.configuration.session, servicesToDeploy, this.services.getGHN());
                this.configuration.session.reportBrokerWork(true, "The Deployment Plan was successfully created");
                return true;
            }
            this.logger.warn((Object)"The Broker was not contacted. After the dependency resolution phase, there is nothing to deploy");
            this.configuration.session.reportBrokerWork(false, "The Broker was not contacted. After the dependency resolution phase, there is nothing to deploy");
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred when interacting with the broker", (Throwable)e);
            this.configuration.session.reportBrokerWork(false, "An error occurred when interacting with the broker " + e.getMessage());
            return false;
        }
    }
}

