/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.operators.DeployServiceOperator;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.operators.ScopedResourceManagerOperator;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceList;

public class AddResourcesOperator
extends Operator {
    protected final GCUBELog logger = new GCUBELog((Object)this, (GCUBEContext)ServiceContext.getContext());
    private AddResourcesParameters resourceList;
    private OperatorConfig configuration;

    public AddResourcesOperator(OperatorConfig configuration, AddResourcesParameters resourceList) {
        this.resourceList = resourceList;
        this.configuration = configuration;
    }

    @Override
    public void exec() throws Exception {
        ServiceList services = this.resourceList.getServices();
        if (services == null || services.getService() == null || services.getService().length == 0) {
            this.logger.warn((Object)"The list of services to deploy is empty");
        } else {
            try {
                new DeployServiceOperator(this.configuration, services, Operator.ACTION.ADD).run();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to activate the deployment of the given service(s)", (Throwable)e);
                throw new Exception("Unable to activate the deployment of the given service(s)", e);
            }
        }
        ResourceList resources = this.resourceList.getResources();
        if (resources == null || resources.getResource() == null || resources.getResource().length == 0) {
            this.logger.warn((Object)"The list of resource to add is empty");
        } else {
            try {
                new ScopedResourceManagerOperator(this.configuration, resources, Operator.ACTION.ADD).run();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to manage the given resource(s)", (Throwable)e);
                throw new Exception("Unable to manage the given resource(s)", e);
            }
        }
        this.configuration.session.save();
    }
}

