/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.deployment;

import java.rmi.Remote;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployerPortType;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UndeployParameters;
import org.gcube.common.vremanagement.deployer.stubs.deployer.service.DeployerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.contexts.StatefulPortTypeContext;

public class VirtualNode {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private String callbackID;
    private String ghnID = "";
    private GCUBEScope scope = null;
    private boolean isWorking = false;
    private Set<PackageInfo> packagesToAdd = new HashSet<PackageInfo>();
    private Set<PackageInfo> packagesToRemove = new HashSet<PackageInfo>();
    private long lastActivity;
    private String name = "";
    private static final long MAX_ACTIVITY = 3600000L;

    protected VirtualNode(String ID, GCUBEScope scope) throws NoGHNFoundException {
        this.ghnID = ID;
        this.scope = scope;
    }

    public void setCallbackID(String id) {
        this.callbackID = id;
    }

    public String detectName() throws NoGHNFoundException {
        this.logger.debug((Object)("Detecting name for " + this.ghnID));
        if (GHNContext.getContext().getGHNID().compareToIgnoreCase(this.ghnID) == 0) {
            throw new NoGHNFoundException("cannot deploy on the same GHN (ghnID=" + this.ghnID + ") where the Resource Manager is deployed");
        }
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGHNQuery query = (GCUBEGHNQuery)client.getQuery(GCUBEGHNQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID/text()", this.ghnID)});
            return ((GCUBEHostingNode)client.execute((ISQuery)query, this.scope).get(0)).getNodeDescription().getName();
        }
        catch (Exception e) {
            this.logger.error((Object)("unable to find the target GHN (ghnID=" + this.ghnID + ")"), (Throwable)e);
            throw new NoGHNFoundException("unable to find the target GHN (ghnID=" + this.ghnID + ")");
        }
    }

    public synchronized void setPackagesToAdd(Set<PackageInfo> packages) {
        if (this.hasPackages(packages)) {
            return;
        }
        this.packagesToAdd.addAll(packages);
    }

    protected Set<PackageInfo> getPackages() {
        return this.packagesToAdd;
    }

    protected boolean hasPackages(Set<PackageInfo> packages) {
        if (packages.size() == 0) {
            return false;
        }
        if (this.packagesToAdd.size() == 0) {
            return false;
        }
        block0: for (PackageInfo inputPackage : packages) {
            for (PackageInfo nodePackage : this.packagesToAdd) {
                if (inputPackage.getServiceClass().compareToIgnoreCase(nodePackage.getServiceClass()) != 0 || inputPackage.getServiceName().compareToIgnoreCase(nodePackage.getServiceName()) != 0 || inputPackage.getServiceVersion().compareToIgnoreCase(nodePackage.getServiceVersion()) != 0 || inputPackage.getName().compareToIgnoreCase(nodePackage.getName()) != 0 || inputPackage.getVersion().compareToIgnoreCase(nodePackage.getVersion()) != 0) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String getID() {
        return this.ghnID;
    }

    public synchronized void deploy(GCUBEScope scope) throws Exception {
        if (this.packagesToAdd.size() == 0) {
            return;
        }
        if (this.isWorking && System.currentTimeMillis() - this.lastActivity < 3600000L) {
            this.logger.warn((Object)("Can't deploy on " + this + ", the gHN is already working"));
            return;
        }
        EndpointReferenceType callbackEPR = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint(StatefulPortTypeContext.getContext().getJNDIName());
        DeployParameters param = new DeployParameters();
        param.set_package(this.packagesToAdd.toArray(new PackageInfo[0]));
        param.setTargetScope(new String[]{scope.toString()});
        param.setCallbackID(this.callbackID);
        param.setEndpointReference(callbackEPR);
        EndpointReferenceType nodeEPR = this.loadDeployer(this.ghnID);
        this.logger.trace((Object)("Deploying on " + nodeEPR.toString()));
        DeployerPortType pt = (DeployerPortType)GCUBERemotePortTypeContext.getProxy((Remote)new DeployerServiceAddressingLocator().getDeployerPortTypePort(nodeEPR), (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
        pt.deploy(param);
        this.packagesToAdd.clear();
        this.isWorking = true;
        this.lastActivity = System.currentTimeMillis();
    }

    public synchronized void undeploy(GCUBEScope scope) throws Exception {
        if (this.packagesToRemove.size() == 0) {
            return;
        }
        if (this.isWorking && this.lastActivity - System.currentTimeMillis() < 3600000L) {
            this.logger.warn((Object)("Can't undeploy from " + this + ", the gHN is already working"));
            return;
        }
        EndpointReferenceType callbackEPR = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint(StatefulPortTypeContext.getContext().getJNDIName());
        UndeployParameters params = new UndeployParameters();
        params.set_package(this.packagesToRemove.toArray(new PackageInfo[0]));
        params.setTargetScope(new String[]{scope.toString()});
        params.setCallbackID(this.callbackID);
        params.setEndpointReference(callbackEPR);
        EndpointReferenceType nodeEPR = this.loadDeployer(this.ghnID);
        this.logger.trace((Object)("Undeploying from " + nodeEPR.toString() + " in scope " + scope));
        DeployerPortType pt = (DeployerPortType)GCUBERemotePortTypeContext.getProxy((Remote)new DeployerServiceAddressingLocator().getDeployerPortTypePort(nodeEPR), (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
        pt.undeploy(params);
        this.packagesToRemove.clear();
        this.isWorking = true;
        this.lastActivity = System.currentTimeMillis();
    }

    public void isNotWorking() {
        this.isWorking = false;
    }

    public synchronized void setPackagesToRemove(Set<PackageInfo> packages) {
        this.packagesToRemove.addAll(packages);
    }

    public String toString() {
        return "VirtualNode [ghnID=" + this.ghnID + ", scope=" + this.scope + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ghnID == null ? 0 : this.ghnID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualNode other = (VirtualNode)obj;
        return !(this.ghnID == null ? other.ghnID != null : !this.ghnID.equals(other.ghnID));
    }

    public void setWorkingScope(GCUBEScope scope) {
        this.scope = scope;
    }

    public Set<PackageInfo> getScheduledPackages() {
        return this.packagesToAdd;
    }

    public GCUBEScope getWorkingScope() {
        return this.scope;
    }

    private EndpointReferenceType loadDeployer(String id) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery riquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        riquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//GHN/@UniqueID", id), new AtomicCondition("//ServiceClass", "VREManagement"), new AtomicCondition("//ServiceName", "Deployer")});
        List results = client.execute((ISQuery)riquery, ServiceContext.getContext().getScope());
        return ((GCUBERunningInstance)results.get(0)).getAccessPoint().getEndpoint("gcube/common/vremanagement/Deployer");
    }

    public static class NoGHNFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoGHNFoundException(String message) {
            super(message);
        }
    }
}

