/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.deployment;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Service;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.DependenciesCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;
import org.kxml2.io.KXmlParser;

public final class SoftwareGatewayRequest {
    private Map<ScopedDeployedService, DependenciesCoordinates> requests = new HashMap<ScopedDeployedService, DependenciesCoordinates>();
    protected static final String RESOLVED_DEPS_KEY = "listResolvedDeps";
    protected static final String MISSING_DEPS_KEY = "listMissingDeps";
    protected static final String REPOSITORY_ENDPOINT = "gcube/vremanagement/softwaregateway/Access";
    protected static final String REPOSITORY_NAME = "SoftwareGateway";
    protected static final String REPOSITORY_CLASS = "VREManagement";
    protected static final int TIMEOUT = 600000;
    protected final GCUBELog logger = new GCUBELog((Object)this);

    public void addService(ScopedDeployedService service) {
        DependenciesCoordinates message = new DependenciesCoordinates();
        message.setServiceClass(service.getSourceService().getClazz());
        message.setServiceName(service.getSourceService().getName());
        message.setServiceVersion(service.getSourceService().getVersion());
        this.requests.put(service, message);
    }

    public List<ScopedDeployedService> send() throws Exception {
        ArrayList<ScopedDeployedService> service2package = new ArrayList<ScopedDeployedService>();
        Map<GCUBEScope, Set<EndpointReferenceType>> eprs = this.findInstances();
        block2: for (ScopedDeployedService service : this.requests.keySet()) {
            DependenciesCoordinates packageCoordinates = this.requests.get(service);
            this.logger.trace((Object)("Checking deps for " + packageCoordinates.getServiceName()));
            for (GCUBEScope scope : eprs.keySet()) {
                for (EndpointReferenceType epr : eprs.get(scope)) {
                    try {
                        this.logger.trace((Object)("Trying Service Repository located at " + epr));
                        AccessServiceAddressingLocator locator = new AccessServiceAddressingLocator();
                        AccessPortType pt = locator.getAccessPortTypePort(epr);
                        String report = ((AccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()})).getDependencies(packageCoordinates);
                        service2package.add(this.parseDependenciesReport(service, report));
                        continue block2;
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Unable to check deps for " + packageCoordinates.getServiceName() + " from Service Repository in " + scope + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                service.setErrorMessage("Unable to check deps for this service in any of the Service Repository instance in scope");
                service2package.add(service);
            }
        }
        return service2package;
    }

    private ScopedDeployedService parseDependenciesReport(ScopedDeployedService service, String report) throws Exception {
        block9: {
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new BufferedReader(new StringReader(report)));
            this.logger.trace((Object)("Parsing: " + report));
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("ResolvedDependencies")) {
                                this.parseResolvedDependencies(parser, service);
                            }
                            if (parser.getName().equals("MissingDependencies")) {
                                this.parseMissingDependencies(parser, service);
                            }
                            break;
                        }
                        case 1: {
                            break block9;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to parse the deployment report returned by the Software Repository", (Throwable)e);
            }
        }
        return service;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseService(KXmlParser parser, Service s) throws Exception {
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Class")) {
                        s.setClazz(parser.nextText());
                    }
                    if (parser.getName().equals("Name")) {
                        s.setName(parser.nextText());
                    }
                    if (!parser.getName().equals("Version")) break;
                    s.setVersion(parser.nextText());
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Service")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Service");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Dependency parseDependency(KXmlParser parser) throws Exception {
        Dependency p = new Dependency();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Service")) {
                        this.parseService(parser, p.getService());
                    }
                    if (parser.getName().equals("Package")) {
                        p.setName(parser.nextText());
                    }
                    if (!parser.getName().equals("Version")) break;
                    p.setVersion(parser.nextText());
                    break;
                }
                case 3: {
                    if (parser.getName().equals("Dependency")) return p;
                    if (!parser.getName().equals("MissingDependency")) break;
                    return p;
                }
                case 1: {
                    throw new Exception("Parsing failed at Dependency");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseResolvedDependencies(KXmlParser parser, ScopedDeployedService service) throws Exception {
        this.logger.trace((Object)"Parsing resolved dependencies...");
        ArrayList<Dependency> resolved = new ArrayList<Dependency>();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("Dependency")) break;
                    this.logger.trace((Object)"Dependency found");
                    resolved.add(this.parseDependency(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("ResolvedDependencies")) break;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at ResolvedDependencies");
                }
            }
        }
        this.logger.trace((Object)("Number of deps found: " + resolved.size()));
        service.setResolvedDependencies(resolved);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseMissingDependencies(KXmlParser parser, ScopedDeployedService service) throws Exception {
        this.logger.trace((Object)"Parsing missing dependencies...");
        ArrayList<Dependency> missing = new ArrayList<Dependency>();
        block5: while (true) {
            switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("MissingDependency")) break;
                    this.logger.trace((Object)"Dependency found");
                    missing.add(this.parseDependency(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("MissingDependencies")) break;
                    break block5;
                }
                case 1: {
                    throw new Exception("Parsing failed at MissingDependencies");
                }
            }
        }
        this.logger.trace((Object)("Number of deps found: " + missing.size()));
        service.setMissingDependencies(missing);
    }

    protected Map<GCUBEScope, Set<EndpointReferenceType>> findInstances() throws Exception {
        HashMap<GCUBEScope, Set<EndpointReferenceType>> scopeMap = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
        this.logger.debug((Object)"Looking for SR instances...");
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", REPOSITORY_NAME)});
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", REPOSITORY_CLASS)});
        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
            this.logger.debug((Object)("Quering in scope " + scope));
            List list = client.execute((ISQuery)lookupQuery, scope);
            this.logger.debug((Object)("Found N." + list.size() + " instances"));
            for (GCUBERunningInstance instance : list) {
                this.logger.trace((Object)("Found instance " + instance.toString()));
                EndpointReferenceType epr = instance.getAccessPoint().getEndpoint(REPOSITORY_ENDPOINT);
                this.logger.trace((Object)("Found EPR " + epr.toString()));
                if (!scopeMap.keySet().contains(scope)) {
                    HashSet l = new HashSet();
                    scopeMap.put(scope, l);
                }
                ((Set)scopeMap.get(scope)).add(epr);
            }
        }
        return scopeMap;
    }
}

