/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.deployment;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.DeployedDependency;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Service;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResourceFactory;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class DeployerReport {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private String report = "";
    private String status = "";
    private String id = "";
    private String host = "";
    private String type = "";
    private Date lastUpdate;
    private List<DeployedDependency> dependencies = new ArrayList<DeployedDependency>();
    private Set<DeployedRunningInstance> instances = new HashSet<DeployedRunningInstance>();

    public DeployerReport(String report) throws Exception {
        this.report = report;
        try {
            this.parse();
        }
        catch (XmlPullParserException e) {
            throw new Exception("invalid Deployer Report");
        }
    }

    public String getGHNID() {
        return this.id;
    }

    public String toString() {
        return this.report;
    }

    public String getType() {
        return this.type;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public List<DeployedDependency> getDependencies() {
        return this.dependencies;
    }

    public String getHost() {
        return this.host;
    }

    private void parse() throws Exception {
        block13: {
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new BufferedReader(new StringReader(this.report)));
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("GHNID")) {
                                this.id = parser.nextText();
                                break;
                            }
                            if (parser.getName().equals("Type")) {
                                this.type = parser.nextText();
                                break;
                            }
                            if (parser.getName().equals("LastUpdate")) {
                                this.lastUpdate = ProfileDate.fromXMLDateAndTime(parser.nextText());
                                break;
                            }
                            if (parser.getName().equals("Status")) {
                                this.status = parser.nextText();
                                break;
                            }
                            if (parser.getName().equals("Packages")) {
                                this.parsePackages(parser);
                                break;
                            }
                            if (parser.getName().equals("NewInstances")) {
                                this.parseInstances(parser);
                            }
                            break;
                        }
                        case 1: {
                            break block13;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to parse the Deployer Report", (Throwable)e);
                throw new Exception("Unable to parse the Deployer Report", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseInstances(KXmlParser parser) throws Exception {
        while (true) {
            block2 : switch (parser.next()) {
                case 2: {
                    if (!parser.getName().equals("NewInstance")) break;
                    DeployedRunningInstance instance = new DeployedRunningInstance();
                    while (true) {
                        switch (parser.next()) {
                            case 2: {
                                if (parser.getName().equals("ID")) {
                                    instance.setRIId(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceClass")) {
                                    instance.setServiceClass(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceName")) {
                                    instance.setServiceName(parser.nextText());
                                }
                                if (parser.getName().equals("ServiceVersion")) {
                                    instance.setServiceVersion(parser.nextText());
                                }
                                if (parser.getName().equals("PackageVersion")) {
                                    instance.setPackageVersion(parser.nextText());
                                }
                                if (!parser.getName().equals("PackageName")) break;
                                instance.setPackageName(parser.nextText());
                                break;
                            }
                            case 3: {
                                if (!parser.getName().equals("NewInstance")) break;
                                try {
                                    ScopedRunningInstance ri = (ScopedRunningInstance)ScopedResourceFactory.newResource(instance.getRIID(), "RunningInstance", ServiceContext.getContext().getScope());
                                    ri.setHostedON(this.host);
                                    ri.setJointTime(Calendar.getInstance().getTime());
                                    ri.setStatus(ScopedResource.STATUS.PUBLISHED);
                                    instance.setInstance(ri);
                                    instance.isAlive = true;
                                    instance.setMessage("An instance of this service has been correctly activated on " + this.host);
                                    break block2;
                                }
                                catch (Exception e) {
                                    this.logger.error((Object)("An instance of this service has been activated but it didn't start correctly on " + this.host + ". The expected instance identifier was " + instance.getRIID()), (Throwable)e);
                                    instance.setMessage("An instance of this service has been activated but it didn't start correctly on " + this.host + ". The expected instance identifier was " + instance.getRIID());
                                    instance.isAlive = false;
                                    break block2;
                                }
                                finally {
                                    this.instances.add(instance);
                                }
                            }
                            case 1: {
                                throw new Exception("Parsing failed at NewInstance");
                            }
                        }
                    }
                }
                case 3: {
                    if (!parser.getName().equals("NewInstances")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at NewInstances");
                }
            }
        }
    }

    private void parsePackages(KXmlParser parser) throws Exception {
        block24: {
            try {
                while (true) {
                    block1 : switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Package")) {
                                DeployedDependency dd = new DeployedDependency();
                                dd.setService(new Service());
                                while (true) {
                                    switch (parser.next()) {
                                        case 2: {
                                            if (parser.getName().equals("ServiceClass")) {
                                                dd.getService().setClazz(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("ServiceName")) {
                                                dd.getService().setName(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("ServiceVersion")) {
                                                dd.getService().setVersion(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("PackageName")) {
                                                dd.setName(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("PackageVersion")) {
                                                dd.setVersion(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("Status")) {
                                                dd.setStatus(parser.nextText());
                                                break;
                                            }
                                            if (parser.getName().equals("Host")) {
                                                dd.setHost(parser.nextText());
                                                this.host = dd.getHost();
                                                break;
                                            }
                                            if (parser.getName().equals("Message")) {
                                                dd.setMessage(parser.nextText());
                                                break;
                                            }
                                            parser.nextText();
                                            break;
                                        }
                                        case 3: {
                                            if (!parser.getName().equals("Package")) break;
                                            this.dependencies.add(dd);
                                            break block1;
                                        }
                                        case 1: {
                                            throw new Exception("Parsing failed at Package");
                                        }
                                    }
                                }
                            }
                            break;
                        }
                        case 3: {
                            if (parser.getName().equals("Packages")) {
                                break block24;
                            }
                            break;
                        }
                        case 1: {
                            throw new Exception("Parsing failed at Packages");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to parse the Deployer Report");
            }
        }
    }

    public String getStatus() {
        return this.status;
    }

    public Set<DeployedRunningInstance> getInstances() {
        return this.instances;
    }

    public final class DeployedRunningInstance {
        private ScopedRunningInstance instance;
        private String riid;
        private String serviceClass;
        private String serviceName;
        private String serviceVersion;
        private String packageName;
        private String packageVersion;
        private boolean isAlive;
        private String message;

        public ScopedRunningInstance getInstance() {
            return this.instance;
        }

        public void setInstance(ScopedRunningInstance instance) {
            this.instance = instance;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public void setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceVersion() {
            return this.serviceVersion;
        }

        public void setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public String getRIID() {
            return this.riid;
        }

        public void setRIId(String riid) {
            this.riid = riid;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void setAlive(boolean isAlive) {
            this.isAlive = isAlive;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.riid == null ? 0 : this.riid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeployedRunningInstance other = (DeployedRunningInstance)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.riid == null ? other.riid != null : !this.riid.equals(other.riid));
        }

        private DeployerReport getOuterType() {
            return DeployerReport.this;
        }
    }
}

