/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.contexts;

import java.io.File;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.vremanagement.resourcemanager.impl.contexts.StatefulPortTypeContext;

public class ServiceContext
extends GCUBEServiceContext {
    static ServiceContext cache = new ServiceContext();

    public static ServiceContext getContext() {
        return cache;
    }

    protected String getJNDIName() {
        return "gcube/vremanagement/ResourceManager/service";
    }

    protected void onReady() throws Exception {
        super.onReady();
        if (ServiceContext.getContext().getInstance().getScopes().values().size() != 1) {
            this.logger.fatal((Object)"ResourceManager is misconfigured, cannot start the service in multiple scopes");
            throw new IllegalServiceScopeException("ResourceManager has been configured to join more than one scope, while it can work only in ONE single scope");
        }
        HStateScheduler stateScheduler = new HStateScheduler(10L, GCUBEScheduledHandler.Mode.LAZY);
        stateScheduler.setScheduled(new HState());
        stateScheduler.run();
    }

    public String getConfigurationFileAbsolutePath(String relativepath) {
        File file = super.getFile(relativepath, new boolean[]{false});
        if (!file.exists() || file.isDirectory()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static class IllegalServiceScopeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalServiceScopeException(String message) {
            super(message);
        }
    }

    protected class HState
    extends GCUBEHandler<Object> {
        public void run() throws Exception {
            GCUBEScope scope = (GCUBEScope)ServiceContext.getContext().getInstance().getScopes().values().iterator().next();
            this.logger.trace((Object)("Adding ResourceManager resource to " + scope));
            ServiceContext.getContext().setScope(scope);
            StatefulPortTypeContext.getContext().getWSHome().create(StatefulPortTypeContext.getContext().makeKey("VREManagerState"), new Object[0]);
        }
    }

    protected class HStateScheduler
    extends GCUBEScheduledHandler {
        public HStateScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn((Object)("Failed to create the vre manager resource (attempt " + exceptionCount + " out of 20)"), (Throwable)exception);
                if (exceptionCount >= 20) {
                    this.logger.error((Object)"Max attempts reached, no more chance to register the ResourceManager resource, the service startup failed");
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

