/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker.kxml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public final class KPlanParser {
    private static final GCUBELog logger = new GCUBELog(KPlanParser.class);

    public static void parse(String plan, Set<ScopedDeployedService> services, GCUBEScope scope) throws IOException {
        block11: {
            KXmlParser parser = new KXmlParser();
            try {
                parser.setInput((Reader)new BufferedReader(new StringReader(plan)));
            }
            catch (XmlPullParserException e) {
                logger.error((Object)"Unable to parse the Deployment Plan", (Throwable)e);
                throw new IOException("Unable to parse the Deployment Plan");
            }
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Status")) {
                                KPlanParser.parseStatus(parser);
                                break;
                            }
                            if (parser.getName().equals("PackageGroup")) {
                                KPlanParser.parsePackageGroup(services, parser, scope);
                            }
                            break;
                        }
                        case 1: {
                            break block11;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to parse the Deployment Plan", (Throwable)e);
                throw new IOException("The creation of the Deployment Plan failed. " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseStatus(KXmlParser parser) throws IOException {
        String value = parser.getAttributeValue(null, "value");
        String errorMsg = "";
        if (value.compareToIgnoreCase("FAILED") == 0) {
            block10: {
                try {
                    block6: while (true) {
                        switch (parser.next()) {
                            case 2: {
                                if (!parser.getName().equals("ErrorMsg")) break;
                                errorMsg = parser.nextText();
                                continue block6;
                            }
                            case 3: {
                                if (parser.getName().equals("Status")) break block10;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to parse the Deployment Plan at Status element", (Throwable)e);
                    throw new IOException("Failed to parse at Status element");
                }
            }
            logger.error((Object)("The creation of the Deployment Plan failed. Broker says: " + errorMsg));
            throw new IOException("Broker says: " + errorMsg);
        }
        if (value.compareToIgnoreCase("SUCCESS") == 0) {
            logger.info((Object)"The creation of the Deployment Plan was successful");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parsePackageGroup(Set<ScopedDeployedService> services, KXmlParser parser, GCUBEScope scope) throws IOException, VirtualNode.NoGHNFoundException {
        ScopedDeployedService service;
        String ghnID;
        String serviceID;
        block10: {
            serviceID = parser.getAttributeValue(null, "service");
            ghnID = null;
            try {
                block6: while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (!parser.getName().equals("GHN")) break;
                            ghnID = parser.nextText();
                            continue block6;
                        }
                        case 3: {
                            if (parser.getName().equals("PackageGroup")) break block10;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to parse the Deployment Plan at PackageGroup element", (Throwable)e);
                throw new IOException("Failed to parse at PackageGroup element");
            }
        }
        if (ghnID == null) {
            logger.error((Object)("a gHN was not assigned to service " + serviceID));
            throw new VirtualNode.NoGHNFoundException("a gHN was not assigned to service " + serviceID);
        }
        Iterator<ScopedDeployedService> i$ = services.iterator();
        do {
            if (!i$.hasNext()) return;
        } while ((service = i$.next()).getId().compareToIgnoreCase(serviceID) != 0);
        logger.info((Object)("Assigning gHN " + ghnID + " to " + service));
        VirtualNode node = VirtualNodeManager.getNode(ghnID, scope);
        node.setWorkingScope(scope);
        service.setTargetGHN(node);
    }
}

