/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker.kxml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.deployment.DeployerReport;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public class KFeedback {
    protected static final GCUBELog logger = new GCUBELog(KFeedback.class);

    public static String create(Session session) throws IOException {
        Map<String, DeployerReport> reports = session.getAllGHNReports();
        Set<ScopedDeployedService> services = session.getServices();
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new BufferedReader(new StringReader(session.getDeploymentPlan())));
        }
        catch (XmlPullParserException e) {
            logger.error((Object)"Unable to parse the Deployment Plan", (Throwable)e);
            throw new IOException("Unable to parse the Deployment Plan");
        }
        StringWriter feedbackRequest = new StringWriter();
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput((Writer)feedbackRequest);
        serializer.startDocument("UTF-8", Boolean.valueOf(true));
        serializer.setPrefix("", "http://gcube-system.org/namespaces/resourcebroker/broker/xsd/deployFeedback");
        serializer.startTag(null, "KFeedback").attribute(null, "planID", KFeedback.getPlanID(parser));
        serializer.startTag(null, "Scope").text(session.getScope().toString()).endTag(null, "Scope");
        for (String ghnid : reports.keySet()) {
            serializer.startTag(null, "DeployNode");
            serializer.startTag(null, "GHN").text(ghnid).endTag(null, "GHN");
            serializer.endTag(null, "DeployNode");
        }
        serializer.endTag(null, "KFeedback");
        return feedbackRequest.toString();
    }

    private static String getPlanID(KXmlParser parser) throws IOException {
        String id;
        block8: {
            id = "";
            try {
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("PlanResponse")) {
                                id = parser.getAttributeValue(null, "deployID");
                            }
                            break block8;
                        }
                        case 1: {
                            break block8;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to parse the Deployment Plan", (Throwable)e);
                throw new IOException("The creation of the Deployment Plan failed. " + e.getMessage());
            }
        }
        return id;
    }
}

