/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker;

import java.io.IOException;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream.XStreamTransformer;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcemanager.impl.deployment.resources.Dependency;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;

public class PlanRequest {
    public static String create(Set<ScopedDeployedService> services, String[] suggestedGHNs, GCUBEScope scope) throws IOException {
        org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanRequest planReq = new org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanRequest(scope.toString());
        for (ScopedDeployedService service : services) {
            PackageGroup group = planReq.createPackageGroup(service.getId());
            for (Dependency dep : service.getLastResolvedDependencies()) {
                group.addPackage(new PackageElem(false, dep.getService().getClazz(), dep.getService().getName(), dep.getService().getVersion(), dep.getName(), dep.getVersion()));
                if (service.getSourceService().getGHN() == null) continue;
                group.setGHN(service.getSourceService().getGHN());
            }
        }
        if (suggestedGHNs != null) {
            for (String ghn : suggestedGHNs) {
                planReq.getGHNList().addGHN(ghn);
            }
        }
        XStreamTransformer transformer = new XStreamTransformer();
        return transformer.toXML(planReq);
    }
}

