/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker;

import java.io.IOException;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream.XStreamTransformer;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanResponse;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;

public final class PlanParser {
    private static final GCUBELog logger = new GCUBELog(PlanParser.class);

    public static void parse(String plan, Set<ScopedDeployedService> services, GCUBEScope scope) throws IOException {
        XStreamTransformer transformer = new XStreamTransformer();
        PlanResponse resp = transformer.getResponseFromXML(plan, false);
        if (resp.getStatus().getStatus().compareToIgnoreCase("FAILED") == 0) {
            logger.error((Object)("The creation of the Deployment Plan failed. Broker says: " + resp.getStatus().getMsg()));
            throw new IOException("Broker says: " + resp.getStatus().getMsg());
        }
        if (resp.getStatus().getStatus().compareToIgnoreCase("SUCCESS") == 0) {
            logger.info((Object)"The creation of the Deployment Plan was successful");
        }
        block2: for (PackageGroup group : resp.getPackageGroups()) {
            String serviceID = group.getServiceName();
            String ghnID = group.getGHN();
            if (ghnID == null) {
                logger.error((Object)("no gHN was assigned to service " + serviceID));
                throw new IOException("no gHN was assigned to service " + serviceID);
            }
            for (ScopedDeployedService service : services) {
                if (service.getId().compareToIgnoreCase(serviceID) != 0) continue;
                logger.info((Object)("Assigning gHN " + ghnID + " to " + service));
                VirtualNode node = null;
                try {
                    node = VirtualNodeManager.getNode(ghnID, scope);
                }
                catch (VirtualNode.NoGHNFoundException e) {
                    logger.error((Object)("unable to find gHN " + ghnID + " returned by the Broker"));
                    throw new IOException("unable to find gHN " + ghnID + " returned by the Broker");
                }
                node.setWorkingScope(scope);
                node.isNotWorking();
                service.setTargetGHN(node);
                continue block2;
            }
        }
    }
}

