/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker;

import java.io.IOException;
import java.util.Set;
import org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream.XStreamTransformer;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanResponse;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.DeployNode;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.FeedbackStatus;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;

public class Feedback {
    public static String create(Session session) throws IOException {
        Set<ScopedDeployedService> services = session.getServices();
        XStreamTransformer transformer = new XStreamTransformer();
        PlanResponse resp = transformer.getResponseFromXML(session.getDeploymentPlan(), false);
        org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.Feedback fb = new org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.Feedback();
        fb.setPlanID(resp.getKey());
        fb.setScope(resp.getScope());
        for (PackageGroup group : resp.getPackageGroups()) {
            ScopedDeployedService service = null;
            for (ScopedDeployedService s : services) {
                if (s.getId().compareToIgnoreCase(group.getServiceName()) != 0) continue;
                service = s;
                break;
            }
            for (PackageElem p : group.getPackages()) {
                if (service == null) {
                    p.setStatus(FeedbackStatus.FAILED);
                    continue;
                }
                if (service.isSuccess()) {
                    p.setStatus(FeedbackStatus.SUCCESS);
                    continue;
                }
                p.setStatus(FeedbackStatus.FAILED);
            }
            DeployNode pgToAdd = new DeployNode(group);
            fb.addDeployNode(pgToAdd);
        }
        return transformer.toXML(fb);
    }
}

