/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage;

import java.rmi.Remote;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.stubs.ResourceBrokerPortType;
import org.gcube.vremanagement.resourcebroker.stubs.service.ResourceBrokerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.Broker;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker.Feedback;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker.PlanParser;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.servicebroker.PlanRequest;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;

public final class ServiceBroker
implements Broker {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private GCUBEScope scope;
    private List<GCUBERunningInstance> instances = null;
    private static final int TIMEOUT = 600000;

    @Override
    public void initialize(GCUBEScope scope) throws Exception {
        this.scope = scope;
        this.logger.info((Object)"Initializing the ServiceBroker..");
        this.instances = this.queryForBrokerInstances();
        if (this.instances.size() == 0) {
            throw new Exception("unable to find an instance of the Resource Broker in scope");
        }
        this.logger.info((Object)("Broker instances found: #" + this.instances.size()));
    }

    @Override
    public void makePlan(Session session, Set<ScopedDeployedService> services, String[] suggestedGHNs) throws Exception {
        String request = PlanRequest.create(services, suggestedGHNs, this.scope);
        this.logger.debug((Object)("Request for the Broker \n" + request));
        String plan = null;
        for (GCUBERunningInstance instance : this.instances) {
            EndpointReferenceType endpoint = instance.getAccessPoint().getEndpoint("gcube/vremanagement/ResourceBroker");
            this.logger.debug((Object)("Querying broker instance at " + endpoint.getAddress()));
            try {
                plan = this.getBrokerPT(endpoint).getPlan(request);
                this.logger.debug((Object)("Plan received from the broker \n" + plan));
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to contact the Resource Broker instance located at " + endpoint.getAddress()), (Throwable)e);
            }
        }
        PlanParser.parse(plan, services, this.scope);
        session.setDeploymentPlan(plan);
    }

    @Override
    public void sendFeedback(Session session) throws Exception {
        String feedback = Feedback.create(session);
        this.logger.debug((Object)("Feedback for the Broker \n" + feedback));
        for (GCUBERunningInstance instance : this.instances) {
            EndpointReferenceType endpoint = instance.getAccessPoint().getEndpoint("gcube/vremanagement/ResourceBroker");
            this.logger.debug((Object)("Sending broker feeback to " + endpoint.getAddress()));
            try {
                this.getBrokerPT(endpoint).handleFeedback(feedback);
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to contact the Resource Broker instance located at " + endpoint.getAddress()), (Throwable)e);
            }
        }
    }

    private List<GCUBERunningInstance> queryForBrokerInstances() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "ResourceBroker")});
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", "VREManagement")});
        return client.execute((ISQuery)lookupQuery, this.scope);
    }

    private ResourceBrokerPortType getBrokerPT(EndpointReferenceType endpoint) throws Exception {
        ResourceBrokerPortType pt = new ResourceBrokerServiceAddressingLocator().getResourceBrokerPortTypePort(endpoint);
        pt = (ResourceBrokerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)this.scope, (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
        return pt;
    }
}

