/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.brokerage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.brokerage.Broker;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedService;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;

public class InternalBroker
implements Broker {
    private final GCUBELog logger = new GCUBELog((Object)this);
    private GCUBEScope scope;
    private String[] suggestedGHNs = new String[0];
    private int nodewalker = 0;

    @Override
    public void initialize(GCUBEScope scope) throws Exception {
        this.scope = scope;
    }

    @Override
    public void makePlan(Session session, Set<ScopedDeployedService> services, String[] suggestedGHNs) throws Exception {
        this.suggestedGHNs = suggestedGHNs;
        for (ScopedDeployedService service : services) {
            try {
                this.assignTargetGHN(service);
            }
            catch (VirtualNode.NoGHNFoundException e1) {
                this.logger.error((Object)(service.getSourceService() + "Unable to find a suitable target gHN"));
                service.setStatus(ScopedResource.STATUS.LOST);
                service.setErrorMessage("Unable to find a suitable target gHN");
                throw new IOException(service.getSourceService() + " - unable to find a suitable target gHN for this service");
            }
        }
    }

    private void assignTargetGHN(ScopedDeployedService service) throws VirtualNode.NoGHNFoundException {
        if (service.getSourceService().getGHN() != null && service.getSourceService().getGHN().compareToIgnoreCase("") != 0) {
            this.logger.info((Object)("A specific GHN (" + service.getSourceService().getGHN() + ") has been requested by the caller for " + service));
            VirtualNode node = VirtualNodeManager.getNode(service.getSourceService().getGHN(), this.scope);
            node.setWorkingScope(this.scope);
            node.isNotWorking();
            service.setTargetGHN(node);
        } else if (this.suggestedGHNs.length > 0) {
            this.logger.info((Object)("A set of target GHNs " + Arrays.toString(this.suggestedGHNs) + " has been requested by the caller for " + service));
            VirtualNode node = VirtualNodeManager.getNode(this.suggestedGHNs[this.nodewalker++ % this.suggestedGHNs.length], this.scope);
            node.setWorkingScope(this.scope);
            node.isNotWorking();
            service.setTargetGHN(node);
        } else {
            this.logger.info((Object)"no GHN has been specified as explicit target");
            throw new VirtualNode.NoGHNFoundException("No GHN was assigned to the service from the caller");
        }
    }

    @Override
    public void sendFeedback(Session session) throws Exception {
    }
}

