/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl;

import java.util.HashSet;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.contexts.StatefulPortTypeContext;
import org.gcube.vremanagement.resourcemanager.impl.deployment.DeployerReport;
import org.gcube.vremanagement.resourcemanager.impl.deployment.VirtualNodeManager;
import org.gcube.vremanagement.resourcemanager.impl.operators.AddResourcesOperator;
import org.gcube.vremanagement.resourcemanager.impl.operators.DisposeScopeOperator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.operators.RemoveResourcesOperator;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.InstanceState;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.Session;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.CreateScopeParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.DisposeScopeParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.InvalidOptionsFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.InvalidScopeFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.NoSuchReportFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.OptionsParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.RemoveResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourcesCreationFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourcesRemovalFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ScopeOption;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.SendReportParameters;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class ResourceManager
extends GCUBEPortType {
    public static final String SINGLETON_RESOURCE_KEY = "VREManagerState";
    protected final GCUBELog logger = new GCUBELog((Object)this, (GCUBEContext)ServiceContext.getContext());

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public synchronized String addResources(AddResourcesParameters resourceList) throws ResourcesCreationFaultType, GCUBEFault {
        this.logger.debug((Object)("AddResources operation invoked in scope " + ServiceContext.getContext().getScope().getName()));
        try {
            GCUBEScope targetScope = this.validateOperationScope(resourceList.getTargetScope());
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.AddResources, targetScope);
            this.getResource().addSession(report);
            new AddResourcesOperator(new OperatorConfig(report, this.getResource().getResourceList(), targetScope), resourceList).run();
            return report.getId();
        }
        catch (GCUBEScopeManager.IllegalScopeException ise) {
            this.logger.error((Object)("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance"), (Throwable)ise);
            throw ServiceContext.getContext().getDefaultException("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance", ise).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to manage the input given resources(s) within the scope: " + e.getMessage()), (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to manage the input given resources(s) within the scope: " + e.getMessage(), e).toFault(new String[0]);
        }
    }

    public synchronized String removeResources(RemoveResourcesParameters resourceList) throws ResourcesRemovalFaultType, InvalidScopeFaultType {
        try {
            GCUBEScope targetScope = this.validateOperationScope(resourceList.getTargetScope());
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.RemoveResources, targetScope);
            this.getResource().addSession(report);
            new RemoveResourcesOperator(new OperatorConfig(report, this.getResource().getResourceList(), targetScope), resourceList).run();
            return report.getId();
        }
        catch (GCUBEScopeManager.IllegalScopeException ise) {
            this.logger.error((Object)("The target scope (" + resourceList.getTargetScope() + ") is not valid or null or not joined to this instance"), (Throwable)ise);
            throw new InvalidScopeFaultType();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to manage the input given resources(s) within the scope: " + e.getMessage()), (Throwable)e);
            throw new ResourcesRemovalFaultType();
        }
    }

    public synchronized String disposeScope(DisposeScopeParameters params) throws InvalidScopeFaultType, GCUBEFault {
        this.logger.info((Object)"Dispose Scope invoked... the entire scope is going to be thrown away!!");
        try {
            GCUBEScope.getScope((String)params.getName()).getServiceMap();
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            this.logger.error((Object)("Invalid scope expression " + params.getName()));
            throw new InvalidScopeFaultType();
        }
        catch (GCUBEScopeNotSupportedException e) {
            this.logger.error((Object)("Scope not supported " + params.getName()));
            throw new InvalidScopeFaultType();
        }
        try {
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.Dispose, GCUBEScope.getScope((String)params.getName()));
            this.getResource().addSession(report);
            new DisposeScopeOperator(new OperatorConfig(report, this.getResource().getResourceList(), GCUBEScope.getScope((String)params.getName()))).run();
            this.getResource().getPublishedScopeResource().dismiss();
            return report.getId();
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"No resource found for this scope", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("No resource found for this scope", e).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to dispose the scope: " + e.getMessage()), (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to dispose the scope: " + e.getMessage(), e).toFault(new String[0]);
        }
    }

    public synchronized String createScope(CreateScopeParameters params) throws InvalidScopeFaultType, InvalidOptionsFaultType, ResourcesCreationFaultType, GCUBEFault {
        String name = params.getName();
        this.logger.info((Object)("Creating the new Scope " + name));
        try {
            GCUBEScope.getScope((String)name).getServiceMap();
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new InvalidScopeFaultType();
        }
        catch (GCUBEScopeNotSupportedException e) {
            params.getServiceMap();
        }
        this.changeScopeOptions(params.getOptionsParameters());
        return this.addResources(params.getAddResourcesParameters());
    }

    public void changeScopeOptions(OptionsParameters options) throws InvalidOptionsFaultType, InvalidOptionsFaultType, GCUBEFault {
        PublishedScopeResource scoperesource = null;
        try {
            scoperesource = this.getResource().getPublishedScopeResource();
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"No resource found for this scope", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("No resource found for this scope", e).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Change Scope Options fault: ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Change Scope Options fault: ", e).toFault(new String[0]);
        }
        for (ScopeOption option : options.getScopeOptionList()) {
            if (option == null) continue;
            this.logger.trace((Object)("ScopeOption received: " + option.getName() + "=" + option.getValue()));
            try {
                scoperesource.setOption(option.getName().trim(), option.getValue().trim());
            }
            catch (PublishedScopeResource.UnknownScopeOptionException e) {
                this.logger.warn((Object)("Unknown option: " + option.getName()));
                throw new InvalidOptionsFaultType();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to read option: " + option.getName()));
                throw new InvalidOptionsFaultType();
            }
        }
        try {
            scoperesource.publish();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to publish the ScopeResouce", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to publish the ScopeResouce", e).toFault(new String[0]);
        }
    }

    public void sendReport(SendReportParameters reportMessage) throws GCUBEFault {
        this.logger.info((Object)("Received session for session " + reportMessage.getCallbackID()));
        this.logger.trace((Object)("Report content: \n" + reportMessage.getReport()));
        try {
            Session session = this.getResource().getSession(reportMessage.getCallbackID());
            DeployerReport dreport = new DeployerReport(reportMessage.getReport());
            session.addGHNReport(dreport);
            session.save();
            PublishedScopeResource resource = this.getResource().getPublishedScopeResource();
            this.logger.debug((Object)("Status session is: " + dreport.getStatus()));
            if (dreport.getStatus().compareToIgnoreCase("CLOSED") == 0) {
                this.logger.trace((Object)("Setting the gHN " + dreport.getGHNID() + " as non working"));
                VirtualNodeManager.getNode(dreport.getGHNID(), this.getResource().getManagedScope()).isNotWorking();
                this.logger.trace((Object)"Parsing running instances (if any)...");
                HashSet<ScopedResource> resources = new HashSet<ScopedResource>();
                for (DeployerReport.DeployedRunningInstance instance : dreport.getInstances()) {
                    if (instance.isAlive()) {
                        this.logger.trace((Object)("Adding instance " + instance.getRIID() + " to PublishedScopeResource"));
                        resource.addResource(instance.getInstance());
                        resources.add(instance.getInstance());
                        continue;
                    }
                    this.logger.warn((Object)("Instance " + instance.getRIID() + " not found on the IS"));
                }
                session.addDeployedInstances(dreport.getInstances());
                this.getResource().getResourceList().addResources(resources);
            }
            resource.publish();
            session.save();
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"Unable to find ResourceManager resource", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to find ResourceManager resource", e).toFault(new String[0]);
        }
        catch (ResourceException e) {
            this.logger.error((Object)"Unable to find ResourceManager resource", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to find ResourceManager resource", e).toFault(new String[0]);
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException("Unable to parse or save the Deployer Report", e).toFault(new String[0]);
        }
    }

    public String getReport(String ID) throws NoSuchReportFaultType {
        try {
            return this.getResource().getSession(ID).toXML();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to retrieve the Resource Report for ID " + ID), (Throwable)e);
            throw new NoSuchReportFaultType();
        }
    }

    private GCUBEScope validateOperationScope(String inScope) throws GCUBEScopeManager.IllegalScopeException {
        if (inScope == null || inScope.compareToIgnoreCase("") == 0) {
            return ServiceContext.getContext().getScope();
        }
        if (GCUBEScope.getScope((String)inScope.trim()).isEnclosedIn(ServiceContext.getContext().getScope())) {
            return GCUBEScope.getScope((String)inScope.trim());
        }
        throw new GCUBEScopeManager.IllegalScopeException();
    }

    private InstanceState getResource() throws NoSuchResourceException, ResourceException {
        return (InstanceState)StatefulPortTypeContext.getContext().getWSHome().find((ResourceKey)StatefulPortTypeContext.getContext().makeKey(SINGLETON_RESOURCE_KEY));
    }
}

