/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.PackageAldreadyDeployedException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.platforms.Finder;
import org.gcube.common.vremanagement.deployer.impl.platforms.PlatformApplication;
import org.gcube.common.vremanagement.deployer.impl.platforms.PlatformCall;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackage;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;

public class DPlatformApplication
extends DeployablePackage {
    private static final long serialVersionUID = -5186669147556065584L;
    protected transient Software packageprofile;
    protected transient String riid;

    DPlatformApplication(Software packagefile, PackageExtractor extractor) throws Exception {
        super((Package)packagefile, extractor);
        this.packageprofile = packagefile;
        this.analysePackage();
        this.setType(BaseTypedPackage.TYPE.PLATFORMAPPLICATION);
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        return true;
    }

    @Override
    public boolean requireRestart() {
        return false;
    }

    @Override
    public void deployPackage(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        PlatformApplication app;
        PlatformDescription packagePlatform = this.packageprofile.getTargetPlatform();
        try {
            VirtualPlatform platform = Finder.find(packagePlatform);
            this.logger.debug((Object)("Virtual Platform " + packagePlatform.toString() + " is avaliable"));
            ArrayList<File> files = new ArrayList<File>();
            for (String file : this.packageprofile.getFiles()) {
                files.add(new File(this.extractor.getPackageFilesDir() + File.separator + file));
            }
            app = new PlatformCall(platform).deployAndActivate(this, files, this.packageprofile.getEntrypoints());
        }
        catch (Finder.PlatformNotAvailableException e) {
            this.logger.error((Object)"No platform is available for this package");
            throw new DeployException("No platform is available for this package");
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to deploy", (Throwable)e);
            throw new DeployException("Failed to deploy the platform application", e);
        }
        try {
            GCUBERunningInstance instance = app.publish(targets, (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.READIED);
            this.riid = instance.getID();
            GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to publish", (Throwable)e);
            throw new DeployException("Failed to publish the platform application", e);
        }
    }

    @Override
    public Package getPackageProfile() {
        return this.packageprofile;
    }

    @Override
    public String deployApp(Set<GCUBEScope> targets) throws PackageAldreadyDeployedException, DeployException, InvalidPackageArchiveException {
        super.deploy(targets);
        return this.riid;
    }
}

