/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds;

import java.io.File;
import java.text.SimpleDateFormat;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.usecases.ws.thredds.TokenSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commons {
    private static final Logger log = LoggerFactory.getLogger(Commons.class);
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yy:HH:mm:SS");

    static void cleanupFolder(String toCleanPath, String destinationToken) {
        String toRestoreToken = TokenSetter.getCurrentToken();
        try {
            log.debug("Setting target token {} for cleanup request of path {} ", (Object)destinationToken, (Object)toCleanPath);
            TokenSetter.setToken(destinationToken);
            String hostname = Commons.getThreddsHost();
            DataTransferClient client = Commons.getDTClient(hostname);
            File toTransfer = File.createTempFile("clean", ".dt_temp");
            toTransfer.createNewFile();
            Destination dest = new Destination();
            dest.setCreateSubfolders(Boolean.valueOf(true));
            dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            dest.setOnExistingSubFolder(DestinationClashPolicy.REWRITE);
            dest.setPersistenceId("thredds");
            dest.setSubFolder("public/netcdf/" + toCleanPath);
            log.info("Going to cleanup remote folder {} on {} ", (Object)dest.getSubFolder(), (Object)hostname);
            client.localFile(toTransfer, dest);
            log.info("Done");
        }
        catch (Exception e) {
            log.error("Unable to delete remote folder " + toCleanPath, (Throwable)e);
            throw new RuntimeException("Unable to cleanup remote folder.");
        }
        finally {
            log.debug("Resetting original token {} ", (Object)toRestoreToken);
            TokenSetter.set(toRestoreToken);
        }
    }

    public static String getThreddsHost() {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'SDI'").addCondition("$resource/Profile/ServiceName/text() eq 'Thredds'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        GCoreEndpoint endpoint = (GCoreEndpoint)client.submit((Query)query).get(0);
        return ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().iterator().next()).uri().getHost();
    }

    public static DataTransferClient getDTClient(String threddsHostName) throws UnreachableNodeException, ServiceNotFoundException {
        log.debug("Getting DT Client for {} ", (Object)threddsHostName);
        return DataTransferClient.getInstanceByEndpoint((String)("http://" + threddsHostName + ":80"));
    }

    static class Constants {
        public static final String LAST_UPDATE_TIME = "WS-SYNCH.LAST_UPDATE";

        Constants() {
        }
    }
}

