/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server.cache;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheInterface;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheUtilities;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.CacheValueBean;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.UserInfrastructureSpaceCache;
import org.gcube.portlet.user.userstatisticsportlet.shared.QuotaInfo;

public class UserInfrastructureQuotaStorageCache
implements CacheInterface<String, QuotaInfo> {
    private static final Log logger = LogFactoryUtil.getLog(UserInfrastructureSpaceCache.class);
    private static UserInfrastructureQuotaStorageCache instance = new UserInfrastructureQuotaStorageCache();
    private Map<String, CacheValueBean<QuotaInfo>> userQuotaMap = new ConcurrentHashMap();
    private static final long EXPIRED_AFTER = 600000L;

    private UserInfrastructureQuotaStorageCache() {
    }

    public static UserInfrastructureQuotaStorageCache getCacheInstance() {
        return instance;
    }

    public QuotaInfo get(String key) {
        if (this.userQuotaMap.containsKey(key)) {
            CacheValueBean bean = (CacheValueBean)this.userQuotaMap.get(key);
            if (CacheUtilities.expired((long)bean.getTTL(), (long)600000L)) {
                this.userQuotaMap.remove(key);
                logger.debug((Object)("Amount of space in the infrastructure used expired for key " + key + ", returning null"));
            } else {
                return (QuotaInfo)bean.getValue();
            }
        }
        return null;
    }

    public boolean insert(String key, QuotaInfo value) {
        CacheValueBean newBean = new CacheValueBean((Object)value, System.currentTimeMillis());
        this.userQuotaMap.put(key, newBean);
        return true;
    }
}

