/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdw.datasource.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portlets.user.tdw.datasource.jdbc.JDBCCredential;
import org.gcube.portlets.user.tdw.datasource.jdbc.JDBCDataSource;
import org.gcube.portlets.user.tdw.server.datasource.DataSource;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceException;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceFactory;
import org.gcube.portlets.user.tdw.shared.model.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJDBCDataSourceFactory
implements DataSourceFactory {
    protected Logger logger = LoggerFactory.getLogger(SimpleJDBCDataSourceFactory.class);
    protected Map<String, JDBCCredential> credentials = new HashMap<String, JDBCCredential>();

    public String registerTable(String id, String jdbcdUrl, String tableName) {
        this.credentials.put(id, new JDBCCredential(id, jdbcdUrl, tableName));
        return id;
    }

    public String registerTable(String jdbcdUrl, String tableName) {
        String id = UUID.randomUUID().toString();
        this.credentials.put(id, new JDBCCredential(id, jdbcdUrl, tableName));
        return id;
    }

    public Collection<JDBCCredential> getCredentials() {
        return this.credentials.values();
    }

    public String getId() {
        return "SimpleJDBCDataSourceFactory";
    }

    public DataSource openDataSource(ASLSession session, TableId tableId) throws DataSourceException {
        String id = tableId.getTableKey();
        JDBCCredential credential = this.credentials.get(id);
        this.logger.trace("credential: " + credential);
        if (credential == null) {
            this.logger.error("No credential found for datasource id \"" + id + "\"");
            throw new DataSourceException("No credential found for datasource id \"" + id + "\"");
        }
        JDBCDataSource dataSource = JDBCDataSource.createJDBCDataSource(this.getId(), credential.getUrl(), credential.getTableName());
        return dataSource;
    }

    public void closeDataSource(ASLSession session, DataSource dataSource) throws DataSourceException {
        ((JDBCDataSource)dataSource).close();
    }
}

