/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdw.datasource.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.tdw.datasource.jdbc.dialect.SQLDialect;
import org.gcube.portlets.user.tdw.datasource.jdbc.dialect.SQLDialectManager;
import org.gcube.portlets.user.tdw.server.datasource.DataSource;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceException;
import org.gcube.portlets.user.tdw.server.datasource.Direction;
import org.gcube.portlets.user.tdw.server.datasource.util.TableJSonBuilder;
import org.gcube.portlets.user.tdw.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdw.shared.model.ColumnType;
import org.gcube.portlets.user.tdw.shared.model.TableDefinition;
import org.gcube.portlets.user.tdw.shared.model.TableId;
import org.gcube.portlets.user.tdw.shared.model.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDataSource
implements DataSource {
    public static final String JSON_ROWS_FIELD = "ROWS";
    public static final String JSON_TOTAL_LENGTH_FIELD = "total";
    public static final String JSON_OFFSET_FIELD = "offset";
    protected Logger logger = LoggerFactory.getLogger(JDBCDataSource.class);
    protected String dataSourceFactoryId;
    protected Connection connection;
    protected SQLDialect dialect;
    protected String tableName;
    protected TableDefinition tableDefinition;
    protected int tableSize = -1;
    protected Map<String, PreparedStatement> preparedStatementCache;
    protected ColumnDefinition autogeneratePrimaryColumn = null;
    protected TableJSonBuilder jsonBuilder;

    public static JDBCDataSource createJDBCDataSource(String dataSourceFactoryId, Connection connection, String tableName, SQLDialect dialect) {
        JDBCDataSource dataSource = new JDBCDataSource(dataSourceFactoryId, connection, tableName, dialect);
        return dataSource;
    }

    public static JDBCDataSource createJDBCDataSource(String dataSourceFactoryId, Connection connection, String tableName) throws DataSourceException {
        SQLDialect dialect;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            dialect = SQLDialectManager.getDialect(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        }
        catch (Exception e) {
            throw new DataSourceException("An error occurred initializing the SQL dialect", (Throwable)e);
        }
        JDBCDataSource dataSource = JDBCDataSource.createJDBCDataSource(dataSourceFactoryId, connection, tableName, dialect);
        return dataSource;
    }

    public static JDBCDataSource createJDBCDataSource(String dataSourceFactoryId, String jdbcConnectionUrl, String tableName) throws DataSourceException {
        Connection connection;
        try {
            connection = DriverManager.getConnection(jdbcConnectionUrl);
        }
        catch (SQLException e) {
            throw new DataSourceException("An error occurred initializing the DB connection", (Throwable)e);
        }
        JDBCDataSource dataSource = JDBCDataSource.createJDBCDataSource(dataSourceFactoryId, connection, tableName);
        return dataSource;
    }

    public static JDBCDataSource createJDBCDataSource(String dataSourceFactoryId, String jdbcConnectionUrl, String tableName, SQLDialect dialect) throws DataSourceException {
        Connection connection;
        try {
            connection = DriverManager.getConnection(jdbcConnectionUrl);
        }
        catch (SQLException e) {
            throw new DataSourceException("An error occurred initializing the DB connection", (Throwable)e);
        }
        JDBCDataSource dataSource = JDBCDataSource.createJDBCDataSource(dataSourceFactoryId, connection, tableName, dialect);
        return dataSource;
    }

    public JDBCDataSource(String dataSourceFactoryId, Connection connection, String tableName, SQLDialect dialect) {
        this.dataSourceFactoryId = dataSourceFactoryId;
        this.connection = connection;
        this.tableName = tableName;
        this.dialect = dialect;
        this.preparedStatementCache = new HashMap<String, PreparedStatement>();
    }

    public JDBCDataSource(String dataSourceFactoryId, Connection connection, String tableName) throws DataSourceException {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            this.dialect = SQLDialectManager.getDialect(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        }
        catch (Exception e) {
            this.logger.error("An error occurred initializing the SQL dialect", (Throwable)e);
            throw new DataSourceException("An error occurred initializing the SQL dialect", (Throwable)e);
        }
        this.dataSourceFactoryId = dataSourceFactoryId;
        this.tableName = tableName;
        this.preparedStatementCache = new HashMap<String, PreparedStatement>();
    }

    public JDBCDataSource(String dataSourceFactoryId, String jdbcConnectionUrl, String tableName) throws DataSourceException {
        try {
            this.connection = DriverManager.getConnection(jdbcConnectionUrl);
        }
        catch (SQLException e) {
            this.logger.error("An error occurred initializing the DB connection", (Throwable)e);
            throw new DataSourceException("An error occurred initializing the DB connection", (Throwable)e);
        }
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            this.dialect = SQLDialectManager.getDialect(metaData.getDatabaseProductName(), metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion());
        }
        catch (Exception e) {
            this.logger.error("An error occurred initializing the SQL dialect", (Throwable)e);
            throw new DataSourceException("An error occurred initializing the SQL dialect", (Throwable)e);
        }
        this.dataSourceFactoryId = dataSourceFactoryId;
        this.tableName = tableName;
        this.preparedStatementCache = new HashMap<String, PreparedStatement>();
    }

    public String getDataSourceFactoryId() {
        return this.dataSourceFactoryId;
    }

    public void close() throws DataSourceException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.logger.warn("An error occurred closing the database connection", (Throwable)e);
            throw new DataSourceException("An error occurred closing the database connection", (Throwable)e);
        }
    }

    public TableDefinition getTableDefinition() throws DataSourceException {
        if (this.tableDefinition == null) {
            this.tableDefinition = this.extractTableDefinition();
        }
        return this.tableDefinition;
    }

    protected TableDefinition extractTableDefinition() throws DataSourceException {
        try {
            List<ColumnDefinition> columns = this.getColumnDefinitions();
            TableId id = new TableId(this.dataSourceFactoryId, this.tableName);
            TableDefinition tableDefinition = new TableDefinition(id, this.tableName, JSON_ROWS_FIELD, JSON_TOTAL_LENGTH_FIELD, JSON_OFFSET_FIELD, columns);
            String primaryKey = this.getPrimaryKey();
            if (primaryKey == null) {
                this.autogeneratePrimaryColumn = this.createPrimaryKeyColumn(columns);
                tableDefinition.addColumn(this.autogeneratePrimaryColumn);
                primaryKey = this.autogeneratePrimaryColumn.getId();
            }
            tableDefinition.setModelKeyColumnId(primaryKey);
            return tableDefinition;
        }
        catch (SQLException e) {
            this.logger.error("An error occurred retrieving columns informations", (Throwable)e);
            throw new DataSourceException("An error occurred retrieving columns informations", (Throwable)e);
        }
    }

    protected List<ColumnDefinition> getColumnDefinitions() throws SQLException, DataSourceException {
        ResultSet columnsResultSet = this.connection.getMetaData().getColumns(null, null, this.tableName, null);
        if (!columnsResultSet.next()) {
            this.logger.error("Columns definitions for table \"" + this.tableName + "\" not found!");
            throw new DataSourceException("Columns definitions for table \"" + this.tableName + "\" not found!");
        }
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        do {
            ColumnDefinition column = this.getColumnDefinition(columnsResultSet);
            columns.add(column);
        } while (columnsResultSet.next());
        return columns;
    }

    protected ColumnDefinition getColumnDefinition(ResultSet columns) throws SQLException {
        String columnName = columns.getString("COLUMN_NAME");
        ColumnDefinition columnDefinition = new ColumnDefinition(columnName, columnName);
        int dataType = columns.getInt("DATA_TYPE");
        ValueType type = this.getValueType(dataType);
        columnDefinition.setValueType(type);
        int ordinalPosition = columns.getInt("ORDINAL_POSITION");
        columnDefinition.setPosition(ordinalPosition);
        columnDefinition.setWidth(100);
        columnDefinition.setEditable(false);
        columnDefinition.setVisible(true);
        return columnDefinition;
    }

    protected String getPrimaryKey() throws SQLException, DataSourceException {
        ResultSet columnsResultSet = this.connection.getMetaData().getPrimaryKeys(null, null, this.tableName);
        if (!columnsResultSet.next()) {
            this.logger.trace("Primary key not found");
            return null;
        }
        String primaryKeyColumnName = columnsResultSet.getString("COLUMN_NAME");
        columnsResultSet.close();
        return primaryKeyColumnName;
    }

    protected ColumnDefinition createPrimaryKeyColumn(List<ColumnDefinition> columns) {
        ArrayList<String> ids = new ArrayList<String>(columns.size());
        for (ColumnDefinition column : columns) {
            ids.add(column.getId());
        }
        String id = "idColumn";
        int i = 0;
        while (ids.contains(id)) {
            id = "idColumn" + i++;
        }
        return new ColumnDefinition(id, id, ValueType.INTEGER, -1, false, false, ColumnType.SYSTEM);
    }

    protected ValueType getValueType(int sqlType) {
        switch (sqlType) {
            case 16: {
                return ValueType.BOOLEAN;
            }
            case 91: {
                return ValueType.DATE;
            }
            case 3: {
                return ValueType.DOUBLE;
            }
            case 7: {
                return ValueType.FLOAT;
            }
            case 8: {
                return ValueType.DOUBLE;
            }
            case 6: {
                return ValueType.FLOAT;
            }
            case -5: {
                return ValueType.LONG;
            }
            case 2: 
            case 4: {
                return ValueType.INTEGER;
            }
            case 5: {
                return ValueType.BOOLEAN;
            }
            case 93: {
                return ValueType.DATE;
            }
            case 1: {
                return ValueType.STRING;
            }
            case 12: {
                return ValueType.STRING;
            }
        }
        this.logger.error("Unsupported type sqlType " + sqlType);
        return ValueType.STRING;
    }

    public String getDataAsJSon(int start, int limit, String sortingColumn, Direction direction) throws DataSourceException {
        this.logger.trace("getDataAsJSon start: " + start + " limit: " + limit + " sortingColumn: " + sortingColumn + " direction: " + direction);
        int tableSize = this.getTableSize();
        start = Math.max(0, start);
        start = Math.min(start, tableSize);
        if (start + limit > tableSize) {
            limit = tableSize - start;
        }
        this.logger.trace("checked bounds start: " + start + " limit: " + limit);
        TableDefinition tableDefinition = this.getTableDefinition();
        if (sortingColumn != null && tableDefinition.getColumns().get(sortingColumn) == null) {
            this.logger.error("The specified sorting column \"" + sortingColumn + "\" don't exists");
            throw new DataSourceException("The specified sorting column \"" + sortingColumn + "\" don't exists");
        }
        try {
            PreparedStatement preparedStatement = this.getPreparedStatement(sortingColumn, direction, start, limit);
            this.logger.trace("Querying database");
            ResultSet resultSet = preparedStatement.executeQuery();
            this.logger.trace("Processing database results");
            String json = this.getJSon(resultSet, start);
            this.logger.trace("Returning json");
            return json;
        }
        catch (SQLException e) {
            this.logger.error("An error occurred extracting json from database");
            throw new DataSourceException("An error occurred extracting json from database", (Throwable)e);
        }
    }

    protected PreparedStatement getPreparedStatement(String sortingColumn, Direction sortingDirection, int start, int limit) throws DataSourceException, SQLException {
        String key = String.valueOf(sortingDirection) + "-" + String.valueOf(sortingColumn);
        PreparedStatement preparedStatement = this.preparedStatementCache.get(key);
        if (preparedStatement == null) {
            preparedStatement = this.dialect.createDataPreparedStatement(this.connection, this.tableName, sortingColumn, sortingDirection, start, limit);
            this.preparedStatementCache.put(key, preparedStatement);
        }
        preparedStatement.clearParameters();
        this.dialect.setDataPreparedStatementParameters(preparedStatement, this.tableName, sortingColumn, sortingDirection, start, limit);
        return preparedStatement;
    }

    protected String getJSon(ResultSet resultSet, int start) throws SQLException, DataSourceException {
        TableJSonBuilder json = this.getBuilder();
        TableDefinition tableDefinition = this.getTableDefinition();
        Collection columns = tableDefinition.getColumns().values();
        json.startRows();
        int id = start;
        while (resultSet.next()) {
            json.startRow();
            block10: for (ColumnDefinition column : columns) {
                String columnId = column.getId();
                if (this.autogeneratePrimaryColumn != null && columnId.equals(this.autogeneratePrimaryColumn.getId())) {
                    json.addValue(columnId, Integer.valueOf(id));
                    continue;
                }
                switch (column.getValueType()) {
                    case BOOLEAN: {
                        Boolean b = resultSet.getBoolean(columnId);
                        json.addValue(columnId, b);
                        continue block10;
                    }
                    case DATE: {
                        Date date = resultSet.getDate(columnId);
                        json.addValue(columnId, date);
                        continue block10;
                    }
                    case DOUBLE: {
                        Double d = resultSet.getDouble(columnId);
                        json.addValue(columnId, d);
                        continue block10;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf(resultSet.getFloat(columnId));
                        json.addValue(columnId, f);
                        continue block10;
                    }
                    case INTEGER: {
                        Integer i = resultSet.getInt(columnId);
                        json.addValue(columnId, i);
                        continue block10;
                    }
                    case LONG: {
                        Long l = resultSet.getLong(columnId);
                        json.addValue(columnId, l);
                        continue block10;
                    }
                    case STRING: {
                        String s = resultSet.getString(columnId);
                        json.addValue(columnId, s);
                        continue block10;
                    }
                }
                this.logger.warn("Unknow value type " + column.getValueType());
            }
            ++id;
            json.endRow();
        }
        json.endRows();
        int tableSize = this.getTableSize();
        json.setTotalLength(tableSize);
        json.setOffset(start);
        resultSet.close();
        this.logger.trace("produced " + (id - start) + " rows");
        json.close();
        return json.toString();
    }

    protected TableJSonBuilder getBuilder() throws DataSourceException {
        if (this.jsonBuilder == null) {
            this.jsonBuilder = new TableJSonBuilder(this.getTableDefinition());
        } else {
            this.jsonBuilder.clean();
        }
        return this.jsonBuilder;
    }

    protected int getTableSize() throws DataSourceException {
        if (this.tableSize < 0) {
            this.tableSize = this.calculateTableSize();
        }
        return this.tableSize;
    }

    protected int calculateTableSize() throws DataSourceException {
        try {
            String query = this.dialect.getTableSizeQuery(this.tableName);
            this.logger.trace("table size query: " + query);
            PreparedStatement statement = this.connection.prepareStatement(query);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                this.logger.error("An error occurred calculating the table size, no results.");
                throw new DataSourceException("An error occurred calculating the table size");
            }
            int size = resultSet.getInt(1);
            resultSet.close();
            return size;
        }
        catch (SQLException e) {
            this.logger.error("An error occurred calculating the table size.", (Throwable)e);
            throw new DataSourceException("An error occurred calculating the table size", (Throwable)e);
        }
    }
}

