package org.gcube.portlets.user.td.tablewidget.client.progress;

import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;



/**
 * LabelColumnProgressDialog is a Dialog that show progress of change the column label 
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class DeleteRowsProgressDialog extends Window implements DeleteRowsProgressListener {
		public static final int STATUS_POLLING_DELAY = 1000;
		protected String WIDTH = "400px";
		protected String HEIGHT = "120px";
		protected DeleteRowsSession deleteRowsSession;
		protected EventBus eventBus;
		protected DeleteRowsProgressUpdater progressUpdater;
		protected TextButton ok;
		protected TRId trId;
		
		public DeleteRowsProgressDialog(DeleteRowsSession deleteRowsSession, EventBus eventBus) {
			this.deleteRowsSession=deleteRowsSession;
			this.eventBus=eventBus;
			setWidth(WIDTH);
			setHeight(HEIGHT);
			setBodyBorder(false);
			setResizable(true);
			setModal(true);
			setHeadingText("Delete Rows Progress");
			
			trId=null;
			
			FramedPanel panel=new FramedPanel();
			panel.setHeaderVisible(false);
			panel.setBodyBorder(false);
			
			VerticalLayoutContainer v = new VerticalLayoutContainer();
			
			
			ProgressBar progressBar = new ProgressBar();
			
			ok=new TextButton("OK");
			ok.addSelectHandler(new SelectHandler() {
				
				public void onSelect(SelectEvent event) {
					updateInvocation();
					
				}
			});
			
			v.add(progressBar, new VerticalLayoutData(1,
					1, new Margins(5, 5, 5, 5)));
			
			panel.add(v);
			panel.addButton(ok);
			add(panel);
			
			
			progressUpdater = new DeleteRowsProgressUpdater();
			progressUpdater.addListener(new DeleteRowsProgressBarUpdater(progressBar));

			progressUpdater.addListener(this);
			progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
			show();
			ok.setVisible(false);
					
		}

		public void operationInitializing() {
			// TODO Auto-generated method stub
			
		}

		public void operationUpdate(float elaborated) {
			// TODO Auto-generated method stub
			
		}

		public void operationComplete(TRId trId) {
			Log.debug("Operation Complete return: "+trId.toString());
			this.trId=trId;
			updateInvocation();
		}

		public void operationFailed(Throwable caught, String reason,
				String failureDetails) {
			ok.setVisible(true);
			this.trId=null;
			UtilsGXT3.alert("Error Deleting Rows", reason);
			
		}
		
		public void updateInvocation(){
			if(trId!=null){
				ChangeTableRequestEvent changeTableRequestEvent=
						new ChangeTableRequestEvent(ChangeTableRequestType.DELETEROWS, trId);
				eventBus.fireEvent(changeTableRequestEvent);
			}
			hide();
		}

		@Override
		public void operationStopped(TRId trId,String reason, String details) {
			Log.debug("Operation Stopped: ["+trId.toString()+", "+reason+", "+details+"]");
			ok.setVisible(true);
			this.trId=trId;
		}
}
