package org.gcube.portlets.user.td.tablewidget.client.validation;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.Validations;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.tablewidget.client.properties.ValidationsProperties;
import org.gcube.portlets.user.td.tablewidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.tablewidget.client.util.UtilsGXT3;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ValidationsTablePanel extends FramedPanel {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";

	protected TRId trId;
	protected TableData table;
	protected String headingTitle;
	protected VerticalLayoutContainer vl;
	protected EventBus eventBus;

	protected ComboBox<Validations> comboValidations;
	protected ListStore<Validations> storeValidations;
	protected ListLoader<ListLoadConfig, ListLoadResult<Validations>> loader;
	protected Grid<Validations> grid;

	public ValidationsTablePanel(TRId trId, EventBus eventBus) {
		super();
		this.trId = trId;
		this.eventBus = eventBus;
		forceLayoutOnResize = true;
		init();
		create();
	}

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void create() {
		ValidationsProperties props = GWT.create(ValidationsProperties.class);

		ColumnConfig<Validations, String> descriptionCol = new ColumnConfig<Validations, String>(
				props.description(), 168, "Description");
		ColumnConfig<Validations, Boolean> validCol = new ColumnConfig<Validations, Boolean>(
				props.valid(), 32, "Valid");
		validCol.setCell(new AbstractCell<Boolean>() {

			@Override
			public void render(Context context, Boolean value,
					SafeHtmlBuilder sb) {

				if (value) {
					sb.appendHtmlConstant("<img src='"
							+ ResourceBundle.INSTANCE.ok().getSafeUri()
									.asString() + "' alt='true'>");

				} else {
					sb.appendHtmlConstant("<img src='"
							+ ResourceBundle.INSTANCE.exit().getSafeUri()
									.asString() + "' alt='true'>");

				}

			}
		});

		List<ColumnConfig<Validations, ?>> l = new ArrayList<ColumnConfig<Validations, ?>>();
		l.add(descriptionCol);
		l.add(validCol);

		ColumnModel<Validations> cm = new ColumnModel<Validations>(l);

		storeValidations = new ListStore<Validations>(props.id());

		RpcProxy<ListLoadConfig, ListLoadResult<Validations>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<Validations>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<Validations>> callback) {
				loadData(loadConfig, callback);
			}

		};

		loader = new ListLoader<ListLoadConfig, ListLoadResult<Validations>>(
				proxy);

		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, Validations, ListLoadResult<Validations>>(
				storeValidations) {
		});

		grid = new Grid<Validations>(storeValidations, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {

					public void execute() {
						loader.load();
					}
				});
			}
		};

		grid.setLoader(loader);
		grid.setHeight(360);
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.getView().setAutoFill(true);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);
		grid.setColumnResize(true);
		grid.getView().setAutoExpandColumn(descriptionCol);
		grid.getView().setEmptyText("No validation");

		// FieldLabel validationsLabel = new FieldLabel(null, "Validations");
		// validationsLabel.getElement().applyStyles("font-weight:bold");

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.setScrollMode(ScrollMode.AUTO);
		// v.add(validationsLabel, new VerticalLayoutData(-1, -1, new
		// Margins(2,1,5,1)));
		v.add(grid, new VerticalLayoutData(1, -1, new Margins(0)));
		add(v);

	}

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<Validations>> callback) {

		TDGWTServiceAsync.INSTANCE.getTableValidationsMetadata(trId,
				new AsyncCallback<TabValidationsMetadata>() {

					public void onFailure(Throwable caught) {
						Log.error("Load validations metadata failure: "
								+ caught.getLocalizedMessage());
						UtilsGXT3.alert(
								"Error retrieving validations metadata",
								"Error retrieving validations metadata");
						callback.onFailure(caught);
					}

					public void onSuccess(TabValidationsMetadata result) {
						Log.debug("loaded " + result.getId());
						if (result.getValidations() != null) {
								Log.debug("Validations Retrieved: "
										+ result.getValidations().size());
								callback.onSuccess(new ListLoadResultBean<Validations>(
										result.getValidations()));
							} else {
								Log.debug("No validations");
								ArrayList<Validations> empty=new ArrayList<Validations>();
								callback.onSuccess(new ListLoadResultBean<Validations>(
									empty));
							}
						
					}

				});

	}

	public void update(TRId trId) {
		this.trId = trId;
		loader.load();
	}

}
