/**
 * 
 */
package org.gcube.portlets.user.td.tablewidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class DeleteRowsProgressUpdater extends Timer {

	protected ArrayList<DeleteRowsProgressListener> listeners = new ArrayList<DeleteRowsProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getDeleteRowsMonitor(new AsyncCallback<DeleteRowsMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(DeleteRowsMonitor result) {
						Log.info("retrieved DeleteRowsMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Delete Rows Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationUpdate(result.getProgress());
							break;	
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(DeleteRowsMonitor result) {
		Log.info("Delete Rows Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Delete Rows";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Delete Rows";
			details = "Delete Rows failed";
		}
		
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(DeleteRowsMonitor result) {
		Log.info("Delete Rows Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped deleting rows";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped deleting rows";
			details = "Delete Rows stopped";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (DeleteRowsProgressListener listener : listeners)
			listener.operationInitializing();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (DeleteRowsProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (DeleteRowsProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (DeleteRowsProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (DeleteRowsProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	
	
	/**
	 * Add a new {@link DeleteRowsProgressListener} to this
	 * {@link DeleteRowsProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(DeleteRowsProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link DeleteRowsProgressListener} from this
	 * {@link DeleteRowsProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(DeleteRowsProgressListener listener) {
		listeners.remove(listener);
	}
}
