/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */

public interface TDGWTServiceAsync {

	public static TDGWTServiceAsync INSTANCE = (TDGWTServiceAsync) GWT
			.create(TDGWTService.class);

	void createTabularResource(TabResource tabResource,AsyncCallback<TabResource> callback);
	
	void getTabResourceInformation(AsyncCallback<TabResource> callback);
	
	void getTabResourceInformation(TRId trId,AsyncCallback<TabResource> callback);
	
	void getTRCreationDate(TRId trId,AsyncCallback<String> callback);
	
    void setTabResource(TabResource tabResource, AsyncCallback<Void> callback);
	
    void getTabularResources(AsyncCallback<ArrayList<TabResource>> callback);
    
    void getLastTable(TRId trId, AsyncCallback<TableData> callback);
	
    void getTableMetadata(TRId trId, AsyncCallback<ArrayList<TabMetadata>> callback);
    
    void getTRMetadata(TRId trId, AsyncCallback<ArrayList<TRMetadata>> callback);
    
    void getColumns(AsyncCallback<ArrayList<ColumnData>> callback);
    
    void getColumns(TRId trId, AsyncCallback<ArrayList<ColumnData>> callback);
    
    void getColumn(TRId trId, String columnName, AsyncCallback<ColumnData> callback);
    
    void removeTabularResource(TRId trId, AsyncCallback<Void> callback);
    
    
    //CodelistPagingLoaded
	void setCodelistsPagingLoader(AsyncCallback<Void> callback);

	void getCodelistsPagingLoader(
			CodelistPagingLoadConfig codelistPagingLoadConfig,
			AsyncCallback<CodelistPagingLoadResult> callback);

    //Open
    void startTDOpen(TDOpenSession tdOpenSession, AsyncCallback<Void> callback);
	
    //SDMX
    void getCodelists(AsyncCallback<ArrayList<Codelist>> callback);

	void getDatasets(AsyncCallback<ArrayList<Dataset>> callback);
	
	void getAgencies(AsyncCallback<ArrayList<Agencies>> callback);
	
	void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource, AsyncCallback<Void> callback);
	
	//Import SDMX 
	void getSDMXImportMonitor(AsyncCallback<SDMXImportMonitor> callback);
	
	void startSDMXImport(SDMXImportSession sdmxImportSession,AsyncCallback<Void> callback);
    
	//Import CSV
	void getFileUploadMonitor(AsyncCallback<FileUploadMonitor> callback);
	
	void getCSVImportMonitor(AsyncCallback<CSVImportMonitor> callback);
	
	void setCSVSession(CSVImportSession csvImportSession, AsyncCallback<Void> callback);

	void getFileFromWorkspace(CSVImportSession csvImportSession, AsyncCallback<Void> callback);

	void getAvailableCharset(AsyncCallback<AvailableCharsetList> callback);
	
	void configureCSVParser(String encoding, HeaderPresence headerPresence, char delimiter, char comment, AsyncCallback<ArrayList<String>> callback);
	
	void checkCSV(long errorsLimit, AsyncCallback<ArrayList<CSVRowError>> callback);
	
	void startCSVImport(CSVImportSession csvImportSession, AsyncCallback<Void> callback);
	
	//Export CSV
	void getCSVExportMonitor(AsyncCallback<CSVExportMonitor> callback);
	
	void startCSVExport(CSVExportSession csvExportSession, AsyncCallback<Void> callback);
	
	//Export SDMX
	void getSDMXExportMonitor(AsyncCallback<SDMXExportMonitor> callback);

	void startSDMXExport(SDMXExportSession exportSession, AsyncCallback<Void> callback);
	
	
	//Column Operation 
	void getChangeColumnTypeMonitor(AsyncCallback<ChangeColumnTypeMonitor> callback);
	void startChangeColumnType(ChangeColumnTypeSession changeColumnTypeSession,AsyncCallback<Void> callback);
	void getDeleteColumnMonitor(AsyncCallback<DeleteColumnMonitor> callback);
	void startDeleteColumn(DeleteColumnSession deleteColumnSession,AsyncCallback<Void> callback);
	void getLabelColumnMonitor(AsyncCallback<LabelColumnMonitor> callback);
	void startLabelColumn(LabelColumnSession labelColumnSession,AsyncCallback<Void> callback);	
	
	
}
