package org.gcube.portlets.user.td.gwtservice.shared.sdmx;

import java.io.Serializable;

import org.gcube.portlets.user.td.gwtservice.shared.State;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class SDMXExportMonitor implements Serializable {
	
	private static final long serialVersionUID = -5998841163159590481L;
	
	protected float progress;
	protected State status;
	protected String statusDescription;
	protected Throwable error;
	protected String url;
	
	public float getProgress(){
		return progress;
	};

	public State getStatus(){
		return status;
	}
	
	public String getStatusDescription(){
		return statusDescription;
	}

	public void setProgress(float progress) {
		this.progress = progress;
	}

	public void setStatus(State status) {
		this.status = status;
	}
	
	public void setStatus(int status) {
		this.status = State.values()[status];
	}

	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	public Throwable getError() {
		return error;
	}

	public void setError(Throwable error) {
		this.error = error;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String toString() {
		return "SDMXExportMonitor [progress=" + progress + ", status=" + status
				+ ", statusDescription=" + statusDescription + ", error="
				+ error + ", url=" + url + "]";
	}

	
	
}
