/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.shared.csv;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

import org.gcube.portlets.user.td.gwtservice.shared.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.source.Source;



/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class CSVImportSession implements Serializable {

	private static final long serialVersionUID = 4176034045408445284L;
	
	protected String id;
	protected Source source;
	
	protected TabResource tabResource;
	
	protected ArrayList<String> headers = new ArrayList<String>();
	
	protected boolean skipInvalidLines = false;
	
	protected boolean[] columnToImportMask;
	
	protected String localFileName;
	protected long fileLenght;
	protected String serverlFileName;
	
	protected String csvTitle;
	protected String csvDescription;
	protected String csvSource;
	protected String csvRights;
	
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public Source getSource() {
		return source;
	}
	public void setSource(Source source) {
		this.source = source;
	}
	public TabResource getTabResource() {
		return tabResource;
	}
	public void setTabResource(TabResource tabResource) {
		this.tabResource = tabResource;
	}
	public ArrayList<String> getHeaders() {
		return headers;
	}
	public void setHeaders(ArrayList<String> headers) {
		this.headers = headers;
	}
	public boolean isSkipInvalidLines() {
		return skipInvalidLines;
	}
	public void setSkipInvalidLines(boolean skipInvalidLines) {
		this.skipInvalidLines = skipInvalidLines;
	}
	public boolean[] getColumnToImportMask() {
		return columnToImportMask;
	}
	public void setColumnToImportMask(boolean[] columnToImportMask) {
		this.columnToImportMask = columnToImportMask;
	}
	public String getLocalFileName() {
		return localFileName;
	}
	public void setLocalFileName(String localFileName) {
		this.localFileName = localFileName;
	}
	public long getFileLenght() {
		return fileLenght;
	}
	public void setFileLenght(long fileLenght) {
		this.fileLenght = fileLenght;
	}
	public String getServerlFileName() {
		return serverlFileName;
	}
	public void setServerlFileName(String serverlFileName) {
		this.serverlFileName = serverlFileName;
	}
	public String getCsvTitle() {
		return csvTitle;
	}
	public void setCsvTitle(String csvTitle) {
		this.csvTitle = csvTitle;
	}
	public String getCsvDescription() {
		return csvDescription;
	}
	public void setCsvDescription(String csvDescription) {
		this.csvDescription = csvDescription;
	}
	public String getCsvSource() {
		return csvSource;
	}
	public void setCsvSource(String csvSource) {
		this.csvSource = csvSource;
	}
	public String getCsvRights() {
		return csvRights;
	}
	public void setCsvRights(String csvRights) {
		this.csvRights = csvRights;
	}
	@Override
	public String toString() {
		return "CSVImportSession [id=" + id + ", source=" + source
				+ ", tabResource=" + tabResource + ", headers=" + headers
				+ ", skipInvalidLines=" + skipInvalidLines
				+ ", columnToImportMask=" + Arrays.toString(columnToImportMask)
				+ ", localFileName=" + localFileName + ", fileLenght="
				+ fileLenght + ", serverlFileName=" + serverlFileName
				+ ", csvTitle=" + csvTitle + ", csvDescription="
				+ csvDescription + ", csvSource=" + csvSource + ", csvRights="
				+ csvRights + "]";
	}
	

}
