/**
 * 
 */
package org.gcube.portlets.user.td.gwtservice.client.rpc;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.Dataset;
import org.gcube.portlets.user.td.gwtservice.shared.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */

public interface TDGWTServiceAsync {

	public TDGWTServiceAsync INSTANCE = (TDGWTServiceAsync) GWT
			.create(TDGWTService.class);

	void createTabularResource(TabResource tabResource,AsyncCallback<TabResource> callback);
	
	void getTabResourceInformation(AsyncCallback<TabResource> callback);
	
    void setTabResource(TabResource tabResource, AsyncCallback<Void> callback);
	
    void getTabularResources(AsyncCallback<List<TabResource>> callback);
	
    //Open
    void setTDOpenSession(TDOpenSession s, AsyncCallback<Void> callback);
	
    //Import SDMX
    void getCodelists(AsyncCallback<ArrayList<Codelist>> callback);

	void getDatasets(AsyncCallback<ArrayList<Dataset>> callback);
	
	void getAgencies(AsyncCallback<ArrayList<Agencies>> callback);
	
	void setSDMXSession(SDMXImportSession s, AsyncCallback<Void> callback);
	
	void getSDMXImportMonitor(AsyncCallback<SDMXImportMonitor> callback);
	
	void startSDMXImport(SDMXImportSession s,AsyncCallback<Void> callback);
    
	//Import CSV
	void getFileUploadMonitor(AsyncCallback<FileUploadMonitor> callback);
	
	void getCSVImportMonitor(AsyncCallback<CSVImportMonitor> callback);
	
	void setCSVSession(CSVImportSession s, AsyncCallback<Void> callback);
	
	
	void getAvailableCharset(AsyncCallback<AvailableCharsetList> callback);
	
	void configureCSVParser(String encoding, HeaderPresence headerPresence, char delimiter, char comment, AsyncCallback<ArrayList<String>> callback);
	
	void checkCSV(long errorsLimit, AsyncCallback<ArrayList<CSVRowError> > callback);
	
	void startCSVImport(CSVImportSession s, AsyncCallback<Void> callback);
	

}
