package org.gcube.portlets.user.td.expressionwidget.shared.model.logical;

import org.gcube.portlets.user.td.expressionwidget.shared.model.C_OperatorType;
import org.gcube.portlets.user.td.expressionwidget.shared.model.leaf.C_Range;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class C_Between extends C_Expression {

	private static final long serialVersionUID = 5367101215792568854L;
	protected String id = "Between";
	protected C_Expression leftArgument;
	protected C_Range rightArgument;

	public C_Between(){
		
	}
	
	public C_Between(C_Expression leftArgument, C_Range rightArgument) {
		this.leftArgument = leftArgument;
		this.rightArgument = rightArgument;
	}

	public C_OperatorType getOperator() {		
		return C_OperatorType.BETWEEN;
	}
	
	public String getReturnedDataType() {		
		return "Boolean";
	}
	
	@Override
	public String getId() {
		return id;
	}

	public C_Expression getLeftArgument() {
		return leftArgument;
	}

	public void setLeftArgument(C_Expression leftArgument) {
		this.leftArgument = leftArgument;
	}

	public C_Range getRightArgument() {
		return rightArgument;
	}

	public void setRightArgument(C_Range rightArgument) {
		this.rightArgument = rightArgument;
	}

	@Override
	public String toString() {
		return "Between [id=" + id + ", leftArgument=" + leftArgument
				+ ", rightArgument=" + rightArgument + "]";
	}
	
	
	
}
