package org.gcube.portlets.user.td.expressionwidget.client.progress;

import org.gcube.portlets.user.td.expressionwidget.client.ColumnFilterDialog;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;



/**
 * ColumnFilterProgressDialog is a Dialog that show progress of change the column label 
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnFilterProgressDialog extends Window implements ColumnFilterProgressListener {
		public static final int STATUS_POLLING_DELAY = 1000;
		protected String WIDTH = "400px";
		protected String HEIGHT = "140px";
		protected EventBus eventBus;
		protected ColumnFilterProgressUpdater progressUpdater;
		protected TextButton ok;
		protected TRId trId;
		protected ColumnFilterDialog dialog;
		private ChangeTableWhy why;
		
		public ColumnFilterProgressDialog(ColumnFilterDialog dialog,EventBus eventBus) {
			this.dialog=dialog;
			this.eventBus=eventBus;
			setWidth(WIDTH);
			setHeight(HEIGHT);
			setBodyBorder(false);
			setResizable(true);
			setModal(true);
			setHeadingText("Column Filter Progress");
			
			trId=null;
			
			FramedPanel panel=new FramedPanel();
			panel.setHeaderVisible(false);
			panel.setBodyBorder(false);
			
			VerticalLayoutContainer v = new VerticalLayoutContainer();
			
			
			ProgressBar progressBar = new ProgressBar();
			
			
			ok=new TextButton("OK");
			ok.addSelectHandler(new SelectHandler() {
				
				public void onSelect(SelectEvent event) {
					updateInvocation();
					
				}
			});
			
			v.add(progressBar, new VerticalLayoutData(1,
					1, new Margins(5, 5, 5, 5)));
			
			panel.add(v);
			panel.addButton(ok);
			add(panel);
			
			
			progressUpdater = new ColumnFilterProgressUpdater();
			progressUpdater.addListener(new ColumnFilterProgressBarUpdater(progressBar));

			progressUpdater.addListener(this);
			progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
			
			show();
			ok.setVisible(false);
					
		}

		public void operationInitializing() {
			// TODO Auto-generated method stub
			
		}

		public void operationUpdate(float elaborated) {
			// TODO Auto-generated method stub
			
		}

		public void operationComplete(TRId trId) {
			Log.debug("Operation Complete return: "+trId.toString());
			this.trId=trId;
			why=ChangeTableWhy.TABLEUPDATED;
			updateInvocation();
		}

		public void operationFailed(Throwable caught, String reason,
				String failureDetails) {
			ok.setVisible(true);
			this.trId=null;
			AlertMessageBox d = new AlertMessageBox("Error Applying Column Filter", reason);
			d.addHideHandler(new HideHandler() {
				public void onHide(HideEvent event) {	
				}
			});
			d.show();
		}
		
		public void updateInvocation(){
			if(trId!=null){
				ChangeTableRequestEvent changeTableRequestEvent=
						new ChangeTableRequestEvent(ChangeTableRequestType.COLUMNFILTER, trId,why);
				eventBus.fireEvent(changeTableRequestEvent);
			}
			dialog.hide();
			hide();
		}
		
		@Override
		public void operationStopped(TRId trId,String reason, String details) {
			Log.debug("Operation Stopped: ["+trId.toString()+", "+reason+", "+details+"]");
			ok.setVisible(true);
			this.trId=trId;
			why=ChangeTableWhy.TABLECURATION;
		}

		@Override
		public void operationGeneratingView() {
			// TODO Auto-generated method stub
			
		}

		@Override
		public void operationValidate(float elaborated) {
			// TODO Auto-generated method stub
			
		}
}
