package org.gcube.portlets.user.td.columnwidget.client.progress;

import org.gcube.portlets.user.td.columnwidget.client.replace.ReplaceDialog;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * ReplaceColumnProgressDialog is a Dialog that show progress of replace the
 * column value
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceColumnProgressDialog extends Window implements
		ReplaceColumnProgressListener {
	public static final int STATUS_POLLING_DELAY = 1000;
	protected String WIDTH = "400px";
	protected String HEIGHT = "120px";
	protected ReplaceDialog parent;
	protected EventBus eventBus;
	protected ReplaceColumnProgressUpdater progressUpdater;
	protected TextButton ok;
	protected TRId trId;
	private ChangeTableWhy why;

	public ReplaceColumnProgressDialog(ReplaceDialog replaceDialog,
			EventBus eventBus) {
		this.parent = replaceDialog;
		this.eventBus = eventBus;
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(true);
		setModal(true);
		setHeadingText("Replace The Column Value Progress");

		trId = null;

		FramedPanel panel = new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);

		VerticalLayoutContainer v = new VerticalLayoutContainer();

		ProgressBar progressBar = new ProgressBar();

		ok = new TextButton("OK");
		ok.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				updateInvocation();

			}
		});

		v.add(progressBar,
				new VerticalLayoutData(1, 1, new Margins(5, 5, 5, 5)));

		panel.add(v);
		panel.addButton(ok);
		add(panel);

		progressUpdater = new ReplaceColumnProgressUpdater();
		progressUpdater.addListener(new ReplaceColumnProgressBarUpdater(
				progressBar));

		progressUpdater.addListener(this);
		progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
		show();
		ok.setVisible(false);

	}

	public void operationInitializing() {
		// TODO Auto-generated method stub

	}

	public void operationUpdate(float elaborated) {
		// TODO Auto-generated method stub

	}

	public void operationComplete(TRId trId) {
		Log.debug("Operation Complete return: " + trId.toString());
		this.trId = trId;
		why = ChangeTableWhy.TABLEUPDATED;
		updateInvocation();
	}

	public void operationFailed(Throwable caught, String reason,
			String failureDetails) {
		if (caught instanceof TDGWTSessionExpiredException) {
			eventBus.fireEvent(new SessionExpiredEvent(
					SessionExpiredType.EXPIREDONSERVER));
		} else {
			ok.setVisible(true);
			this.trId = null;
			UtilsGXT3.alert("Error Replacing The Column Value", reason);
		}
	}

	public void updateInvocation() {
		if (trId != null) {
			ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
					ChangeTableRequestType.COLUMNREPLACE, trId, why);
			eventBus.fireEvent(changeTableRequestEvent);
		}
		parent.hide();
		hide();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		Log.debug("Operation Stopped: [" + trId.toString() + ", " + reason
				+ ", " + details + "]");
		ok.setVisible(true);
		this.trId = trId;
		why = ChangeTableWhy.TABLECURATION;
	}

	@Override
	public void operationGeneratingView() {
		// TODO Auto-generated method stub

	}

	@Override
	public void operationValidate(float elaborated) {
		// TODO Auto-generated method stub

	}
}
