package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.ProgressBar;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * TaskResubmitProgressDialog is a Dialog that show progress of resubmit a Task
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class TaskResubmitProgressDialog extends Window implements
		TaskResubmitProgressListener  {
	protected ArrayList<ResubmitDialogListener> listeners = new ArrayList<ResubmitDialogListener>();
	
	public static final int STATUS_POLLING_DELAY = 1000;
	protected String WIDTH = "400px";
	protected String HEIGHT = "120px";
	protected EventBus eventBus;
	protected TaskResubmitProgressUpdater progressUpdater;
	protected TextButton ok;
	protected TRId trId;
	private String reason;

	private String details;

	public TaskResubmitProgressDialog(
			EventBus eventBus) {
		this.eventBus = eventBus;
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(true);
		setModal(true);
		setHeadingText("Task Resubmit Progress");

		trId = null;

		FramedPanel panel = new FramedPanel();
		panel.setHeaderVisible(false);
		panel.setBodyBorder(false);

		VerticalLayoutContainer v = new VerticalLayoutContainer();

		ProgressBar progressBar = new ProgressBar();

		ok = new TextButton("OK");
		ok.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				updateInvocation();

			}
		});

		v.add(progressBar,
				new VerticalLayoutData(1, 1, new Margins(5, 5, 5, 5)));

		panel.add(v);
		panel.addButton(ok);
		add(panel);

		progressUpdater = new TaskResubmitProgressUpdater();
		progressUpdater.addListener(new TaskResubmitProgressBarUpdater(
				progressBar));

		progressUpdater.addListener(this);
		progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
		show();
		ok.setVisible(false);

	}
	
	public void addResubmitDialogListener(ResubmitDialogListener listener) {
		listeners.add(listener);
	}
	
	public void removeResubmitDialogListener(ResubmitDialogListener listener) {
		listeners.remove(listener);
	}
	
	@Override
	public void operationInitializing() {
		// TODO Auto-generated method stub

	}

	@Override
	public void operationUpdate(float elaborated) {
		// TODO Auto-generated method stub

	}

	@Override
	public void operationComplete(TRId trId) {
		Log.debug("Operation Complete return: " + trId.toString());
		this.trId = trId;
		fireResubmitComplete(trId);
		hide();
	}

	@Override
	public void operationFailed(Throwable caught, String reason,
			String failureDetails) {
		if (caught instanceof TDGWTSessionExpiredException) {
			eventBus.fireEvent(new SessionExpiredEvent(
					SessionExpiredType.EXPIREDONSERVER));
		} else {
			fireResubmitFailed(caught,reason);
			hide();
			
		}
	}

	public void updateInvocation() {
		if (trId != null) {
			fireResubmitStopped(trId, reason, details);
		}
		hide();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		Log.debug("Operation Stopped: [" + trId.toString() + ", " + reason
				+ ", " + details + "]");
		this.trId = trId;
		this.reason=reason;
		this.details=details;
		ok.setVisible(true);
		
	}

	@Override
	public void operationGeneratingView() {
		// TODO Auto-generated method stub

	}

	@Override
	public void operationValidate(float elaborated) {
		// TODO Auto-generated method stub

	}
	
	
	protected void fireResubmitComplete(TRId trId) {
		for (ResubmitDialogListener listener : listeners)
			listener.resubmitComplete(trId);
	}

	protected void fireResubmitFailed(Throwable caught, String reason) {
		for (ResubmitDialogListener listener : listeners)
			listener.resubmitFailed(caught, reason);
	}
	
	protected void fireResubmitStopped(TRId trId, String reason, String details) {
		for (ResubmitDialogListener listener : listeners)
			listener.resubmitStopped(trId,reason, details);
	}
	
	
}
