package org.gcube.portlets.user.td.columnwidget.client.create;

import java.util.ArrayList;
import java.util.Date;

import org.gcube.portlets.user.td.columnwidget.client.dimension.CodelistSelectionDialog;
import org.gcube.portlets.user.td.columnwidget.client.dimension.CodelistSelectionListener;
import org.gcube.portlets.user.td.columnwidget.client.progress.AddColumnProgressDialog;
import org.gcube.portlets.user.td.columnwidget.client.progress.ProgressDialogListener;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnTypeCodeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.LocaleTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.TabResourceProperties;
import org.gcube.portlets.user.td.columnwidget.client.properties.TimeDimensionTypeProperties;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnDataTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.ColumnTypeCodeStore;
import org.gcube.portlets.user.td.columnwidget.client.store.LocaleTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.TimeDimensionTypeElement;
import org.gcube.portlets.user.td.columnwidget.client.store.TimeDimensionTypeStore;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DefNewColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.TimeDimensionType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.ButtonCell.IconAlign;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent;
import com.sencha.gxt.widget.core.client.event.TriggerClickEvent.TriggerClickHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class AddColumnPanel extends FramedPanel implements
		CodelistSelectionListener, ProgressDialogListener {
	protected static final String WIDTH = "640px";
	protected static final String HEIGHT = "520px";

	protected EventBus eventBus;
	protected AddColumnDialog parent;
	protected TRId trId;

	protected AddColumnPanel thisPanel;

	protected ComboBox<ColumnTypeCodeElement> comboColumnTypeCode = null;
	protected FieldLabel comboColumnTypeCodeLabel;

	protected ComboBox<ColumnDataTypeElement> comboMeasureType = null;
	protected FieldLabel comboMeasureTypeLabel;

	protected ComboBox<ColumnDataTypeElement> comboAttributeType = null;
	protected FieldLabel comboAttributeTypeLabel;

	protected ComboBox<TabResource> comboDimensionType = null;
	protected FieldLabel comboDimensionTypeLabel;

	protected ComboBox<ColumnData> comboColumnReferenceType = null;
	protected FieldLabel comboColumnReferenceTypeLabel;
	protected ListStore<ColumnData> storeComboColumnReferenceType;

	protected ComboBox<TimeDimensionTypeElement> comboTimeDimensionType = null;
	protected FieldLabel comboTimeDimensionTypeLabel;

	protected ComboBox<LocaleTypeElement> comboLocaleType = null;
	protected FieldLabel comboLocaleTypeLabel;
	protected ListStore<LocaleTypeElement> storeComboLocaleType;

	protected AddColumnSession addColumnSession;
	protected AddColumnProgressDialog addColumnProgressDialog;

	protected TextButton btnAddColumn;

	protected TextField label;
	protected TextField defaultValueString;
	protected DateField defaultValueDate;
	
	protected FieldLabel defaultStringLabel;
	protected FieldLabel defaultDateLabel;
	
	
	private DateTimeFormat sdf = DateTimeFormat.getFormat("yyyy-MM-dd");

	/**
	 * 
	 * @param parent
	 * @param eventBus
	 */
	public AddColumnPanel(AddColumnDialog parent, TRId trId, EventBus eventBus) {
		super();
		Log.debug("CreateDefColumnPanel[parent: " + parent + ", trId: " + trId);
		this.thisPanel = this;
		this.parent = parent;
		this.eventBus = eventBus;
		this.trId = trId;
		init();
		create();
	}
	
	/**
	 * 
	 * @param parent
	 * @param eventBus
	 */
	public AddColumnPanel(TRId trId, EventBus eventBus) {
		super();
		Log.debug("CreateDefColumnPanel[trId: " + trId);
		this.thisPanel = this;
		this.eventBus = eventBus;
		this.trId = trId;
		init();
		create();
	}
	

	protected void init() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void create() {
		// Label
		label = new TextField();
		
		//TODO
		// Default Value
		defaultValueString = new TextField();
		defaultStringLabel= new FieldLabel(defaultValueString, "Default");
	    
		defaultValueDate = new DateField();
		defaultDateLabel = new FieldLabel(defaultValueDate, "Default");
	
		
		// comboColumnTypeCode
		ColumnTypeCodeProperties propsColumnTypeCode = GWT
				.create(ColumnTypeCodeProperties.class);
		ListStore<ColumnTypeCodeElement> storeComboTypeCode = new ListStore<ColumnTypeCodeElement>(
				propsColumnTypeCode.id());
		storeComboTypeCode.addAll(ColumnTypeCodeStore.getColumnTypeCodesForAddColumn(trId));

		comboColumnTypeCode = new ComboBox<ColumnTypeCodeElement>(
				storeComboTypeCode, propsColumnTypeCode.label());
		Log.trace("ComboColumnTypeCode created");

		addHandlersForComboColumnTypeCode(propsColumnTypeCode.label());

		comboColumnTypeCode.setEmptyText("Select a column type...");
		comboColumnTypeCode.setWidth(191);
		comboColumnTypeCode.setTypeAhead(true);
		comboColumnTypeCode.setTriggerAction(TriggerAction.ALL);

		// comboMeasureType
		ColumnDataTypeProperties propsMeasureType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboMeasureType = new ListStore<ColumnDataTypeElement>(
				propsMeasureType.id());
		storeComboMeasureType.addAll(ColumnDataTypeStore.getMeasureType());

		comboMeasureType = new ComboBox<ColumnDataTypeElement>(
				storeComboMeasureType, propsMeasureType.label());
		Log.trace("ComboMeasureType created");

		addHandlersForComboMeasureType(propsMeasureType.label());

		comboMeasureType.setEmptyText("Select a measure type...");
		comboMeasureType.setWidth(191);
		comboMeasureType.setTypeAhead(true);
		comboMeasureType.setTriggerAction(TriggerAction.ALL);

		comboMeasureTypeLabel = new FieldLabel(comboMeasureType, "Measure Type");

		// comboAttributeType
		ColumnDataTypeProperties propsAttributeType = GWT
				.create(ColumnDataTypeProperties.class);
		ListStore<ColumnDataTypeElement> storeComboAttributeType = new ListStore<ColumnDataTypeElement>(
				propsAttributeType.id());
		storeComboAttributeType.addAll(ColumnDataTypeStore.getAttributeType());

		comboAttributeType = new ComboBox<ColumnDataTypeElement>(
				storeComboAttributeType, propsAttributeType.label());
		Log.trace("ComboAttributeType created");

		addHandlersForComboAttributeType(propsAttributeType.label());

		comboAttributeType.setEmptyText("Select a column type...");
		comboAttributeType.setWidth(191);
		comboAttributeType.setTypeAhead(true);
		comboAttributeType.setTriggerAction(TriggerAction.ALL);

		comboAttributeTypeLabel = new FieldLabel(comboAttributeType,
				"Attribute Type");

		// comboLocaleType
		LocaleTypeProperties propsLocaleType = GWT
				.create(LocaleTypeProperties.class);
		storeComboLocaleType = new ListStore<LocaleTypeElement>(
				propsLocaleType.id());

		comboLocaleType = new ComboBox<LocaleTypeElement>(storeComboLocaleType,
				propsLocaleType.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						retriveLocales();
					}
				});
			}
		};
		Log.trace("ComboLocaleType created");

		addHandlersForComboLocaleType(propsLocaleType.label());

		comboLocaleType.setEmptyText("Select a locale type...");
		comboLocaleType.setWidth(191);
		comboLocaleType.setTypeAhead(true);
		comboLocaleType.setTriggerAction(TriggerAction.ALL);

		comboLocaleTypeLabel = new FieldLabel(comboLocaleType, "Locale");

		// comboDimensionType
		TabResourceProperties propsDimensionType = GWT
				.create(TabResourceProperties.class);
		ListStore<TabResource> storeComboDimensionType = new ListStore<TabResource>(
				propsDimensionType.id());

		comboDimensionType = new ComboBox<TabResource>(storeComboDimensionType,
				propsDimensionType.label());
		Log.trace("ComboDimensionType created");

		addHandlersForComboDimensionType(propsDimensionType.label());

		comboDimensionType.setEmptyText("Select a Dimension...");
		comboDimensionType.setWidth(191);
		comboDimensionType.setEditable(false);
		comboDimensionType.setTriggerAction(TriggerAction.ALL);

		comboDimensionTypeLabel = new FieldLabel(comboDimensionType, "Codelist");

		// ColumnReferenceType
		ColumnDataPropertiesCombo propsColumnReferenceType = GWT
				.create(ColumnDataPropertiesCombo.class);
		storeComboColumnReferenceType = new ListStore<ColumnData>(
				propsColumnReferenceType.id());

		comboColumnReferenceType = new ComboBox<ColumnData>(
				storeComboColumnReferenceType, propsColumnReferenceType.label());
		Log.trace("ComboColumnReferenceType created");

		addHandlersForComboColumnReferenceType(propsColumnReferenceType.label());

		comboColumnReferenceType.setEmptyText("Select a Column Reference...");
		comboColumnReferenceType.setWidth(191);
		comboColumnReferenceType.setEditable(false);
		comboColumnReferenceType.setTriggerAction(TriggerAction.ALL);

		comboColumnReferenceTypeLabel = new FieldLabel(
				comboColumnReferenceType, "Column");

		// comboTimeDimensionType
		TimeDimensionTypeProperties propsTimeDimensionType = GWT
				.create(TimeDimensionTypeProperties.class);
		ListStore<TimeDimensionTypeElement> storeComboTimeDimensionType = new ListStore<TimeDimensionTypeElement>(
				propsTimeDimensionType.id());
		storeComboTimeDimensionType.addAll(TimeDimensionTypeStore
				.getTimeDimensionType());
		comboTimeDimensionType = new ComboBox<TimeDimensionTypeElement>(
				storeComboTimeDimensionType, propsTimeDimensionType.label());
		Log.trace("ComboTimeDimensionType created");

		addHandlersForComboTimeDimensionType(propsTimeDimensionType.label());

		comboTimeDimensionType.setEmptyText("Select a time dimension type...");
		comboTimeDimensionType.setWidth(191);
		comboTimeDimensionType.setTypeAhead(true);
		comboTimeDimensionType.setTriggerAction(TriggerAction.ALL);

		comboTimeDimensionTypeLabel = new FieldLabel(comboTimeDimensionType,
				"Time Type");
		
		
		// Save
		btnAddColumn = new TextButton("Add");
		btnAddColumn.setIcon(ResourceBundle.INSTANCE.columnAdd());
		btnAddColumn.setIconAlign(IconAlign.RIGHT);
		btnAddColumn.setTitle("Add Column");

		
		SelectHandler changeHandler = new SelectHandler() {

			public void onSelect(SelectEvent event) {
				save();

			}
		};
		btnAddColumn.addSelectHandler(changeHandler);

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(new FieldLabel(label, "Label"), new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(new FieldLabel(comboColumnTypeCode, "Column Type"),
				new VerticalLayoutData(1, -1, new Margins(1)));
		v.add(comboLocaleTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboMeasureTypeLabel, new VerticalLayoutData(1, -1, new Margins(
				1)));
		v.add(comboAttributeTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboDimensionTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboColumnReferenceTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		v.add(comboTimeDimensionTypeLabel, new VerticalLayoutData(1, -1,
				new Margins(1)));
		
		v.add(defaultStringLabel, new VerticalLayoutData(
				1, -1, new Margins(1)));
		v.add(defaultDateLabel, new VerticalLayoutData(
				1, -1, new Margins(1)));
		v.add(btnAddColumn,
				new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		add(v, new VerticalLayoutData(-1, -1, new Margins(0)));

		comboMeasureTypeLabel.setVisible(false);
		comboAttributeTypeLabel.setVisible(false);
		comboDimensionTypeLabel.setVisible(false);
		comboColumnReferenceTypeLabel.setVisible(false);
		comboTimeDimensionTypeLabel.setVisible(false);
		comboLocaleTypeLabel.setVisible(false);
		
		defaultDateLabel.setVisible(false);
		defaultStringLabel.setVisible(false);

	}

	protected void addHandlersForComboColumnTypeCode(
			final LabelProvider<ColumnTypeCodeElement> labelProvider) {
		comboColumnTypeCode
				.addSelectionHandler(new SelectionHandler<ColumnTypeCodeElement>() {
					public void onSelection(
							SelectionEvent<ColumnTypeCodeElement> event) {
						Info.display(
								"Column Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnTypeCode selected: "
								+ event.getSelectedItem());
						ColumnTypeCodeElement columnType = event
								.getSelectedItem();
						updateColumnType(columnType.getCode());
					}

				});
	}

	protected void addHandlersForComboMeasureType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboMeasureType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Measure Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboMeasureType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement measureType = event
								.getSelectedItem();
						updateMeasureType(measureType.getType());
					}

				});
	}

	protected void addHandlersForComboAttributeType(
			final LabelProvider<ColumnDataTypeElement> labelProvider) {
		comboAttributeType
				.addSelectionHandler(new SelectionHandler<ColumnDataTypeElement>() {
					public void onSelection(
							SelectionEvent<ColumnDataTypeElement> event) {
						Info.display(
								"Attribute Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboAttributeType selected: "
								+ event.getSelectedItem());
						ColumnDataTypeElement attributeType = event
								.getSelectedItem();
						updateAttributeType(attributeType.getType());
					}

				});
	}

	protected void addHandlersForComboLocaleType(
			final LabelProvider<LocaleTypeElement> labelProvider) {
		comboLocaleType
				.addSelectionHandler(new SelectionHandler<LocaleTypeElement>() {
					public void onSelection(
							SelectionEvent<LocaleTypeElement> event) {
						Info.display(
								"Locale Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboLocaleType selected: "
								+ event.getSelectedItem());
						LocaleTypeElement localeType = event.getSelectedItem();
						updateLocaleType(localeType);
					}

				});
	}

	protected void addHandlersForComboDimensionType(
			final LabelProvider<TabResource> labelProvider) {

		comboDimensionType.addTriggerClickHandler(new TriggerClickHandler() {

			@Override
			public void onTriggerClick(TriggerClickEvent event) {
				Log.debug("ComboDimension TriggerClickEvent");
				callDialogCodelistSelection();
				comboDimensionType.collapse();

			}

		});

	}

	protected void addHandlersForComboColumnReferenceType(
			final LabelProvider<ColumnData> labelProvider) {

		comboColumnReferenceType
				.addSelectionHandler(new SelectionHandler<ColumnData>() {
					public void onSelection(SelectionEvent<ColumnData> event) {
						Info.display(
								"Column Reference Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboColumnReferenceType selected: "
								+ event.getSelectedItem());

					}

				});

	}

	protected void addHandlersForComboTimeDimensionType(
			final LabelProvider<TimeDimensionTypeElement> labelProvider) {
		comboTimeDimensionType
				.addSelectionHandler(new SelectionHandler<TimeDimensionTypeElement>() {
					public void onSelection(
							SelectionEvent<TimeDimensionTypeElement> event) {
						Info.display(
								"Time Dimension Type Selected",
								"You selected "
										+ (event.getSelectedItem() == null ? "nothing"
												: labelProvider.getLabel(event
														.getSelectedItem())
														+ "!"));
						Log.debug("ComboTimeDimensionType selected: "
								+ event.getSelectedItem());
						TimeDimensionTypeElement timeDimensionType = event
								.getSelectedItem();
						updateTimeDimensionType(timeDimensionType.getType());
					}

				});
	}

	protected void updateColumnType(ColumnTypeCode type) {
		Log.debug("Update ColumnTypeCode " + type.toString());
		switch (type) {
		case CODENAME:
			comboLocaleTypeLabel.setVisible(true);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case ATTRIBUTE:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(true);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			defaultStringLabel.setVisible(false);
			defaultDateLabel.setVisible(false);
			break;
		case DIMENSION:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(true);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			defaultStringLabel.setVisible(false);
			defaultDateLabel.setVisible(false);
			
			break;
		case MEASURE:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(true);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case TIMEDIMENSION:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(true);
			defaultStringLabel.setVisible(false);
			defaultDateLabel.setVisible(false);
			break;
		default:
			comboLocaleTypeLabel.setVisible(false);
			comboMeasureTypeLabel.setVisible(false);
			comboAttributeTypeLabel.setVisible(false);
			comboDimensionTypeLabel.setVisible(false);
			comboColumnReferenceTypeLabel.setVisible(false);
			comboTimeDimensionTypeLabel.setVisible(false);
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		}

		forceLayout();
	}

	protected void updateMeasureType(ColumnDataType type) {

	}

	protected void updateAttributeType(ColumnDataType type) {
		Log.debug("Update ColumnTypeCode " + type.toString());
		switch (type) {
		case Boolean:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case Date:
			defaultStringLabel.setVisible(false);
			defaultDateLabel.setVisible(true);
			break;
		case Geometry:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case Integer:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case Numeric:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		case Text:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		default:
			defaultStringLabel.setVisible(true);
			defaultDateLabel.setVisible(false);
			break;
		}
		
		forceLayout();

	}

	protected void updateLocaleType(LocaleTypeElement type) {

	}

	protected void updateTimeDimensionType(TimeDimensionType type) {

	}

	public void update(TRId trId) {
		this.trId = trId;
		this.clear();
		create();
	}

	protected void save() {
		DefNewColumn defNewColumn;

		String defaultV = defaultValueString.getCurrentValue();
		String labelS = label.getCurrentValue();

		if (labelS != null && !labelS.isEmpty()) {
			ColumnTypeCodeElement columnTypeCodeElement = comboColumnTypeCode
					.getCurrentValue();
			if (columnTypeCodeElement != null) {
				ColumnTypeCode type = columnTypeCodeElement.getCode();
				ColumnDataTypeElement columnDataTypeElement;
				switch (type) {
				case MEASURE:
					columnDataTypeElement = comboMeasureType.getCurrentValue();
					if (columnDataTypeElement != null) {
						ColumnDataType dataType = columnDataTypeElement
								.getType();
						if (dataType != null) {
							defNewColumn = new DefNewColumn(labelS, type,
									dataType, defaultV);
							addColumnSession = new AddColumnSession(trId,
									defNewColumn);
							callAddColumm();
						} else {
							UtilsGXT3.alert("Attention",
									"Column data type not selected!");
						}

					} else {
						UtilsGXT3.alert("Attention",
								"Column data type not selected!");
					}
					break;
				case ATTRIBUTE:
					columnDataTypeElement = comboAttributeType
							.getCurrentValue();
					if (columnDataTypeElement != null) {
						ColumnDataType dataType = columnDataTypeElement
								.getType();
						if (dataType != null) {
							if(dataType==ColumnDataType.Date){
								Date d = defaultValueDate.getCurrentValue();
								if(d==null){
									UtilsGXT3.alert("Attention",
											"Column data type not selected!");
								} else {
									String dateS = sdf.format(d);
									defNewColumn = new DefNewColumn(labelS, type,
										dataType, dateS);
									addColumnSession = new AddColumnSession(trId,
											defNewColumn);
									callAddColumm();
								}
							} else {
								defNewColumn = new DefNewColumn(labelS, type,
										dataType, defaultV);
								addColumnSession = new AddColumnSession(trId,
										defNewColumn);
								callAddColumm();
							}
							
							

						} else {
							UtilsGXT3.alert("Attention",
									"Column data type not selected!");
						}
					} else {
						UtilsGXT3.alert("Attention",
								"Column data type not selected!");
					}
					break;
				case CODE:
					defNewColumn = new DefNewColumn(labelS, type, defaultV);
					addColumnSession = new AddColumnSession(trId, defNewColumn);
					callAddColumm();
					break;
				case CODENAME:
					LocaleTypeElement locale = comboLocaleType
							.getCurrentValue();
					if (locale != null) {
						defNewColumn = new DefNewColumn(labelS, type,
								locale.getLocaleName(), defaultV);
						addColumnSession = new AddColumnSession(trId,
								defNewColumn);
						callAddColumm();
					} else {
						UtilsGXT3.alert("Attention", "No locale selected!");
					}
					break;
				case CODEDESCRIPTION:
					defNewColumn = new DefNewColumn(labelS, type, defaultV);
					addColumnSession = new AddColumnSession(trId, defNewColumn);
					callAddColumm();
					break;
				case ANNOTATION:
					defNewColumn = new DefNewColumn(labelS, type, defaultV);
					addColumnSession = new AddColumnSession(trId, defNewColumn);
					callAddColumm();
					break;
				case DIMENSION:
					ColumnData columnReference = comboColumnReferenceType
							.getCurrentValue();
					if (columnReference != null) {
						defNewColumn = new DefNewColumn(labelS, type,
								columnReference, defaultV);
						addColumnSession = new AddColumnSession(trId,
								defNewColumn);
						callAddColumm();
					} else {
						UtilsGXT3.alert("Attention",
								"No column reference selected!");
					}
					break;
				case TIMEDIMENSION:
					TimeDimensionTypeElement timeDimensionTypeElement = comboTimeDimensionType
							.getCurrentValue();
					if (timeDimensionTypeElement != null) {
						TimeDimensionType timeDimensionType = timeDimensionTypeElement
								.getType();
						if (timeDimensionType != null) {
							defNewColumn = new DefNewColumn(labelS, type,
									timeDimensionType, defaultV);
							addColumnSession = new AddColumnSession(trId,
									defNewColumn);
							callAddColumm();
						} else {
							UtilsGXT3.alert("Attention",
									"Time Dimension type not selected!");
						}

					} else {
						UtilsGXT3.alert("Attention",
								"Time Dimension type not selected!");
					}
					break;
				default:
					UtilsGXT3.alert("Attention",
							"This column type is not supported now!");
					break;
				}
			} else {
				UtilsGXT3.alert("Attention", "Select a column type!");
			}
		} else {
			UtilsGXT3.alert("Attntion", "Insert a valid label!");
		}

	}

	private void callAddColumm() {
		Log.debug(addColumnSession.toString());
		TDGWTServiceAsync.INSTANCE.startAddColumn(addColumnSession,
				new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.debug("Add Column Error: "
									+ caught.getLocalizedMessage());
							UtilsGXT3
									.alert("Add Column Error ",
											"Error in invocation of add column operation!");
						}
					}

					public void onSuccess(Void result) {
						addColumnProgressDialog = new AddColumnProgressDialog(
								eventBus);
						addColumnProgressDialog
								.addProgressDialogListener(thisPanel);
						addColumnProgressDialog.show();
					}

				});

	}

	protected void callDialogCodelistSelection() {
		CodelistSelectionDialog dialogCodelistSelection = new CodelistSelectionDialog(
				eventBus);
		dialogCodelistSelection.addListener(this);
		dialogCodelistSelection.show();
	}

	@Override
	public void selected(TabResource tabResource) {
		Log.debug("Selected Codelist: " + tabResource);
		comboDimensionType.setValue(tabResource);
		retrieveColumnData(tabResource);
	}

	@Override
	public void aborted() {
		Log.debug("Select Codelist Aborted");

	}

	@Override
	public void failed(String reason, String detail) {
		Log.error("Select Codelist Failed[reason: " + reason + " , detail:"
				+ detail + "]");

	}

	protected void retrieveColumnData(TabResource tabResource) {
		TDGWTServiceAsync.INSTANCE.getColumnsForDimension(
				tabResource.getTrId(),
				new AsyncCallback<ArrayList<ColumnData>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.debug("Error retrieving columns: "
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving columns",
									"Error retrieving columns on server!");
						}
					}

					@Override
					public void onSuccess(ArrayList<ColumnData> result) {
						comboColumnReferenceType.reset();
						storeComboColumnReferenceType.clear();
						storeComboColumnReferenceType.addAll(result);
						storeComboColumnReferenceType.commitChanges();
						comboColumnReferenceTypeLabel.setVisible(true);
						forceLayout();
					}
				});

	}

	protected void retriveLocales() {
		TDGWTServiceAsync.INSTANCE
				.getLocales(new AsyncCallback<ArrayList<String>>() {

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.debug(caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving locales",
									caught.getLocalizedMessage());
						}
					}

					@Override
					public void onSuccess(ArrayList<String> result) {
						storeComboLocaleType.clear();
						ArrayList<LocaleTypeElement> locales = new ArrayList<LocaleTypeElement>();
						LocaleTypeElement locale;
						for (String local : result) {
							locale = new LocaleTypeElement(local);
							locales.add(locale);
						}
						storeComboLocaleType.addAll(locales);
						storeComboLocaleType.commitChanges();
						// comboColumnReferenceTypeLabel.setVisible(true);

					}
				});

	}

	protected void setLocale(String locale) {
		for (LocaleTypeElement loc : storeComboLocaleType.getAll()) {
			if (loc.getLocaleName().compareTo(locale) == 0) {
				comboLocaleType.setValue(loc);
				break;
			}
		}
	}

	public void close() {
		if (parent != null) {
			parent.close();
		}
	}

	@Override
	public void operationComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.ADDCOLUMN, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();

	}

	@Override
	public void operationFailed(Throwable caught, String reason) {
		UtilsGXT3.alert("Error in Add Column", reason);
		close();
	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.ADDCOLUMN, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();
	}

}
