package org.gcube.portlets.user.td.columnwidget.client.progress;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

public interface ResubmitDialogListener {
	
	
	/**
	 * Called when the resubmit of task is complete.
	 */
	public void resubmitComplete(TRId trId);

	/**
	 * Called when the resubmit of task is failed.
	 * @param caught the failure exception.
	 * @param reason the failure reason.
	 */
	public void resubmitFailed(Throwable caught, String reason);
	
	

	/**
	 * Called when the resubmit of task is stopped
	 * 
	 * @param trId
	 * @param reason
	 * @param details
	 */
	public void resubmitStopped(TRId trId, String reason, String details);
	
	
	
}
