/**
 * 
 */
package org.gcube.portlets.user.td.columnwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ReplaceColumnProgressUpdater extends Timer {

	protected ArrayList<ReplaceColumnProgressListener> listeners = new ArrayList<ReplaceColumnProgressListener>();

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		TDGWTServiceAsync.INSTANCE
				.getReplaceColumnMonitor(new AsyncCallback<ReplaceColumnMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(ReplaceColumnMonitor result) {
						Log.info("retrieved ReplaceColumnMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Replace Column Value Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Replace Column Value Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();		
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("ReplaceColumn fisnish:"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(ReplaceColumnMonitor result) {
		Log.info("Replace the column value Failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library Replacing the column value";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library Replacing the column value";
			details = "Replace the column value failed";
		}
		
	
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(ReplaceColumnMonitor result) {
		Log.info("Replace Column Value Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped";
			details = "Stopped replacing the column value";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}

	protected void fireOperationComplete(TRId trId) {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}
	
	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (ReplaceColumnProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	

	/**
	 * Add a new {@link } to this
	 * {@link ReplaceColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(ReplaceColumnProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link } from this
	 * {@link ReplaceColumnProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(ReplaceColumnProgressListener listener) {
		listeners.remove(listener);
	}
}
