package org.gcube.portlets.user.td.columnwidget.client;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.form.ComboBox;

/**
 * Delete Column Dialog
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class LabelColumnDialog extends Window {
	protected int WIDTH=400;
	protected int HEIGHT=120;
	protected TRId trId;
	protected ComboBox<ColumnData> combo = null;
	protected String columnName = null;
	protected EventBus eventBus;
	
	public LabelColumnDialog(TRId trId,  EventBus eventBus) {
		create(trId, null, eventBus);
	}

	public LabelColumnDialog(TRId trId, String columnName,  EventBus eventBus) {
		create(trId, columnName, eventBus);
	}

	protected void create(TRId trId, String columnName,  EventBus eventBus) {
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus=eventBus;
		setBodyBorder(false);
		
		LabelColumnPanel labelColumnPanel= new LabelColumnPanel(trId, columnName, eventBus);
		add(labelColumnPanel);
	}
}
