/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_REFERENCE_DETAIL;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.factory.ReadableDataLocationFactory;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.querybuilder.builder.StructureQueryBuilderRest;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.RESTStructureQueryImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.BaseSdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class RESTSdmxBeanRetrievalManager
extends BaseSdmxBeanRetrievalManager {
    private String restURL;
    @Autowired
    private StructureQueryBuilderRest restQueryBuilder;
    @Autowired
    private StructureParsingManager spm;
    @Autowired
    private ReadableDataLocationFactory rdlFactory;

    public RESTSdmxBeanRetrievalManager(String restURL) {
        this.restURL = restURL;
    }

    @Override
    public SdmxBeans getMaintainables(RESTStructureQuery sQuery) {
        URL restURL;
        String restQuery = String.valueOf(this.restURL) + "/" + this.restQueryBuilder.buildStructureQuery(sQuery);
        try {
            restURL = new URL(restQuery);
        }
        catch (MalformedURLException e) {
            throw new SdmxException((Throwable)e, "Could not open a conneciton to URL: " + restQuery);
        }
        ReadableDataLocation rdl = this.rdlFactory.getReadableDataLocation(restURL);
        return this.spm.parseStructures(rdl).getStructureBeans(false);
    }

    @Override
    public SdmxBeans getSdmxBeans(StructureReferenceBean sRef, boolean includeReferences) {
        STRUCTURE_REFERENCE_DETAIL refDetail = includeReferences ? STRUCTURE_REFERENCE_DETAIL.DESCENDANTS : STRUCTURE_REFERENCE_DETAIL.NONE;
        STRUCTURE_QUERY_DETAIL queryDetail = STRUCTURE_QUERY_DETAIL.FULL;
        RESTStructureQueryImpl query = new RESTStructureQueryImpl(queryDetail, refDetail, null, sRef, false);
        return this.getMaintainables((RESTStructureQuery)query);
    }

    @Override
    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        SDMX_STRUCTURE_TYPE type = SDMX_STRUCTURE_TYPE.ANY;
        if (structureType != null) {
            type = SDMX_STRUCTURE_TYPE.parseClass(structureType);
        }
        StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(ref, type);
        STRUCTURE_REFERENCE_DETAIL refDetail = STRUCTURE_REFERENCE_DETAIL.NONE;
        STRUCTURE_QUERY_DETAIL queryDetail = returnStub ? STRUCTURE_QUERY_DETAIL.ALL_STUBS : STRUCTURE_QUERY_DETAIL.FULL;
        RESTStructureQueryImpl query = new RESTStructureQueryImpl(queryDetail, refDetail, null, (StructureReferenceBean)sRef, returnLatest);
        return this.getMaintainables((RESTStructureQuery)query).getMaintainables(sRef.getMaintainableStructureType());
    }

    protected String getRestURL() {
        return this.restURL;
    }
}

