/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_QUERY_DETAIL;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.HeaderRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.RegistrationBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.ServiceRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.crossreference.CrossReferencingRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.crossreference.BeanCrossReferencedRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseSdmxBeanRetrievalManager
implements SdmxBeanRetrievalManager,
InitializingBean {
    private Logger LOG = Logger.getLogger(BaseSdmxBeanRetrievalManager.class);
    private SdmxBeanRetrievalManager proxy;
    protected CrossReferencedRetrievalManager crossReferenceRetrievalManager;
    protected CrossReferencingRetrievalManager crossReferencingRetrievalManager;
    private RegistrationBeanRetrievalManager registrationRetrievalManager;
    private HeaderRetrievalManager headerRetrievalManager;
    private ServiceRetrievalManager serviceRetrievalManager;

    public AgencyBean getAgency(String id) {
        AgencySchemeBean acySch = null;
        String agencyId = id;
        String agencyParentId = "SDMX";
        if (id.contains(".")) {
            int lastDotIdx = id.lastIndexOf(".");
            agencyParentId = id.substring(0, lastDotIdx);
            agencyId = id.substring(lastDotIdx + 1);
        }
        if ((acySch = this.getMaintainableBean(AgencySchemeBean.class, (MaintainableRefBean)new MaintainableRefBeanImpl(agencyParentId, "AGENCIES", "1.0"))) != null) {
            for (AgencyBean acy : acySch.getItems()) {
                if (!acy.getId().equals(agencyId)) continue;
                return acy;
            }
        }
        return null;
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref) {
        return this.getMaintainableBean(structureType, ref, false, false);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef) {
        return this.getMaintainableBean(sRef, false, false);
    }

    public SdmxBeans getSdmxBeans(StructureReferenceBean sRef, boolean includeReferences) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiables((Collection)this.getMaintainableBeans(sRef.getMaintainableStructureType().getMaintainableInterface(), sRef.getMaintainableReference()));
        if (includeReferences) {
            this.resolveReferences((SdmxBeans)beans);
        }
        return beans;
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType) {
        return this.getMaintainableBeans(structureType, null);
    }

    public MaintainableBean getMaintainableBean(StructureReferenceBean sRef, boolean returnStub, boolean returnLatest) {
        return this.extractFromSet(this.getMaintainableBeans(sRef.getMaintainableStructureType().getMaintainableInterface(), sRef.getMaintainableReference(), returnLatest, returnStub));
    }

    public <T extends MaintainableBean> T getMaintainableBean(Class<T> structureType, MaintainableRefBean ref, boolean returnStub, boolean returnLatest) {
        if (!returnLatest) {
            returnLatest = !ObjectUtil.validObject((Object[])new Object[]{ref.getVersion()});
        }
        return this.extractFromSet(this.getMaintainableBeans(structureType, ref, returnLatest, returnStub));
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref) {
        return this.getMaintainableBeans(structureType, ref, false, false);
    }

    public <T extends MaintainableBean> Set<T> getMaintainableBeans(Class<T> structureType, MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        Set<AgencySchemeBean> returnSet;
        if (structureType == AgencySchemeBean.class) {
            returnSet = this.getAgencySchemeBeans(ref, returnStub);
        } else if (structureType == AttachmentConstraintBean.class) {
            returnSet = this.getAttachmentConstraints(ref, returnLatest, returnStub);
        } else if (structureType == ContentConstraintBean.class) {
            returnSet = this.getContentConstraints(ref, returnLatest, returnStub);
        } else if (structureType == DataConsumerSchemeBean.class) {
            returnSet = this.getDataConsumerSchemeBeans(ref, returnStub);
        } else if (structureType == DataProviderSchemeBean.class) {
            returnSet = this.getDataProviderSchemeBeans(ref, returnStub);
        } else if (structureType == CategorisationBean.class) {
            returnSet = this.getCategorisationBeans(ref, returnStub);
        } else if (structureType == CategorySchemeBean.class) {
            returnSet = this.getCategorySchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == CodelistBean.class) {
            returnSet = this.getCodelistBeans(ref, returnLatest, returnStub);
        } else if (structureType == ConceptSchemeBean.class) {
            returnSet = this.getConceptSchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == DataflowBean.class) {
            returnSet = this.getDataflowBeans(ref, returnLatest, returnStub);
        } else if (structureType == HierarchicalCodelistBean.class) {
            returnSet = this.getHierarchicCodeListBeans(ref, returnLatest, returnStub);
        } else if (structureType == DataStructureBean.class) {
            returnSet = this.getDataStructureBeans(ref, returnLatest, returnStub);
        } else if (structureType == MetadataFlowBean.class) {
            returnSet = this.getMetadataflowBeans(ref, returnLatest, returnStub);
        } else if (structureType == MetadataStructureDefinitionBean.class) {
            returnSet = this.getMetadataStructureBeans(ref, returnLatest, returnStub);
        } else if (structureType == OrganisationUnitSchemeBean.class) {
            returnSet = this.getOrganisationUnitSchemeBeans(ref, returnLatest, returnStub);
        } else if (structureType == ProcessBean.class) {
            returnSet = this.getProcessBeans(ref, returnLatest, returnStub);
        } else if (structureType == ReportingTaxonomyBean.class) {
            returnSet = this.getReportingTaxonomyBeans(ref, returnLatest, returnStub);
        } else if (structureType == StructureSetBean.class) {
            returnSet = this.getStructureSetBeans(ref, returnLatest, returnStub);
        } else if (structureType == ProvisionAgreementBean.class) {
            returnSet = this.getProvisionAgreementBeans(ref, returnLatest, returnStub);
        } else if (structureType == RegistrationBean.class) {
            returnSet = this.getRegistrationBeans(ref);
        } else {
            throw new SdmxNotImplementedException("getMaintainableBean for type: " + structureType);
        }
        if (returnStub && this.serviceRetrievalManager != null) {
            HashSet<AgencySchemeBean> stubSet = new HashSet<AgencySchemeBean>();
            for (MaintainableBean maintainableBean : returnSet) {
                if (maintainableBean.isExternalReference().isTrue()) {
                    stubSet.add((AgencySchemeBean)maintainableBean);
                    continue;
                }
                stubSet.add((AgencySchemeBean)this.serviceRetrievalManager.createStub(maintainableBean));
            }
            returnSet = stubSet;
        }
        return returnSet;
    }

    public SdmxBeans getMaintainables(RESTStructureQuery complexQuery) {
        Set queryResultMaintainables;
        this.LOG.info((Object)("Query for maintainables: " + complexQuery));
        boolean isAllStubs = complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.ALL_STUBS;
        boolean isRefStubs = isAllStubs || complexQuery.getStructureQueryMetadata().getStructureQueryDetail() == STRUCTURE_QUERY_DETAIL.REFERENCED_STUBS;
        boolean isLatest = complexQuery.getStructureQueryMetadata().isReturnLatest();
        SDMX_STRUCTURE_TYPE type = complexQuery.getStructureReference().getMaintainableStructureType();
        if (type == null) {
            type = SDMX_STRUCTURE_TYPE.ANY;
        }
        MaintainableRefBean ref = complexQuery.getStructureReference().getMaintainableReference();
        if (type == SDMX_STRUCTURE_TYPE.ANY) {
            HashSet q = new HashSet();
            for (SDMX_STRUCTURE_TYPE currentMaintainable : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
                if (currentMaintainable == SDMX_STRUCTURE_TYPE.REGISTRATION || currentMaintainable == SDMX_STRUCTURE_TYPE.SUBSCRIPTION) continue;
                q.addAll(this.getMaintainableBeans(currentMaintainable.getMaintainableInterface(), ref, isAllStubs, isLatest));
            }
            queryResultMaintainables = q;
        } else if (type == SDMX_STRUCTURE_TYPE.ORGANISATION_SCHEME) {
            SdmxBeansImpl beans = new SdmxBeansImpl();
            beans.addIdentifiables((Collection)this.getMaintainableBeans(AgencySchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables((Collection)this.getMaintainableBeans(DataProviderSchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables((Collection)this.getMaintainableBeans(OrganisationUnitSchemeBean.class, ref, isLatest, isAllStubs));
            beans.addIdentifiables((Collection)this.getMaintainableBeans(DataConsumerSchemeBean.class, ref, isLatest, isAllStubs));
            queryResultMaintainables = beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        } else {
            queryResultMaintainables = this.getMaintainableBeans(type.getMaintainableInterface(), ref, isLatest, isAllStubs);
        }
        this.LOG.info((Object)("Returned " + queryResultMaintainables.size() + " results"));
        HeaderBean header = null;
        if (this.headerRetrievalManager != null) {
            header = this.headerRetrievalManager.getHeader();
        }
        SdmxBeansImpl referencedBeans = new SdmxBeansImpl(header);
        SdmxBeansImpl referenceMerge = new SdmxBeansImpl();
        switch (complexQuery.getStructureQueryMetadata().getStructureReferenceDetail()) {
            case NONE: {
                this.LOG.info((Object)"Reference detail NONE");
                break;
            }
            case PARENTS: {
                this.LOG.info((Object)"Reference detail PARENTS");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case PARENTS_SIBLINGS: {
                this.LOG.info((Object)"Reference detail PARENTS_SIBLINGS");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                this.resolveChildren(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]), (SdmxBeans)referenceMerge, isRefStubs);
                referencedBeans.merge((SdmxBeans)referenceMerge);
                break;
            }
            case CHILDREN: {
                this.LOG.info((Object)"Reference detail CHILDREN");
                this.resolveChildren(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case DESCENDANTS: {
                this.LOG.info((Object)"Reference detail DESCENDANTS");
                this.resolveDescendants(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                break;
            }
            case ALL: {
                this.LOG.info((Object)"Reference detail ALL");
                this.resolveParents(queryResultMaintainables, (SdmxBeans)referencedBeans, isRefStubs);
                this.resolveDescendants(queryResultMaintainables, (SdmxBeans)referenceMerge, isRefStubs);
                referencedBeans.merge((SdmxBeans)referenceMerge);
                break;
            }
            case SPECIFIC: {
                this.LOG.info((Object)"Reference detail Children");
                this.resolveSpecific(queryResultMaintainables, (SdmxBeans)referencedBeans, complexQuery.getStructureQueryMetadata().getSpecificStructureReference(), isRefStubs);
            }
        }
        referencedBeans.addIdentifiables((Collection)queryResultMaintainables);
        this.LOG.info((Object)("Result Size : " + referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()));
        return referencedBeans;
    }

    private void resolveSpecific(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, SDMX_STRUCTURE_TYPE specificType, boolean returnStub) {
        this.LOG.info((Object)"Resolving Child Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug((Object)("Resolving Children of " + maintainableBean.getUrn()));
            referencedBeans.addIdentifiables((Collection)this.crossReferenceRetrievalManager.getCrossReferencedStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[]{specificType}));
            if (this.crossReferencingRetrievalManager == null) continue;
            referencedBeans.addIdentifiables((Collection)this.crossReferencingRetrievalManager.getCrossReferencingStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[]{specificType}));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found"));
    }

    private void resolveDescendants(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        int numBeans = -2;
        while (numBeans != resolveFor.size()) {
            numBeans = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size();
            this.resolveChildren(resolveFor, referencedBeans, returnStub);
            resolveFor = referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]);
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " descendants found"));
    }

    private void resolveChildren(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info((Object)"Resolving Child Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug((Object)("Resolving Children of " + maintainableBean.getUrn()));
            referencedBeans.addIdentifiables((Collection)this.crossReferenceRetrievalManager.getCrossReferencedStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " children found"));
    }

    private void resolveParents(Set<? extends MaintainableBean> resolveFor, SdmxBeans referencedBeans, boolean returnStub) {
        this.LOG.info((Object)"Resolving Parents Structures");
        for (MaintainableBean maintainableBean : resolveFor) {
            this.LOG.debug((Object)("Resolving Parents of " + maintainableBean.getUrn()));
            if (this.crossReferencingRetrievalManager == null) {
                throw new SdmxNotImplementedException("Resolve parents not supported");
            }
            referencedBeans.addIdentifiables((Collection)this.crossReferencingRetrievalManager.getCrossReferencingStructures((IdentifiableBean)maintainableBean, returnStub, new SDMX_STRUCTURE_TYPE[0]));
        }
        this.LOG.info((Object)(String.valueOf(referencedBeans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size()) + " parents found"));
    }

    private void resolveReferences(SdmxBeans beans) {
        CrossReferenceResolverEngineImpl resolver = new CrossReferenceResolverEngineImpl();
        Map<IdentifiableBean, Set<IdentifiableBean>> crossReferenceMap = resolver.resolveReferences(beans, false, 0, (SdmxBeanRetrievalManager)this);
        for (IdentifiableBean key : crossReferenceMap.keySet()) {
            beans.addIdentifiable(key);
            for (IdentifiableBean value : crossReferenceMap.get(key)) {
                beans.addIdentifiable(value);
            }
        }
    }

    private <T extends MaintainableBean> T extractFromSet(Set<T> set) {
        if (!ObjectUtil.validCollection(set)) {
            return null;
        }
        if (set.size() == 1) {
            return (T)((MaintainableBean)set.toArray()[0]);
        }
        throw new SdmxException("Did not expect more then 1 structure from query, got " + set.size() + " strutures.");
    }

    protected Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(AttachmentConstraintBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getAttachmentConstraints"});
    }

    protected Set<CategorisationBean> getCategorisationBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(CategorisationBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCategorisationBeans"});
    }

    protected Set<CodelistBean> getCodelistBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(CodelistBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCodelistBeans"});
    }

    protected Set<ConceptSchemeBean> getConceptSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(ConceptSchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getConceptSchemeBeans"});
    }

    protected Set<ContentConstraintBean> getContentConstraints(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(ContentConstraintBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getContentConstraints"});
    }

    protected Set<CategorySchemeBean> getCategorySchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(CategorySchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getCategorySchemeBeans"});
    }

    protected Set<DataflowBean> getDataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(DataflowBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataflowBeans"});
    }

    protected Set<HierarchicalCodelistBean> getHierarchicCodeListBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(HierarchicalCodelistBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getHierarchicCodeListBeans"});
    }

    protected Set<MetadataFlowBean> getMetadataflowBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(MetadataFlowBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getMetadataflowBeans"});
    }

    protected Set<DataStructureBean> getDataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(DataStructureBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataStructureBeans"});
    }

    protected Set<MetadataStructureDefinitionBean> getMetadataStructureBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(MetadataStructureDefinitionBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getMetadataStructureBeans"});
    }

    protected Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemeBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(OrganisationUnitSchemeBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getOrganisationUnitSchemeBeans"});
    }

    protected Set<DataProviderSchemeBean> getDataProviderSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(DataProviderSchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataProviderSchemeBeans"});
    }

    protected Set<DataConsumerSchemeBean> getDataConsumerSchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(DataConsumerSchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getDataConsumerSchemeBeans"});
    }

    protected Set<AgencySchemeBean> getAgencySchemeBeans(MaintainableRefBean ref, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(AgencySchemeBean.class, ref, false, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getAgencySchemeBeans"});
    }

    protected Set<ProcessBean> getProcessBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(ProcessBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getProcessBeans"});
    }

    protected Set<ProvisionAgreementBean> getProvisionAgreementBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(ProvisionAgreementBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getProvisionAgreementBeans"});
    }

    protected Set<ReportingTaxonomyBean> getReportingTaxonomyBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(ReportingTaxonomyBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getReportingTaxonomyBeans"});
    }

    protected Set<StructureSetBean> getStructureSetBeans(MaintainableRefBean ref, boolean returnLatest, boolean returnStub) {
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(StructureSetBean.class, ref, returnLatest, returnStub);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"getStructureSetBeans"});
    }

    protected Set<RegistrationBean> getRegistrationBeans(MaintainableRefBean ref) {
        if (this.registrationRetrievalManager != null) {
            return this.registrationRetrievalManager.getRegistrations(ref);
        }
        if (this.proxy != null) {
            return this.proxy.getMaintainableBeans(RegistrationBean.class, ref, false, false);
        }
        throw new SdmxNotImplementedException("getRegistrationBeans");
    }

    public void afterPropertiesSet() throws Exception {
        if (this.crossReferenceRetrievalManager == null) {
            this.crossReferenceRetrievalManager = new BeanCrossReferencedRetrievalManager(this);
        }
    }

    public void setCrossReferenceRetrievalManager(CrossReferencedRetrievalManager crossReferenceRetrievalManager) {
        this.crossReferenceRetrievalManager = crossReferenceRetrievalManager;
    }

    public void setServiceRetrievalManager(ServiceRetrievalManager serviceRetrievalManager) {
        this.serviceRetrievalManager = serviceRetrievalManager;
    }

    public void setCrossReferencingRetrievalManager(CrossReferencingRetrievalManager crossReferencingRetrievalManager) {
        this.crossReferencingRetrievalManager = crossReferencingRetrievalManager;
    }

    public void setRegistrationRetrievalManager(RegistrationBeanRetrievalManager registrationRetrievalManager) {
        this.registrationRetrievalManager = registrationRetrievalManager;
    }

    public void setHeaderRetrievalManager(HeaderRetrievalManager headerRetrievalManager) {
        this.headerRetrievalManager = headerRetrievalManager;
    }

    public void setProxy(SdmxBeanRetrievalManager proxy) {
        this.proxy = proxy;
    }
}

