/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.reader.impl;

import java.util.List;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDocumentPosition;
import org.sdmxsource.sdmx.ediparser.model.document.EDIMetadata;
import org.sdmxsource.sdmx.ediparser.model.reader.EDIDataReader;
import org.sdmxsource.sdmx.ediparser.model.reader.impl.EDIAbstractPositionalReaderImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class EDIDataReaderImpl
extends EDIAbstractPositionalReaderImpl
implements EDIDataReader {
    private EDIDocumentPosition documentPosition;

    public EDIDataReaderImpl(ReadableDataLocation dataFile, EDIDocumentPosition documentPosition, EDIMetadata ediMetadata) {
        super(dataFile, documentPosition, ediMetadata);
        this.documentPosition = documentPosition;
    }

    @Override
    public DatasetHeaderBean getDatasetHeaderBean() {
        String datasetId = this.documentPosition.getDatasetId();
        DATASET_ACTION datasetAction = this.documentPosition.getDatasetAction();
        String dsdId = this.documentPosition.getDataStructureIdentifier();
        StructureReferenceBeanImpl dsdRef = new StructureReferenceBeanImpl(this.getMessageAgency(), dsdId, "1.0", SDMX_STRUCTURE_TYPE.DSD, new String[0]);
        DatasetStructureReferenceBeanImpl structureReference = new DatasetStructureReferenceBeanImpl((StructureReferenceBean)dsdRef);
        return new DatasetHeaderBeanImpl(datasetId, datasetAction, (DatasetStructureReferenceBean)structureReference);
    }

    @Override
    public List<KeyValue> getDatasetAttributes() {
        return this.documentPosition.getDatasetAttributes();
    }

    @Override
    public String getMissingValue() {
        return this.documentPosition.getMissingValue();
    }

    @Override
    public void close() {
        super.close();
        this.dataFile.close();
    }
}

