/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.shared.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskResult;
import org.gcube.data.analysis.tabulardata.service.operation.ValidationJob;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.gcube.portlets.user.td.gwtservice.server.trservice.JobClassifierMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TabularResourceTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.WorkerStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.json.JSONExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitorSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobS;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobSClassifier;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskS;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskWrapper;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsJobS;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabExportMetadata;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMonitorCreator {
    private static final String SECURITY_EXCEPTION_RIGHTS = "Security exception, you don't have the required rights!";
    private static Logger logger = LoggerFactory.getLogger(OperationMonitorCreator.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private HttpSession session;
    private TaskWrapper taskWrapper;
    private OperationMonitorSession operationMonitorSession;
    private ASLSession aslSession;

    public OperationMonitorCreator(HttpSession session, ASLSession aslSession, TaskWrapper taskWrapper, OperationMonitorSession operationMonitorSession) {
        this.session = session;
        this.aslSession = aslSession;
        this.taskWrapper = taskWrapper;
        this.operationMonitorSession = operationMonitorSession;
    }

    public OperationMonitor create() throws TDGWTServiceException {
        OperationMonitor operationMonitor = new OperationMonitor(this.operationMonitorSession.getTaskId(), this.taskWrapper.getOperationId());
        if (this.taskWrapper == null || this.taskWrapper.getTask() == null || this.taskWrapper.getTask().getId() == null || this.taskWrapper.getTask().getId().getValue() == null || this.taskWrapper.getTask().getId().getValue().isEmpty()) {
            logger.debug("Task is null");
            throw new TDGWTServiceException("Error in Operation Monitor task is null");
        }
        operationMonitor.setTaskId(this.taskWrapper.getTask().getId().getValue());
        if (this.operationMonitorSession.isAbort()) {
            Task task = this.taskWrapper.getTask();
            task.abort();
            TaskS taskS = this.createTaskS();
            operationMonitor.setTask(taskS);
            SessionUtil.setStartedTask(this.session, this.taskWrapper);
            this.postOperation(operationMonitor);
        } else if (this.operationMonitorSession.isInBackground()) {
            TaskS taskS = this.createTaskS();
            operationMonitor.setTask(taskS);
            operationMonitor.setInBackground(true);
            SessionUtil.setTaskInBackground(this.session, this.taskWrapper);
            SessionUtil.removeStartedTask(this.session, this.taskWrapper);
            this.postOperation(operationMonitor);
        } else {
            TaskStatus status = null;
            try {
                status = this.taskWrapper.getTask().getStatus();
            }
            catch (Throwable e) {
                logger.debug("Error retrieving task status: " + this.taskWrapper.getTask() + "  " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            if (status == null) {
                logger.debug("Services TaskStatus : null");
                throw new TDGWTServiceException("Error in OperationMonitor Status is null");
            }
            TaskS taskS = this.createTaskS();
            operationMonitor.setTask(taskS);
            SessionUtil.setStartedTask(this.session, this.taskWrapper);
            this.postOperation(operationMonitor);
        }
        return operationMonitor;
    }

    protected TaskS createTaskS() throws TDGWTServiceException {
        TaskS taskS = new TaskS();
        ArrayList<JobS> jobSList = new ArrayList<JobS>();
        int i = 1;
        for (Job job : this.taskWrapper.getTask().getTaskJobs()) {
            ArrayList<ValidationsJobS> validationsJobS = new ArrayList<ValidationsJobS>();
            int j = 1;
            for (ValidationJob valJob : job.getValidationJobs()) {
                ValidationsJobS validationJ = new ValidationsJobS(String.valueOf(j), WorkerStateMap.map(valJob.getStatus()), valJob.getProgress(), valJob.getDescription(), valJob.getErrorMessage(), valJob.getHumaReadableStatus());
                validationsJobS.add(validationJ);
                ++j;
            }
            JobSClassifier jobClassifier = JobClassifierMap.map(job.getJobClassifier());
            JobS jobS = new JobS(String.valueOf(i), job.getProgress(), job.getHumaReadableStatus(), jobClassifier, job.getDescription(), WorkerStateMap.map(job.getStatus()), job.getErrorMessage(), validationsJobS);
            jobSList.add(jobS);
            ++i;
        }
        try {
            ArrayList<TRId> collateralTRIds = new ArrayList<TRId>();
            TaskResult taskResult = this.taskWrapper.getTask().getResult();
            if (taskResult != null) {
                List collaterals = taskResult.getCollateralTables();
                for (TableId tId : collaterals) {
                    String tabulRId = this.retrieveTabularResourceIdFromTable(tId);
                    TRId tabularRId = new TRId(tabulRId);
                    tabularRId.setTableId(String.valueOf(tId.getValue()));
                    collateralTRIds.add(tabularRId);
                }
            }
            taskS = new TaskS(this.taskWrapper.getTask().getId().getValue(), this.taskWrapper.getTask().getProgress(), TaskStateMap.map(this.taskWrapper.getTask().getStatus()), this.taskWrapper.getTask().getErrorCause(), this.taskWrapper.getTask().getSubmitter(), this.taskWrapper.getTask().getStartTime(), this.taskWrapper.getTask().getEndTime(), jobSList, collateralTRIds, String.valueOf(this.taskWrapper.getTask().getTabularResourceId().getValue()));
        }
        catch (Throwable e) {
            logger.error("error retrieving information about the task, " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("error retrieving information about the task, " + e.getLocalizedMessage());
        }
        logger.debug("Retrieved task information");
        return taskS;
    }

    protected void postOperation(OperationMonitor operationMonitor) throws TDGWTServiceException {
        switch (operationMonitor.getTask().getState()) {
            case FAILED: {
                Throwable errorCause = this.taskWrapper.getTask().getErrorCause();
                if (errorCause == null) {
                    logger.error("Task Exception: task is failed");
                    break;
                }
                logger.error("Task exception: " + errorCause.getLocalizedMessage());
                errorCause.printStackTrace();
                break;
            }
            case SUCCEDED: {
                logger.debug("Task Result:" + this.taskWrapper.getTask().getResult());
                this.updateInformations(operationMonitor);
                break;
            }
            case IN_PROGRESS: {
                break;
            }
            case VALIDATING_RULES: {
                break;
            }
            case GENERATING_VIEW: {
                break;
            }
            case ABORTED: {
                operationMonitor.setAbort(true);
                break;
            }
            case STOPPED: {
                logger.debug("Task Result:" + this.taskWrapper.getTask().getResult());
                this.updateInformations(operationMonitor);
                break;
            }
            case INITIALIZING: {
                break;
            }
        }
    }

    protected void updateInformations(OperationMonitor operationMonitor) throws TDGWTServiceException {
        switch (this.taskWrapper.getOperationId()) {
            case CSVExport: {
                Table table = this.taskWrapper.getTask().getResult().getPrimaryTable();
                logger.debug("Table retrived: " + table.toString());
                ExportMetadata exportMetadata = (ExportMetadata)table.getMetadata(ExportMetadata.class);
                logger.debug("ExportMetadata: " + exportMetadata);
                operationMonitor.setTrId(SessionUtil.getTRId(this.session));
                TabExportMetadata trExportMetadata = new TabExportMetadata();
                trExportMetadata.setUrl(exportMetadata.getUri());
                trExportMetadata.setDestinationType(exportMetadata.getDestinationType());
                trExportMetadata.setExportDate(sdf.format(exportMetadata.getExportDate()));
                this.saveCSVExportInDestination(exportMetadata);
                break;
            }
            case SDMXExport: {
                Table table = this.taskWrapper.getTask().getResult().getPrimaryTable();
                logger.debug("Table retrived: " + table.toString());
                ExportMetadata exportMetadata = (ExportMetadata)table.getMetadata(ExportMetadata.class);
                logger.debug("ExportMetadata: " + exportMetadata);
                operationMonitor.setTrId(SessionUtil.getTRId(this.session));
                break;
            }
            case JSONExport: {
                Table table = this.taskWrapper.getTask().getResult().getPrimaryTable();
                logger.debug("Table retrived: " + table.toString());
                ExportMetadata exportMetadata = (ExportMetadata)table.getMetadata(ExportMetadata.class);
                logger.debug("ExportMetadata: " + exportMetadata);
                operationMonitor.setTrId(SessionUtil.getTRId(this.session));
                TabExportMetadata trExportMetadata = new TabExportMetadata();
                trExportMetadata.setUrl(exportMetadata.getUri());
                trExportMetadata.setDestinationType(exportMetadata.getDestinationType());
                trExportMetadata.setExportDate(sdf.format(exportMetadata.getExportDate()));
                this.saveJSONExportInDestination(exportMetadata);
                break;
            }
            case CSVImport: {
                TRId trId = new TRId();
                trId.setId(this.taskWrapper.getTrId().getId());
                trId = this.retrieveTabularResourceBasicData(trId);
                operationMonitor.setTrId(trId);
                TabResource tabResource = SessionUtil.getCSVImportTabResource(this.session);
                if (tabResource != null) {
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                } else {
                    tabResource = new TabResource();
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                }
                logger.debug("CurrentTabResource set:" + tabResource);
                SessionUtil.setTRId(this.session, trId);
                SessionUtil.addToCurrentTabularResourcesOpen(this.session, tabResource);
                break;
            }
            case SDMXImport: {
                TRId trId = new TRId();
                trId.setId(this.taskWrapper.getTrId().getId());
                trId = this.retrieveTabularResourceBasicData(trId);
                operationMonitor.setTrId(trId);
                TabResource tabResource = SessionUtil.getSDMXImportTabResource(this.session);
                if (tabResource != null) {
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                } else {
                    tabResource = new TabResource();
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                }
                logger.debug("CurrentTabResource set:" + tabResource);
                SessionUtil.setTRId(this.session, trId);
                SessionUtil.addToCurrentTabularResourcesOpen(this.session, tabResource);
                break;
            }
            case Clone: {
                TRId trId = new TRId();
                trId.setId(this.taskWrapper.getTrId().getId());
                trId = this.retrieveTabularResourceBasicData(trId);
                operationMonitor.setTrId(trId);
                break;
            }
            default: {
                TRId trId = new TRId(this.taskWrapper.getTrId().getId());
                trId = this.retrieveTabularResourceBasicData(trId);
                operationMonitor.setTrId(trId);
                TabResource tabResource = SessionUtil.getTabResource(this.session);
                if (tabResource != null) {
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                } else {
                    tabResource = new TabResource();
                    tabResource.setTrId(trId);
                    SessionUtil.setTabResource(this.session, tabResource);
                }
                logger.debug("CurrentTabResource set:" + tabResource);
                SessionUtil.setTRId(this.session, trId);
            }
        }
    }

    protected TRId retrieveTabularResourceBasicData(TRId trId) throws TDGWTServiceException {
        try {
            ASLSession aslSession = SessionUtil.getAslSession(this.session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(new Long(trId.getId()).longValue());
            TabularResource tr = service.getTabularResource(tabularResourceId);
            if (tr == null) {
                logger.error("Tabular Resource Null [id=" + trId.getId() + "]");
                throw new TDGWTServiceException("Tabular Resource Null " + trId);
            }
            Table table = service.getLastTable(tabularResourceId);
            if (table == null) {
                logger.error("Last Table Null");
                throw new TDGWTServiceException("Last Table Null for " + tr);
            }
            Table viewTable = null;
            if (table.contains(DatasetViewTableMetadata.class)) {
                DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                try {
                    viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                }
                catch (Exception e) {
                    logger.error("view table not found");
                }
            }
            TRId newTRId = viewTable == null ? new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(table.getId().getValue()), table.getTableType().getName()) : new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(viewTable.getId().getValue()), viewTable.getTableType().getName(), String.valueOf(table.getId().getValue()), true);
            logger.debug("Retrieved TRId basic info:" + newTRId.toString());
            return newTRId;
        }
        catch (TDGWTSessionExpiredException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error Retrieving Basic Data: " + e.getLocalizedMessage());
        }
    }

    protected void saveCSVExportInDestination(ExportMetadata exportMetadata) throws TDGWTServiceException {
        CSVExportSession exportSession = SessionUtil.getCSVExportSession(this.session);
        String user = this.aslSession.getUsername();
        logger.debug("Save Export In Destination");
        logger.debug("Destination: " + exportSession.getDestination().getId());
        if (exportSession.getDestination().getId().compareTo("Workspace") == 0) {
            logger.debug("Save on Workspace");
            boolean end = SessionUtil.getCSVExportEnd(this.session);
            if (!end) {
                SessionUtil.setCSVExportEnd(this.session, true);
                FilesStorage storage = new FilesStorage();
                logger.debug("Create Item On Workspace: [ uri: " + exportMetadata.getUri() + " ,user: " + user + " ,fileName: " + exportSession.getFileName() + " ,fileDescription: " + exportSession.getFileDescription() + " ,mimetype: text/csv" + " ,folder: " + exportSession.getItemId() + "]");
                storage.createItemOnWorkspace(exportMetadata.getUri(), user, exportSession.getFileName(), exportSession.getFileDescription(), "text/csv", exportSession.getItemId());
            } else {
                logger.debug("getCSVExportEnd(): true");
            }
        } else {
            logger.error("Destination No Present");
            throw new TDGWTServiceException("Error in export csv: no destination present");
        }
    }

    protected void saveJSONExportInDestination(ExportMetadata exportMetadata) throws TDGWTServiceException {
        JSONExportSession exportSession = SessionUtil.getJSONExportSession(this.session);
        String user = this.aslSession.getUsername();
        logger.debug("Save Export In Destination");
        logger.debug("Destination: " + exportSession.getDestination().getId());
        if (exportSession.getDestination().getId().compareTo("Workspace") == 0) {
            logger.debug("Save on Workspace");
            boolean end = SessionUtil.getJSONExportEnd(this.session);
            if (!end) {
                SessionUtil.setJSONExportEnd(this.session, true);
                FilesStorage storage = new FilesStorage();
                logger.debug("Create Item On Workspace: [ uri: " + exportMetadata.getUri() + " ,user: " + user + " ,fileName: " + exportSession.getFileName() + " ,fileDescription: " + exportSession.getFileDescription() + " ,mimetype: application/json" + " ,folder: " + exportSession.getItemId() + "]");
                storage.createItemOnWorkspace(exportMetadata.getUri(), user, exportSession.getFileName(), exportSession.getFileDescription(), "application/json", exportSession.getItemId());
            } else {
                logger.debug("getJSONExportEnd(): true");
            }
        } else {
            logger.error("Destination No Present");
            throw new TDGWTServiceException("Error in export json: no destination present");
        }
    }

    private String retrieveTabularResourceIdFromTable(TableId tableId) throws TDGWTServiceException {
        try {
            AuthorizationProvider.instance.set(new AuthorizationToken(this.aslSession.getUsername(), this.aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(tableId);
            if (table.contains(TableDescriptorMetadata.class)) {
                TableDescriptorMetadata tdm = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
                return String.valueOf(tdm.getRefId());
            }
            throw new TDGWTServiceException("No TableDescriptorMetadata present in tableId: " + tableId);
        }
        catch (Exception e) {
            throw new TDGWTServiceException(e.getLocalizedMessage());
        }
    }
}

