/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.shared.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.csv4j.CSVReader;
import net.sf.csv4j.CSVWriter;
import net.sf.csv4j.ParseException;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVParserConfiguration;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVRowError;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CheckCSVSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileUtil {
    private static final int MAXROWCHECK = 1000000;
    protected static Logger logger = LoggerFactory.getLogger(CSVFileUtil.class);

    public static ArrayList<String> getHeader(File csvFile, CSVParserConfiguration parserConfiguration) throws ParseException, IOException {
        CSVReader csvReader = CSVFileUtil.createCSVReader(csvFile, parserConfiguration);
        switch (parserConfiguration.getHeaderPresence()) {
            case FIRST_LINE_COMMENTED_INCLUDED: {
                List<String> firstLine = CSVFileUtil.getFirstLine(csvReader, true);
                return new ArrayList<String>(firstLine);
            }
            case FIRST_LINE: {
                List<String> firstLine = CSVFileUtil.getFirstLine(csvReader, false);
                return new ArrayList<String>(firstLine);
            }
        }
        int fieldCount = (int)csvReader.countFields();
        ArrayList<String> fakeHeaders = new ArrayList<String>();
        int i = 0;
        while (i < fieldCount) {
            fakeHeaders.add("Field " + i);
            ++i;
        }
        return fakeHeaders;
    }

    public static List<String> getFirstLine(CSVReader csvReader, boolean includeComment) throws ParseException, IOException {
        logger.trace("getFirstLine includeComment: " + includeComment);
        List header = csvReader.readLine(includeComment);
        return header == null ? Collections.emptyList() : header;
    }

    protected static CSVReader createCSVReader(File csvFile, CSVParserConfiguration parserConfiguration) throws FileNotFoundException {
        logger.trace("createCSVReader csvFile: " + csvFile + " parserConfiguration: " + parserConfiguration);
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(csvFile), parserConfiguration.getCharset());
        CSVReader csvReader = new CSVReader((Reader)fileReader, parserConfiguration.getDelimiter(), parserConfiguration.getComment());
        return csvReader;
    }

    public static File skipError(File inCSVFile, CSVParserConfiguration config) throws ParseException, IOException {
        return CSVFileUtil.skipError(inCSVFile, config.getCharset(), config.getDelimiter(), config.getComment());
    }

    public static File skipError(File inCSVFile, Charset charset, char delimiter, char comment) throws ParseException, IOException {
        File outCSVFile = File.createTempFile("import", "csv");
        outCSVFile.deleteOnExit();
        BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inCSVFile), charset));
        BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outCSVFile), charset));
        CSVWriter csvWriter = new CSVWriter((Writer)fileWriter, delimiter, comment);
        CSVReader csvReader = new CSVReader((Reader)fileReader, delimiter, comment);
        List line = null;
        do {
            try {
                line = csvReader.readLine();
            }
            catch (ParseException exception) {
                logger.debug("Skip line:" + line.toString());
                continue;
            }
            csvWriter.writeLine(line);
        } while (line != null);
        csvReader.close();
        csvWriter.close();
        return outCSVFile;
    }

    public static CheckCSVSession checkCSV(File csvFile, CSVParserConfiguration config, long errorsLimit) throws ParseException, IOException {
        return CSVFileUtil.checkCSV(csvFile, config.getCharset(), config.getDelimiter(), config.getComment(), errorsLimit);
    }

    public static CheckCSVSession checkCSV(File csvFile, Charset charset, char delimiter, char comment, long errorsLimit) throws IOException {
        logger.trace("checkCSV charset: " + charset + " delimiter: " + delimiter + " comment: " + comment);
        ArrayList<CSVRowError> errors = new ArrayList<CSVRowError>();
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(csvFile), charset);
        CSVReader csvReader = new CSVReader((Reader)fileReader, delimiter, comment);
        long count = -1L;
        long fields = -1L;
        int maxRowCheck = 0;
        do {
            try {
                count = csvReader.countFields();
            }
            catch (ParseException exception) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Error parsing the file ");
                errorMessage.append(exception.getMessage());
                CSVRowError error = new CSVRowError(csvReader.getLineNumber(), csvReader.getCurrentLine(), errorMessage.toString());
                errors.add(error);
                logger.trace(error.getErrorDescription());
                continue;
            }
            if (count >= 0L) {
                if (fields < 0L) {
                    fields = count;
                } else if (fields != count) {
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append("Expected ");
                    errorMessage.append(fields);
                    errorMessage.append(" fields, found ");
                    errorMessage.append(count);
                    errorMessage.append(" fields. Check the format of your input file.");
                    CSVRowError error = new CSVRowError(csvReader.getLineNumber(), csvReader.getCurrentLine(), errorMessage.toString());
                    errors.add(error);
                    logger.trace(error.getErrorDescription());
                }
            }
            ++maxRowCheck;
        } while (count >= 0L && (long)errors.size() < errorsLimit && maxRowCheck < 1000000);
        CheckCSVSession checkCSVSesssion = maxRowCheck < 1000000 ? new CheckCSVSession(errors, false) : new CheckCSVSession(errors, true);
        return checkCSVSesssion;
    }

    public static void toJson(File csvFile, Charset inputCharset, File outputFile, Charset outputCharset, HeaderPresence headerPresence, char delimiter, char comment, long limit) throws ParseException, IOException {
        CSVFileUtil.toJson(new FileInputStream(csvFile), inputCharset, new FileOutputStream(outputFile), outputCharset, headerPresence, delimiter, comment, limit);
    }

    public static void toJson(InputStream csv, OutputStream output, Charset outputCharset, CSVParserConfiguration config, long limit) throws ParseException, IOException {
        CSVFileUtil.toJson(csv, config.getCharset(), output, outputCharset, config.getHeaderPresence(), config.getDelimiter(), config.getComment(), limit);
    }

    public static void toJson(InputStream csv, Charset inputCharset, OutputStream output, Charset outputCharset, HeaderPresence headerPresence, char delimiter, char comment, long limit) throws ParseException, IOException {
        String jsonLine;
        logger.trace("toJson charset: " + inputCharset + " delimiter: " + delimiter + " comment: " + comment);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, outputCharset));
        InputStreamReader reader = new InputStreamReader(csv, inputCharset);
        CSVReader csvReader = new CSVReader((Reader)reader, delimiter, comment);
        long count = 0L;
        if (headerPresence != HeaderPresence.NONE) {
            csvReader.readLine(headerPresence == HeaderPresence.FIRST_LINE_COMMENTED_INCLUDED);
        }
        writer.write("{\"records\":[");
        while ((jsonLine = csvReader.readJSonLine()) != null) {
            if (count > 0L) {
                writer.write(",");
            }
            writer.write(jsonLine);
            if (++count > limit) break;
        }
        writer.write("]}");
        csvReader.close();
        ((Writer)writer).close();
    }

    public static String guessEncoding(File file) throws IOException {
        int nread;
        FileInputStream fis = new FileInputStream(file);
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[4096];
        while ((nread = fis.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        detector.reset();
        fis.close();
        return encoding;
    }
}

