/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDDate;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDGeometry;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMap {
    protected static Logger logger = LoggerFactory.getLogger(ValueMap.class);
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public ArrayList<Map<String, Object>> genValueMap(TRId trId, ArrayList<ColumnData> columns, HashMap<String, String> fieldsMap) throws TDGWTServiceException {
        ArrayList<Map<String, Object>> composit = new ArrayList<Map<String, Object>>();
        if (fieldsMap == null) {
            return composit;
        }
        TableId tableId = trId.isViewTable() ? new TableId(new Long(trId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(trId.getTableId()).longValue());
        HashMap<String, String> parametersValue = fieldsMap;
        Set keys = parametersValue.keySet();
        block6: for (String key : keys) {
            String value = (String)parametersValue.get(key);
            for (ColumnData col : columns) {
                Double numeric;
                HashMap<String, Object> valueMap;
                ColumnReference colRef;
                ColumnLocalId columnId;
                HashMap<String, Object> valueMap2;
                ColumnReference colRef2;
                ColumnLocalId columnId2;
                if (col.getColumnId().compareTo(key) != 0) continue;
                if (col.getTypeCode().compareTo(ColumnTypeCode.DIMENSION.toString()) == 0 || col.getTypeCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
                    if (value == null) {
                        logger.error("Error, null value for on dimension or timedimension column is not valid");
                        continue;
                    }
                    TDInteger tdDim = new TDInteger(new Integer(value));
                    columnId2 = new ColumnLocalId(key);
                    colRef2 = new ColumnReference(tableId, columnId2);
                    valueMap2 = new HashMap<String, Object>();
                    valueMap2.put("field", colRef2);
                    valueMap2.put("toSetValue", tdDim);
                    composit.add(valueMap2);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Boolean.toString()) == 0) {
                    if (value == null) continue;
                    TDBoolean tdBoolean = new TDBoolean(new Boolean(value).booleanValue());
                    columnId2 = new ColumnLocalId(key);
                    colRef2 = new ColumnReference(tableId, columnId2);
                    valueMap2 = new HashMap();
                    valueMap2.put("field", colRef2);
                    valueMap2.put("toSetValue", tdBoolean);
                    composit.add(valueMap2);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Date.toString()) == 0) {
                    Date d;
                    try {
                        d = this.sdf.parse(value);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    TDDate tdDate = new TDDate(d);
                    columnId = new ColumnLocalId(key);
                    colRef = new ColumnReference(tableId, columnId);
                    valueMap = new HashMap<String, Object>();
                    valueMap.put("field", colRef);
                    valueMap.put("toSetValue", tdDate);
                    composit.add(valueMap);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Text.toString()) == 0) {
                    if (value == null) continue;
                    TDText tdText = new TDText(value);
                    columnId2 = new ColumnLocalId(key);
                    colRef2 = new ColumnReference(tableId, columnId2);
                    valueMap2 = new HashMap();
                    valueMap2.put("field", colRef2);
                    valueMap2.put("toSetValue", tdText);
                    composit.add(valueMap2);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Geometry.toString()) == 0) {
                    if (!TDGeometry.validateGeometry((String)value)) continue;
                    TDGeometry tdGeometry = new TDGeometry(value);
                    columnId2 = new ColumnLocalId(key);
                    colRef2 = new ColumnReference(tableId, columnId2);
                    valueMap2 = new HashMap();
                    valueMap2.put("field", colRef2);
                    valueMap2.put("toSetValue", tdGeometry);
                    composit.add(valueMap2);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Integer.toString()) == 0) {
                    Integer integ;
                    if (value == null) continue;
                    try {
                        integ = new Integer(value);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    TDInteger tdInteger = new TDInteger(integ);
                    columnId = new ColumnLocalId(key);
                    colRef = new ColumnReference(tableId, columnId);
                    valueMap = new HashMap();
                    valueMap.put("field", colRef);
                    valueMap.put("toSetValue", tdInteger);
                    composit.add(valueMap);
                    continue block6;
                }
                if (col.getDataTypeName().compareTo(ColumnDataType.Numeric.toString()) != 0) continue block6;
                if (value == null) continue;
                try {
                    numeric = new Double(value);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                TDNumeric tdNumeric = new TDNumeric(numeric);
                columnId = new ColumnLocalId(key);
                colRef = new ColumnReference(tableId, columnId);
                valueMap = new HashMap();
                valueMap.put("field", colRef);
                valueMap.put("toSetValue", tdNumeric);
                composit.add(valueMap);
                continue block6;
            }
        }
        return composit;
    }
}

