/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnTypeCodeMap;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistTargetColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnMockUp;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractCodelistOperationMap {
    protected static Logger logger = LoggerFactory.getLogger(ExtractCodelistOperationMap.class);

    public ArrayList<Map<String, Object>> genMap(ExtractCodelistSession extractCodelistSession) {
        logger.debug(extractCodelistSession.toString());
        ArrayList<Map<String, Object>> composit = new ArrayList<Map<String, Object>>();
        TRId trId = extractCodelistSession.getTrId();
        TableId tableId = trId.isViewTable() ? new TableId(new Long(trId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(trId.getTableId()).longValue());
        ArrayList<ExtractCodelistTargetColumn> targetColumns = extractCodelistSession.getTargetColumns();
        for (ExtractCodelistTargetColumn target : targetColumns) {
            HashMap<String, Object> mapCol = new HashMap<String, Object>();
            ColumnData sourceColumn = target.getSourceColumn();
            ColumnLocalId columnSourceId = new ColumnLocalId(sourceColumn.getColumnId());
            ColumnReference source = new ColumnReference(tableId, columnSourceId);
            if (target.isNewColumn()) {
                HashMap<String, Object> column_definition = new HashMap<String, Object>();
                ColumnMockUp defNewColumn = target.getDefColumn();
                ColumnTypeCode columnTypeCode = defNewColumn.getColumnType();
                ColumnType columnType = ColumnTypeCodeMap.getColumnType(columnTypeCode);
                column_definition.put("column_type", columnType);
                ArrayList<Object> metadata = new ArrayList<Object>();
                if (columnTypeCode == ColumnTypeCode.CODENAME) {
                    DataLocaleMetadata dataLocaleMetadata = new DataLocaleMetadata(defNewColumn.getLocaleName());
                    metadata.add(dataLocaleMetadata);
                }
                if (defNewColumn.getLabel() != null && !defNewColumn.getLabel().isEmpty()) {
                    String label = defNewColumn.getLabel();
                    ArrayList<ImmutableLocalizedText> texts = new ArrayList<ImmutableLocalizedText>();
                    texts.add(new ImmutableLocalizedText(label));
                    NamesMetadata nameMetadata = new NamesMetadata(texts);
                    metadata.add(nameMetadata);
                }
                if (metadata.size() > 0) {
                    column_definition.put("metadata", metadata);
                }
                TDText defaultValue = new TDText(defNewColumn.getDefaultValue());
                column_definition.put("default", defaultValue);
                mapCol.put("source", source);
                mapCol.put("column_definition", column_definition);
                composit.add(mapCol);
                continue;
            }
            ColumnData targetColumn = target.getTargetColumn();
            TRId codelistTRId = target.getCodelist();
            TableId codelistTableId = codelistTRId.isViewTable() ? new TableId(new Long(codelistTRId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(codelistTRId.getTableId()).longValue());
            ColumnLocalId targetCodeColumnId = new ColumnLocalId(targetColumn.getColumnId());
            ColumnReference targetCodeColumn = new ColumnReference(codelistTableId, targetCodeColumnId);
            mapCol.put("source", source);
            mapCol.put("target_code_column", targetCodeColumn);
            composit.add(mapCol);
        }
        logger.debug("ExtractCodelist Operation Map: " + composit.toString());
        return composit;
    }
}

