/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.expression.logical.Not;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.QueryService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TDTypeValueMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceEntry;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionGenerator {
    protected static Logger logger = LoggerFactory.getLogger(ExpressionGenerator.class);

    public static Expression genReplaceValueParameterCondition(ReplaceColumnSession replaceColumnSession, TabularDataService service) throws TDGWTServiceException {
        try {
            if (replaceColumnSession.isReplaceDimension()) {
                TableId tableId = replaceColumnSession.getColumnData().getTrId().isViewTable() ? new TableId(Long.valueOf(replaceColumnSession.getColumnData().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(replaceColumnSession.getColumnData().getTrId().getTableId()).longValue());
                ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(replaceColumnSession.getColumnData().getColumnViewData().getSourceTableDimensionColumnId()));
                String rowId = QueryService.retrieveColumnDimensionValue(replaceColumnSession.getRowId(), replaceColumnSession.getColumnData(), service);
                Equals eq = new Equals((Expression)cr, (Expression)new TDInteger(Integer.valueOf(Integer.parseInt(rowId))));
                return eq;
            }
            TableId tableId = replaceColumnSession.getColumnData().getTrId().isViewTable() ? new TableId(Long.valueOf(replaceColumnSession.getColumnData().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(replaceColumnSession.getColumnData().getTrId().getTableId()).longValue());
            ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(replaceColumnSession.getColumnData().getColumnId()));
            TDTypeValue td = TDTypeValueMap.map(replaceColumnSession.getColumnData().getDataTypeName(), replaceColumnSession.getValue());
            Equals eq = new Equals((Expression)cr, (Expression)td);
            return eq;
        }
        catch (Throwable e) {
            logger.debug("Error in genReplaceValueParameterCondition: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating condition parameter: " + e.getLocalizedMessage());
        }
    }

    public static Expression genReplaceValueParameterValue(ReplaceColumnSession replaceColumnSession) throws TDGWTServiceException {
        try {
            if (replaceColumnSession.isReplaceDimension()) {
                TDInteger value = new TDInteger(Integer.valueOf(Integer.parseInt(replaceColumnSession.getReplaceValue())));
                return value;
            }
            TDTypeValue td = TDTypeValueMap.map(replaceColumnSession.getColumnData().getDataTypeName(), replaceColumnSession.getReplaceValue());
            return td;
        }
        catch (Throwable e) {
            logger.debug("Error in genReplaceValueParameterValue: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating value parameter: " + e.getLocalizedMessage());
        }
    }

    public static Expression genReplaceValueParameterValue(ReplaceColumnByExpressionSession replaceColumnByExpressionSession) throws TDGWTServiceException {
        try {
            TDTypeValue td = TDTypeValueMap.map(replaceColumnByExpressionSession.getColumn().getDataTypeName(), replaceColumnByExpressionSession.getReplaceValue());
            return td;
        }
        catch (Throwable e) {
            logger.debug("Error in genReplaceValueParameterValue: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating value parameter: " + e.getLocalizedMessage());
        }
    }

    public static Expression genReplaceValueParameterCondition(ReplaceBatchColumnSession replaceBatchColumnSession, ReplaceEntry re) throws TDGWTServiceException {
        try {
            if (replaceBatchColumnSession.isReplaceDimension()) {
                TableId tableId = replaceBatchColumnSession.getColumnData().getTrId().isViewTable() ? new TableId(Long.valueOf(replaceBatchColumnSession.getColumnData().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(replaceBatchColumnSession.getColumnData().getTrId().getTableId()).longValue());
                ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(replaceBatchColumnSession.getColumnData().getColumnViewData().getSourceTableDimensionColumnId()));
                Equals eq = new Equals((Expression)cr, (Expression)new TDInteger(Integer.valueOf(Integer.parseInt(re.getRowId()))));
                return eq;
            }
            TableId tableId = replaceBatchColumnSession.getColumnData().getTrId().isViewTable() ? new TableId(Long.valueOf(replaceBatchColumnSession.getColumnData().getTrId().getReferenceTargetTableId()).longValue()) : new TableId(Long.valueOf(replaceBatchColumnSession.getColumnData().getTrId().getTableId()).longValue());
            ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(replaceBatchColumnSession.getColumnData().getColumnId()));
            TDTypeValue td = TDTypeValueMap.map(replaceBatchColumnSession.getColumnData().getDataTypeName(), re.getValue());
            Equals eq = new Equals((Expression)cr, (Expression)td);
            return eq;
        }
        catch (Throwable e) {
            logger.debug("Error in genReplaceValueParameterCondition: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating condition parameter: " + e.getLocalizedMessage());
        }
    }

    public static Expression genReplaceBatchValueParameterValue(ReplaceBatchColumnSession replaceBatchColumnSession, ReplaceEntry re) throws TDGWTServiceException {
        try {
            if (replaceBatchColumnSession.isReplaceDimension()) {
                TDInteger value = new TDInteger(Integer.valueOf(Integer.parseInt(re.getReplacementDimensionRow().getRowId())));
                return value;
            }
            TDTypeValue td = TDTypeValueMap.map(replaceBatchColumnSession.getColumnData().getDataTypeName(), re.getReplacementValue());
            return td;
        }
        catch (Throwable e) {
            logger.debug("Error in genReplaceBatchValueParameterValue: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating value parameter: " + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Expression genReplaceBatchOccurrencesFilter(OccurrencesForReplaceBatchColumnSession occurrencesSession) throws TDGWTServiceException {
        try {
            String validationColumnColumnId = occurrencesSession.getValidationColumnColumnId();
            ColumnData column = occurrencesSession.getColumnData();
            String tdId = column.getTrId().isViewTable() ? column.getTrId().getReferenceTargetTableId() : column.getTrId().getTableId();
            TableId tableId = new TableId(Long.valueOf(tdId).longValue());
            if (validationColumnColumnId != null && !validationColumnColumnId.isEmpty()) {
                ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(validationColumnColumnId));
                return new Not((Expression)cr);
            }
            ArrayList<String> validationColumnReferences = column.getValidationColumnReferences();
            ArrayList<ColumnReference> listColumnReference = new ArrayList<ColumnReference>();
            Iterator<String> iterator = validationColumnReferences.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (listColumnReference.size() > 0) break;
                    return null;
                }
                String columnLocalId = iterator.next();
                ColumnReference cr = new ColumnReference(tableId, new ColumnLocalId(columnLocalId));
                listColumnReference.add(cr);
            }
            if (listColumnReference.size() == 1) {
                return new Not((Expression)listColumnReference.get(0));
            }
            And and = new And(listColumnReference);
            return new Not((Expression)and);
        }
        catch (Throwable e) {
            logger.error("Error in genReplaceBatchOccurrencesFilter: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error generating occurences filter: " + e.getLocalizedMessage());
        }
    }

    public static Expression genEditRowParamaterCondition(TabularDataService service, TRId trId, String rowId) throws TDGWTServiceException {
        try {
            Equals exp = null;
            TableId tableId = trId.isViewTable() ? new TableId(new Long(trId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(trId.getTableId()).longValue());
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            List cols = table.getColumns();
            Column idCol = null;
            for (Column c : cols) {
                if (!(c.getColumnType() instanceof IdColumnType)) continue;
                idCol = c;
                break;
            }
            if (idCol != null) {
                ColumnReference cr = new ColumnReference(tableId, idCol.getLocalId());
                exp = new Equals((Expression)cr, (Expression)new TDInteger(Integer.valueOf(Integer.parseInt(rowId))));
            } else {
                logger.debug("No IdColumnType retrieved for table:" + table.getId().toString());
            }
            logger.debug("genEditRowParamaterCondition() condition:" + exp);
            return exp;
        }
        catch (Throwable e) {
            logger.error("Error in genEditRowParamaterCondition(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in genEditRowParamaterCondition(): " + e.getLocalizedMessage());
        }
    }
}

