/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.trservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionColumnsMapping;
import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMap {
    protected static Logger logger = LoggerFactory.getLogger(ColumnMap.class);

    public ArrayList<Map<String, Object>> genColumnMap(UnionSession unionSession) throws TDGWTServiceException {
        try {
            ArrayList<Map<String, Object>> composit = new ArrayList<Map<String, Object>>();
            logger.debug("UnionSession: " + unionSession);
            if (unionSession.getColumnsMatch() == null) {
                logger.debug("No columns match present");
                return composit;
            }
            TRId sourceTRId = unionSession.getTrId();
            TableId sourceTableId = sourceTRId.isViewTable() ? new TableId(new Long(sourceTRId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(sourceTRId.getTableId()).longValue());
            TabResource unionTR = unionSession.getUnionTabularResource();
            TRId targetTRId = unionTR.getTrId();
            TableId targetTableId = targetTRId.isViewTable() ? new TableId(new Long(targetTRId.getReferenceTargetTableId()).longValue()) : new TableId(new Long(targetTRId.getTableId()).longValue());
            ArrayList<UnionColumnsMapping> columnMatch = unionSession.getColumnsMatch();
            for (UnionColumnsMapping umap : columnMatch) {
                ColumnData sourceColumn = umap.getSourceColumn();
                ColumnData targetColumn = umap.getTargetColumn();
                logger.debug("On service sourceColumn and targetColumn are reversed");
                logger.debug("Service SourceColumn: " + targetColumn);
                logger.debug("Service TargetColumn: " + sourceColumn);
                if (sourceColumn == null || targetColumn == null) continue;
                ColumnLocalId sourceColumnId = new ColumnLocalId(sourceColumn.getColumnId());
                ColumnReference sourceColumnRef = new ColumnReference(sourceTableId, sourceColumnId);
                ColumnLocalId targetColumnId = new ColumnLocalId(targetColumn.getColumnId());
                ColumnReference targetColumnRef = new ColumnReference(targetTableId, targetColumnId);
                HashMap<String, ColumnReference> colMap = new HashMap<String, ColumnReference>();
                colMap.put("source", targetColumnRef);
                colMap.put("target", sourceColumnRef);
                composit.add(colMap);
            }
            return composit;
        }
        catch (Throwable e) {
            logger.debug("Error in ColumnMap: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in columns map: " + e.getLocalizedMessage());
        }
    }
}

