/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExpressionGenerator;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceEntry;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4ReplaceBatch
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4ReplaceBatch.class);
    private TabularDataService service;
    private ReplaceBatchColumnSession replaceBatchColumnSession;

    public OpExecution4ReplaceBatch(TabularDataService service, ReplaceBatchColumnSession replaceBatchColumnSession) {
        this.service = service;
        this.replaceBatchColumnSession = replaceBatchColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        ArrayList<OperationExecution> invocations = new ArrayList<OperationExecution>();
        logger.debug(this.replaceBatchColumnSession.toString());
        for (ReplaceEntry re : this.replaceBatchColumnSession.getReplaceEntryList()) {
            Expression value;
            Expression condition;
            OperationDefinition operationDefinition;
            OperationExecution invocation = null;
            HashMap<String, Expression> map = new HashMap<String, Expression>();
            if (this.replaceBatchColumnSession.isReplaceDimension()) {
                logger.debug("Is a Replace of view column");
                operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
                condition = ExpressionGenerator.genReplaceValueParameterCondition(this.replaceBatchColumnSession, re);
                value = ExpressionGenerator.genReplaceBatchValueParameterValue(this.replaceBatchColumnSession, re);
                map.put("condition", condition);
                map.put("value", value);
                invocation = new OperationExecution(this.replaceBatchColumnSession.getColumnData().getColumnViewData().getSourceTableDimensionColumnId(), operationDefinition.getOperationId(), map);
            } else {
                logger.debug("Is a Replace of basic column");
                operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
                condition = ExpressionGenerator.genReplaceValueParameterCondition(this.replaceBatchColumnSession, re);
                value = ExpressionGenerator.genReplaceBatchValueParameterValue(this.replaceBatchColumnSession, re);
                map.put("condition", condition);
                map.put("value", value);
                invocation = new OperationExecution(this.replaceBatchColumnSession.getColumnData().getColumnId(), operationDefinition.getOperationId(), map);
            }
            invocations.add(invocation);
        }
        this.operationExecutionSpec.setOps(invocations);
    }
}

