/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4LabelColumn
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4LabelColumn.class);
    private TabularDataService service;
    private LabelColumnSession labelColumnSession;

    public OpExecution4LabelColumn(TabularDataService service, LabelColumnSession labelColumnSession) {
        this.service = service;
        this.labelColumnSession = labelColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug("LabelColumnSession :" + this.labelColumnSession);
        HashMap<ColumnData, String> columnsMaps = this.labelColumnSession.getMaps();
        HashMap<ColumnReference, ImmutableLocalizedText> labels = new HashMap<ColumnReference, ImmutableLocalizedText>();
        TRId trId = this.labelColumnSession.getTrId();
        long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
        TableId tId = new TableId(tabId);
        for (ColumnData key : columnsMaps.keySet()) {
            ColumnLocalId cId = new ColumnLocalId(key.getColumnId());
            ColumnReference columnReference = new ColumnReference(tId, cId);
            ImmutableLocalizedText localizedText = new ImmutableLocalizedText(columnsMaps.get(key));
            labels.put(columnReference, localizedText);
        }
        OperationExecution invocation = null;
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ColumnNameAdd.toString(), this.service);
        HashMap<String, HashMap<ColumnReference, ImmutableLocalizedText>> map = new HashMap<String, HashMap<ColumnReference, ImmutableLocalizedText>>();
        map.put("NAME_PARAMETER_ID", labels);
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

