/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.json.JSONExportSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4JSONExport
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4JSONExport.class);
    private HttpSession session;
    private TabularDataService service;
    private JSONExportSession jsonExportSession;

    public OpExecution4JSONExport(HttpSession session, TabularDataService service, JSONExportSession jsonExportSession) {
        this.service = service;
        this.jsonExportSession = jsonExportSession;
        this.session = session;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug(this.jsonExportSession.toString());
        SessionUtil.setJSONExportEnd(this.session, false);
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.JSONExport.toString(), this.service);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("useView", Boolean.valueOf(this.jsonExportSession.isExportViewColumns()));
        map.put("columns", this.jsonExportSession.getColumnsAsString());
        OperationExecution invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

