/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnTypeCodeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TDTypeValueMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnMockUp;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4AddColumn
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4AddColumn.class);
    private TabularDataService service;
    private AddColumnSession addColumnSession;

    public OpExecution4AddColumn(TabularDataService service, AddColumnSession addColumnSession) {
        this.service = service;
        this.addColumnSession = addColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug(this.addColumnSession.toString());
        OperationExecution invocation = null;
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.AddColumn.toString(), this.service);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ColumnMockUp defNewColumn = this.addColumnSession.getColumn();
        ColumnTypeCode type = defNewColumn.getColumnType();
        switch (type) {
            case ANNOTATION: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(ColumnDataType.Text));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(ColumnDataType.Text, defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case ATTRIBUTE: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(defNewColumn.getColumnDataType()));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(defNewColumn.getColumnDataType(), defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case CODE: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(ColumnDataType.Text));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(ColumnDataType.Text, defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case CODEDESCRIPTION: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(ColumnDataType.Text));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(ColumnDataType.Text, defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case CODENAME: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(ColumnDataType.Text));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(ColumnDataType.Text, defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case DIMENSION: {
                break;
            }
            case MEASURE: {
                map.put("columnType", ColumnTypeCodeMap.getColumnType(defNewColumn.getColumnType()));
                map.put("dataType", ColumnDataTypeMap.map(defNewColumn.getColumnDataType()));
                map.put("label", new ImmutableLocalizedText(defNewColumn.getLabel()));
                map.put("value", TDTypeValueMap.map(defNewColumn.getColumnDataType(), defNewColumn.getDefaultValue()));
                invocation = new OperationExecution(operationDefinition.getOperationId(), map);
                break;
            }
            case TIMEDIMENSION: {
                break;
            }
        }
        this.operationExecutionSpec.setOp(invocation);
    }
}

