/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.utils.Licence;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.metadata.Metadata;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.DataTypeFormats;
import org.gcube.data.analysis.tabulardata.model.ValueFormat;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.PeriodTypeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.operation.TaskResult;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStepId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.AgencyMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.LicenceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.RightsMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.ValidSinceMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.ValidUntilMetadata;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTService;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.file.CSVFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.CodelistMappingFileUploadSession;
import org.gcube.portlets.user.td.gwtservice.server.file.FileUtil;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4AddColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4CSVExport;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeColumnType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeColumnsPosition;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChangeTableType;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ChartTopRating;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Clone;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4CodelistMapping;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4DeleteRows;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Denormalization;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Duplicates;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4EditRow;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ExtractCodelist;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4FilterColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GeometryCreatePoint;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GeospatialCreateCoordinates;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GeospatialDownscaleCSquare;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4GroupBy;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4JSONExport;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4LabelColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4MapCreation;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4MergeColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Normalization;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceBatch;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceByExternal;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4ReplaceColumnByExpression;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4SDMXCodelistImport;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4SplitColumn;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4StatisticalOperation;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4TimeAggregation;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecution4Union;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionDirector;
import org.gcube.portlets.user.td.gwtservice.server.resource.ResourceTDCreator;
import org.gcube.portlets.user.td.gwtservice.server.resource.ResourceTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.storage.FilesStorage;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExtractReferences;
import org.gcube.portlets.user.td.gwtservice.server.trservice.JobClassifierMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.LicenceMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.PeriodTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.QueryService;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TDTypeValueMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TabularResourceTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.TaskStateMap;
import org.gcube.portlets.user.td.gwtservice.shared.chart.ChartTopRatingSession;
import org.gcube.portlets.user.td.gwtservice.shared.codelisthelper.CodelistMappingSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.AvailableCharsetList;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVFileUtil;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CSVParserConfiguration;
import org.gcube.portlets.user.td.gwtservice.shared.csv.CheckCSVSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFlowException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.extract.ExtractCodelistSession;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadState;
import org.gcube.portlets.user.td.gwtservice.shared.file.HeaderPresence;
import org.gcube.portlets.user.td.gwtservice.shared.geometry.GeometryCreatePointSession;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialCreateCoordinatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialDownscaleCSquareSession;
import org.gcube.portlets.user.td.gwtservice.shared.history.OpHistory;
import org.gcube.portlets.user.td.gwtservice.shared.history.RollBackSession;
import org.gcube.portlets.user.td.gwtservice.shared.json.JSONExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.licenses.LicenceData;
import org.gcube.portlets.user.td.gwtservice.shared.map.MapCreationSession;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.BackgroundOperationMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.BackgroundOperationMonitorCreator;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.BackgroundOperationMonitorSession;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitorCreator;
import org.gcube.portlets.user.td.gwtservice.shared.monitor.OperationMonitorSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXExportSession;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.share.Contacts;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareTabResource;
import org.gcube.portlets.user.td.gwtservice.shared.share.ShareTemplate;
import org.gcube.portlets.user.td.gwtservice.shared.source.SDMXRegistrySource;
import org.gcube.portlets.user.td.gwtservice.shared.source.SourceType;
import org.gcube.portlets.user.td.gwtservice.shared.statistical.StatisticalOperationSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.InvocationS;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobS;
import org.gcube.portlets.user.td.gwtservice.shared.task.JobSClassifier;
import org.gcube.portlets.user.td.gwtservice.shared.task.State;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResubmitSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskS;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskWrapper;
import org.gcube.portlets.user.td.gwtservice.shared.task.ValidationsTasksMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateApplySession;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateData;
import org.gcube.portlets.user.td.gwtservice.shared.template.TemplateDeleteSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnViewData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ConditionCodeMap;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.PeriodDataType;
import org.gcube.portlets.user.td.gwtservice.shared.tr.RefColumn;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TableData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ValueDataFormat;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.Occurrences;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.OccurrencesForReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.clone.CloneTabularResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.AddColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ChangeColumnsPositionSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.DeleteColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.MergeColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.mapping.ColumnMappingData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.type.ChangeColumnTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupBySession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.TimeAggregationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRAgencyMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRDescriptionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLicenceMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRLocalizedText;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRNameMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRRightsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRValidSinceMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.metadata.TRValidUntilMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.DenormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.NormalizationSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.open.TDOpenSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadConfig;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.CodelistPagingLoadResult;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.Direction;
import org.gcube.portlets.user.td.gwtservice.shared.tr.paging.OrderInfo;
import org.gcube.portlets.user.td.gwtservice.shared.tr.replacebyexternal.ReplaceByExternalSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.InternalURITD;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.RemoveResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.ResourceTD;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.ResourceTDDescriptor;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.ResourceTDType;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.SaveResourceSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.StringResourceTD;
import org.gcube.portlets.user.td.gwtservice.shared.tr.resources.TableResourceTD;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DeleteRowsSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.DuplicatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.rows.EditRowSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.ChangeTableTypeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.Validations;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabDescriptionsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabExportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabGenericMapMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabImportMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabNamesMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabValidationsMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.table.metadata.TabVersionMetadata;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.gcube.portlets.user.td.gwtservice.shared.tr.union.UnionSession;
import org.gcube.portlets.user.td.gwtservice.shared.uriresolver.UriResolverSession;
import org.gcube.portlets.user.td.gwtservice.shared.user.UserInfo;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.mime.MimeTypeSupport;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.UIOperationsId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.RelationshipData;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDGWTServiceImpl
extends RemoteServiceServlet
implements TDGWTService {
    private static final String NO_VALID_TABULAR_RESOURCE_ID_PRESENT = "No valid tabular resource id present";
    private static final String TABULAR_RESOURCE_IS_FINAL = "Tabular Resource Is Final";
    private static final String TABULAR_RESOURCE_IS_LOCKED = "Tabular Resource Is Locked";
    private static final String SECURITY_EXCEPTION_RIGHTS = "Security exception, you don't have the required rights!";
    private static final long serialVersionUID = -5707400086333186368L;
    private static Logger logger = LoggerFactory.getLogger(TDGWTServiceImpl.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdfPerformance = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void init() throws ServletException {
        super.init();
    }

    @Override
    public UserInfo hello() throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession aslSession = SessionUtil.getAslSession(session);
        UserInfo userInfo = new UserInfo(aslSession.getUsername(), aslSession.getGroupId(), aslSession.getGroupName(), aslSession.getScope(), aslSession.getScopeName(), aslSession.getUserEmailAddress(), aslSession.getUserFullName());
        return userInfo;
    }

    @Override
    public ArrayList<PeriodDataType> getPeriodDataTypes() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            ArrayList<PeriodDataType> periodDataTypes = new ArrayList<PeriodDataType>();
            PeriodType[] periodTypeArray = PeriodType.values();
            int n = periodTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PeriodType period = periodTypeArray[n2];
                ArrayList<ValueDataFormat> valueDataFormats = new ArrayList<ValueDataFormat>();
                List listValueFormat = period.getAcceptedFormats();
                for (ValueFormat valueF : listValueFormat) {
                    ValueDataFormat valueDataFormat = new ValueDataFormat(valueF.getId(), valueF.getExample(), valueF.getRegExpr());
                    valueDataFormats.add(valueDataFormat);
                }
                PeriodDataType periodDataType = new PeriodDataType(period.name(), period.getName(), valueDataFormats);
                periodDataTypes.add(periodDataType);
                ++n2;
            }
            logger.debug("PeriodDataTypes: " + periodDataTypes);
            return periodDataTypes;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getPeriodDataTypes(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving period types: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<PeriodDataType> getHierarchicalRelationshipForPeriodDataTypes(PeriodDataType periodDataType) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            ArrayList<PeriodDataType> hierarchicalPeriodDataTypes = new ArrayList<PeriodDataType>();
            PeriodType periodType = PeriodTypeMap.map(periodDataType);
            List hierarchicalList = (List)PeriodType.getHierarchicalRelation().get(periodType);
            for (PeriodType period : hierarchicalList) {
                ArrayList<ValueDataFormat> valueDataFormats = new ArrayList<ValueDataFormat>();
                List listValueFormat = period.getAcceptedFormats();
                for (ValueFormat valueF : listValueFormat) {
                    ValueDataFormat valueDataFormat = new ValueDataFormat(valueF.getId(), valueF.getExample(), valueF.getRegExpr());
                    valueDataFormats.add(valueDataFormat);
                }
                PeriodDataType periodDT = new PeriodDataType(period.name(), period.getName(), valueDataFormats);
                hierarchicalPeriodDataTypes.add(periodDT);
            }
            logger.debug("hierarchicalPeriodDataTypes: " + hierarchicalPeriodDataTypes);
            return hierarchicalPeriodDataTypes;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getPeriodDataTypes(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving hierarchical list of period types: " + e.getLocalizedMessage());
        }
    }

    @Override
    public HashMap<ColumnDataType, ArrayList<ValueDataFormat>> getValueDataFormatsMap() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            HashMap<ColumnDataType, ArrayList<ValueDataFormat>> columnDataTypeFormats = new HashMap<ColumnDataType, ArrayList<ValueDataFormat>>();
            ColumnDataType[] columnDataTypeArray = ColumnDataType.values();
            int n = columnDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDataType columnDataType = columnDataTypeArray[n2];
                ArrayList<ValueDataFormat> valueDataFormats = new ArrayList<ValueDataFormat>();
                Class<? extends DataType> dataType = ColumnDataTypeMap.mapToDataTypeClass(columnDataType);
                for (ValueFormat valueF : DataTypeFormats.getFormatsPerDataType(dataType)) {
                    ValueDataFormat valueDataFormat = new ValueDataFormat(valueF.getId(), valueF.getExample(), valueF.getRegExpr());
                    valueDataFormats.add(valueDataFormat);
                }
                columnDataTypeFormats.put(columnDataType, valueDataFormats);
                ++n2;
            }
            logger.debug("getValueDataFormats(): " + columnDataTypeFormats);
            return columnDataTypeFormats;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getValueDataFormats(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving value data formats: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ValueDataFormat> getValueDataFormatsOfColumnDataType(ColumnDataType columnDataType) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            ArrayList<ValueDataFormat> valueDataFormats = new ArrayList<ValueDataFormat>();
            Class<? extends DataType> dataType = ColumnDataTypeMap.mapToDataTypeClass(columnDataType);
            for (ValueFormat valueF : DataTypeFormats.getFormatsPerDataType(dataType)) {
                ValueDataFormat valueDataFormat = new ValueDataFormat(valueF.getId(), valueF.getExample(), valueF.getRegExpr());
                valueDataFormats.add(valueDataFormat);
            }
            logger.debug("getValueDataFormatsOfColumnDataType(): [" + columnDataType + ", " + valueDataFormats + "]");
            return valueDataFormats;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getValueDataFormatsOfColumnDataType(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving value data formats: " + e.getLocalizedMessage());
        }
    }

    @Override
    public Integer pendingTasksRetrieve() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("pendingTasksRetrieve()");
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            ArrayList<TabularResource> pendingTR = new ArrayList<TabularResource>();
            List trs = service.getTabularResources();
            for (TabularResource tr : trs) {
                if (!tr.isLocked()) continue;
                pendingTR.add(tr);
            }
            Integer pendingNumber = 0;
            SessionUtil.removeAllTasksInBackground(session);
            for (TabularResource tr : pendingTR) {
                logger.debug("Pending Task:" + tr.getId());
                List tasksInitializing = service.getTasks(tr.getId(), TaskStatus.INITIALIZING);
                List tasksInProgress = service.getTasks(tr.getId(), TaskStatus.IN_PROGRESS);
                List tasksValidatingRules = service.getTasks(tr.getId(), TaskStatus.VALIDATING_RULES);
                HashMap<String, Task> tasks = new HashMap<String, Task>();
                for (Task t : tasksInitializing) {
                    tasks.put(t.getId().getValue(), t);
                }
                for (Task t : tasksInProgress) {
                    tasks.put(t.getId().getValue(), t);
                }
                for (Task t : tasksValidatingRules) {
                    tasks.put(t.getId().getValue(), t);
                }
                TRId trId = new TRId(String.valueOf(tr.getId().getValue()));
                for (String key : tasks.keySet()) {
                    TaskWrapper taskWrapper = new TaskWrapper((Task)tasks.get(key), UIOperationsId.Pending, trId);
                    SessionUtil.setTaskInBackground(session, taskWrapper);
                    pendingNumber = pendingNumber + 1;
                }
            }
            logger.debug("Pending number: " + pendingNumber);
            return pendingNumber;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("pendingTaskRetrieve(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving pending tasks: " + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TRId restoreUISession(TRId startTRId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (startTRId == null || startTRId.getId() == null || startTRId.getId().isEmpty()) {
                TRId trId = SessionUtil.getTRId(session);
                logger.debug("restoreUISession()");
                if (trId == null) {
                    logger.error("No UI Session");
                    return null;
                }
                logger.debug("Restore UI Session():" + trId);
                SessionUtil.removeAllFromCurrentTabularResourcesOpen(session);
                TabResource tabResource = SessionUtil.getTabResource(session);
                SessionUtil.addToCurrentTabularResourcesOpen(session, tabResource);
                return trId;
            }
            logger.debug("Restore UI Session() request TabularResource:" + startTRId);
            SessionUtil.removeAllFromCurrentTabularResourcesOpen(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(startTRId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tabularResource);
            TabResource tabResource = this.retrieveTRMetadataFromServiceAndLastTable(service, tabularResource, 1);
            if (tabResource.getTrId() != null && tabResource.getTrId().getId() != null && !tabResource.getTrId().getId().isEmpty()) {
                this.setCurrentTabResource(tabResource, session);
                return tabResource.getTrId();
            }
            return null;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("restoreUISession(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in UI Session Restore: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setTabResource(TabResource tabResource) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            this.setCurrentTabResource(tabResource, session);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error setting TabResource parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting TabResource parameter: " + e.getLocalizedMessage());
        }
    }

    private void setCurrentTabResource(TabResource tabResource, HttpSession session) throws TDGWTServiceException, TDGWTSessionExpiredException {
        if (tabResource == null) {
            logger.error("Error setting TabResource: null");
            throw new TDGWTServiceException("Error setting TabResource: null");
        }
        SessionUtil.setTabResource(session, tabResource);
        SessionUtil.setTRId(session, tabResource.getTrId());
        SessionUtil.addToCurrentTabularResourcesOpen(session, tabResource);
    }

    @Override
    public TRId getCurrentTRId() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            TRId trId = SessionUtil.getTRId(session);
            logger.debug("getCurrentTRId()");
            if (trId == null) {
                logger.error("Current Tabular Resource is null");
                throw new TDGWTServiceException("Current Tabular Resource is null");
            }
            logger.debug("getCurrentTRId():" + trId);
            return trId;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving TR id: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void closeAllTabularResources() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            SessionUtil.setTabResource(session, null);
            SessionUtil.setTRId(session, null);
            SessionUtil.removeAllFromCurrentTabularResourcesOpen(session);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving TR id: " + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void closeTabularResourceAndOpen(TRId openTRId, TRId closeTRId) throws TDGWTServiceException {
        try {
            logger.debug("closeTabularResourceAndOpen(): Open[" + openTRId + "], Close[" + closeTRId + "]");
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            SessionUtil.removeFromCurrentTabularResourcesOpen(session, closeTRId);
            if (openTRId == null) {
                SessionUtil.setTabResource(session, null);
                SessionUtil.setTRId(session, null);
                return;
            }
            TabResource tabResource = SessionUtil.getFromCurrentTabularResourcesOpen(session, openTRId);
            if (tabResource != null) {
                SessionUtil.setTabResource(session, tabResource);
                SessionUtil.setTRId(session, tabResource.getTrId());
                return;
            }
            logger.error("Set Active Tabular Resource failed, no valid id!: Open[" + openTRId + ", " + tabResource);
            throw new TDGWTServiceException("Set Active Tabular Resource failed, no valid id!: Open[" + openTRId + ", " + tabResource);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving TR id: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void closeTabularResource(TRId closeTRId) throws TDGWTServiceException {
        try {
            logger.debug("closeTabularResource(): " + closeTRId);
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            SessionUtil.removeFromCurrentTabularResourcesOpen(session, closeTRId);
            SessionUtil.setTabResource(session, null);
            SessionUtil.setTRId(session, null);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving TR id: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TRId setActiveTabularResource(TRId activeTRId) throws TDGWTServiceException {
        try {
            logger.debug("setActiveTabularResource(): " + activeTRId);
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TabResource tabResource = SessionUtil.getFromCurrentTabularResourcesOpen(session, activeTRId);
            if (tabResource != null) {
                AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
                TabularDataService service = TabularDataServiceFactory.getService();
                Table table = service.getLastTable(new TabularResourceId(Long.valueOf(tabResource.getTrId().getId()).longValue()));
                logger.debug("Table retrieved: " + table);
                if (table == null) {
                    logger.error("Last Table is Null: " + Long.valueOf(tabResource.getTrId().getId()));
                    new TDGWTServiceException("Last table is null");
                }
                Table viewTable = null;
                if (table.contains(DatasetViewTableMetadata.class)) {
                    DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                    logger.debug("DatasetViewTableMetadata: " + dwm);
                    try {
                        viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                    }
                    catch (Exception e) {
                        logger.error("View table not found: " + e.getLocalizedMessage());
                    }
                } else {
                    logger.debug("Table not contains DataseViewTableMetadata");
                }
                TRId trIdNew = tabResource.getTrId();
                if (viewTable == null) {
                    logger.debug("ViewTable is null");
                    String tableId = String.valueOf(table.getId().getValue());
                    if (tabResource.getTrId().getTableId().compareTo(tableId) == 0) {
                        trIdNew.setTableId(tableId);
                        trIdNew.setTableType(table.getTableType().getName());
                        trIdNew.setViewTable(false);
                        tabResource.setTrId(trIdNew);
                    } else {
                        trIdNew.setTableId(tableId);
                        trIdNew.setTableType(table.getTableType().getName());
                        trIdNew.setViewTable(false);
                        tabResource.setTrId(trIdNew);
                        SessionUtil.addToCurrentTabularResourcesOpen(session, tabResource);
                    }
                } else {
                    String tableId = String.valueOf(viewTable.getId().getValue());
                    if (tabResource.getTrId().getTableId().compareTo(tableId) == 0) {
                        trIdNew.setTableId(tableId);
                        trIdNew.setTableType(viewTable.getTableType().getName());
                        trIdNew.setReferenceTargetTableId(String.valueOf(table.getId().getValue()));
                        trIdNew.setViewTable(true);
                        tabResource.setTrId(trIdNew);
                    } else {
                        trIdNew.setTableId(tableId);
                        trIdNew.setTableType(viewTable.getTableType().getName());
                        trIdNew.setReferenceTargetTableId(String.valueOf(table.getId().getValue()));
                        trIdNew.setViewTable(true);
                        tabResource.setTrId(trIdNew);
                        SessionUtil.addToCurrentTabularResourcesOpen(session, tabResource);
                    }
                }
            } else {
                logger.error("Set Active Tabular Resource failed, no valid id: " + activeTRId);
                throw new TDGWTServiceException("Set Active Tabular Resource failed, no valid id: ");
            }
            SessionUtil.setTabResource(session, tabResource);
            SessionUtil.setTRId(session, tabResource.getTrId());
            logger.debug("New Active: " + tabResource.getTrId());
            return tabResource.getTrId();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("getCurrentTRID(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving TR id: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TabResource getInSessionTabResourceInfo() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            TabResource currentTR = SessionUtil.getTabResource(session);
            return currentTR;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error setting TabResource parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting TabResource parameter: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TabResource getTabResourceInformation() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TabResource currentTR = SessionUtil.getTabResource(session);
            if (currentTR == null) {
                logger.error("Current Tabular Resource is null");
                throw new TDGWTServiceException("Current Tabular Resource is null");
            }
            logger.debug("GetTabResourceInformation():" + currentTR.toString());
            if (currentTR.getTrId() == null) {
                logger.error("Current Tabular Resource has TRId null");
                throw new TDGWTServiceException("Current Tabular Resource has TRId null");
            }
            logger.debug("Current TRId: " + currentTR.getTrId());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(currentTR.getTrId().getId()).longValue()));
            ArrayList<TRMetadata> trMetadatas = this.getTRMetadata(tr);
            this.updateTabResourceInformation(currentTR, trMetadatas);
            currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
            currentTR.setValid(tr.isValid());
            currentTR.setFinalized(tr.isFinalized());
            currentTR.setLocked(tr.isLocked());
            Contacts owner = new Contacts("", tr.getOwner(), false);
            currentTR.setOwner(owner);
            currentTR.setContacts(this.retrieveShareInfo(tr));
            SessionUtil.setTabResource(session, currentTR);
            logger.debug("GetTabResourceInformation() updated information:" + currentTR.toString());
            return currentTR;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error setting TabResource parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting TabResource parameter: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TabResource getTabResourceInformation(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (trId == null) {
                logger.error("GetTabularREsourceInformation TRId is null");
                throw new TDGWTServiceException("GetTabularREsourceInformation TRId is  null");
            }
            logger.debug("GetTabResourceInformation:" + trId);
            TabResource currentTR = new TabResource();
            currentTR.setTrId(trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(currentTR.getTrId().getId()).longValue()));
            logger.debug("GetTabResourceInformation() TR on service: " + tr);
            ArrayList<TRMetadata> trMetadatas = this.getTRMetadata(tr);
            this.updateTabResourceInformation(currentTR, trMetadatas);
            currentTR.setDate(sdf.format(tr.getCreationDate().getTime()));
            currentTR.setValid(tr.isValid());
            currentTR.setFinalized(tr.isFinalized());
            currentTR.setLocked(tr.isLocked());
            Contacts owner = new Contacts("", tr.getOwner(), false);
            currentTR.setOwner(owner);
            currentTR.setContacts(this.retrieveShareInfo(tr));
            logger.debug("GetTabResourceInformation() updated information:" + currentTR);
            return currentTR;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error setting TabResource parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting TabResource parameter: " + e.getLocalizedMessage());
        }
    }

    private void updateTabResourceInformation(TabResource tabResource, ArrayList<TRMetadata> trMetadatas) {
        for (TRMetadata trMetadata : trMetadatas) {
            if (trMetadata instanceof TRDescriptionMetadata) {
                tabResource.setDescription(((TRDescriptionMetadata)trMetadata).getValue());
                continue;
            }
            if (trMetadata instanceof TRNameMetadata) {
                tabResource.setName(((TRNameMetadata)trMetadata).getValue());
                continue;
            }
            if (trMetadata instanceof TRAgencyMetadata) {
                tabResource.setAgency(((TRAgencyMetadata)trMetadata).getValue());
                continue;
            }
            if (trMetadata instanceof TRRightsMetadata) {
                tabResource.setRight(((TRRightsMetadata)trMetadata).getValue());
                continue;
            }
            if (trMetadata instanceof TRValidSinceMetadata) {
                tabResource.setValidFrom(((TRValidSinceMetadata)trMetadata).getValue());
                continue;
            }
            if (trMetadata instanceof TRValidUntilMetadata) {
                tabResource.setValidUntilTo(((TRValidUntilMetadata)trMetadata).getValue());
                continue;
            }
            if (!(trMetadata instanceof TRLicenceMetadata)) continue;
            tabResource.setLicence(((TRLicenceMetadata)trMetadata).getValue());
        }
    }

    @Override
    public Long getTimeTableId(PeriodDataType periodDataType) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTimeTable(PeriodTypeMap.map(periodDataType));
            if (table == null || table.getId() == null) {
                throw new TDGWTServiceException("Error retrieving Time Table: " + table);
            }
            return table.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Time Table: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Time Table: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumns() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TabResource currentTR = SessionUtil.getTabResource(session);
            if (currentTR == null) {
                logger.error("Current Tabular Resource is null");
                throw new TDGWTServiceException("Current Tabular Resource is null");
            }
            TRId trId = currentTR.getTrId();
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getLastTable(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnRelationship rel;
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType || c.contains(ViewColumnMetadata.class)) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if ((rel = c.getRelationship()) != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                cData.setTrId(trId);
                columns.add(cData);
                ++i;
            }
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumns(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getColumns():" + trId);
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnRelationship rel;
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType || c.contains(ViewColumnMetadata.class)) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if ((rel = c.getRelationship()) != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                cData.setTrId(trId);
                columns.add(cData);
                ++i;
            }
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumnWithViewColumnIncluded(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getColumns():" + trId.toString());
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnRelationship rel;
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if ((rel = c.getRelationship()) != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                if (c.contains(ViewColumnMetadata.class)) {
                    ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, c, periodTypeMetadata);
                    cData.setColumnViewData(columnViewData);
                    cData.setViewColumn(true);
                } else {
                    cData.setViewColumn(false);
                }
                cData.setTrId(trId);
                columns.add(cData);
                ++i;
            }
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumnWithOnlyViewColumnInRel(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getColumns():" + trId.toString());
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            ArrayList<ColumnData> dimensions = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnRelationship rel;
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if ((rel = c.getRelationship()) != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                if (c.contains(ViewColumnMetadata.class)) {
                    ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, c, periodTypeMetadata);
                    cData.setColumnViewData(columnViewData);
                    cData.setViewColumn(true);
                } else {
                    cData.setViewColumn(false);
                }
                cData.setTrId(trId);
                if (cData.getTypeCode().compareTo(ColumnTypeCode.DIMENSION.toString()) == 0 || cData.getTypeCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
                    dimensions.add(cData);
                }
                columns.add(cData);
                ++i;
            }
            ArrayList<ColumnData> removable = new ArrayList<ColumnData>();
            int k = 0;
            while (k < columns.size()) {
                ColumnData col = (ColumnData)columns.get(k);
                if (col.getColumnId() != null && col.isViewColumn()) {
                    ColumnViewData colViewData = col.getColumnViewData();
                    String sourceTableDimensionColumnId = colViewData.getSourceTableDimensionColumnId();
                    int j = 0;
                    while (j < dimensions.size()) {
                        ColumnData dim = (ColumnData)dimensions.get(j);
                        if (dim.getColumnId().compareTo(sourceTableDimensionColumnId) == 0) {
                            RelationshipData rel = dim.getRelationship();
                            if (rel != null) {
                                String cId = rel.getTargetColumnId();
                                if (cId != null && cId.compareTo(col.getColumnId()) == 0) break;
                                removable.add(col);
                                break;
                            }
                            removable.add(col);
                            break;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            columns.removeAll(removable);
            columns.removeAll(dimensions);
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumnsForStatistical(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getColumns():" + trId.toString());
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            ArrayList<ColumnData> columnsDimension = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnRelationship rel;
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if ((rel = c.getRelationship()) != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                if (c.contains(ViewColumnMetadata.class)) {
                    ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, c, periodTypeMetadata);
                    cData.setColumnViewData(columnViewData);
                    cData.setViewColumn(true);
                } else {
                    cData.setViewColumn(false);
                }
                cData.setTrId(trId);
                if (c.getColumnType() instanceof DimensionColumnType || c.getColumnType() instanceof TimeDimensionColumnType) {
                    columnsDimension.add(cData);
                } else {
                    columns.add(cData);
                }
                ++i;
            }
            block5: for (ColumnData colDimension : columnsDimension) {
                String cId;
                RelationshipData rel = colDimension.getRelationship();
                if (rel == null || (cId = rel.getTargetColumnId()) == null) continue;
                int j = 0;
                while (j < columns.size()) {
                    ColumnData col = columns.get(j);
                    if (col.getColumnId() != null && !col.getColumnId().isEmpty() && col.isViewColumn() && col.getColumnId().compareTo(cId) != 0 && col.getColumnViewData().getSourceTableDimensionColumnId().compareTo(colDimension.getColumnId()) == 0) {
                        columns.remove(col);
                        continue block5;
                    }
                    ++j;
                }
            }
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    private RelationshipData retrieveRelationship(TabularDataService service, Table table, Column c, PeriodTypeMetadata periodTypeMetadata, ColumnRelationship rel) throws TDGWTServiceException {
        RelationshipData relData = null;
        if (c.getColumnType().getCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
            Table timeTable = service.getTimeTable(periodTypeMetadata.getType());
            if (timeTable == null || timeTable.getId() == null) {
                throw new TDGWTServiceException("Error retrieving Time Table: " + table);
            }
            logger.debug("Time Table Id: " + timeTable.getId());
            Column timeColumn = timeTable.getColumnByName(periodTypeMetadata.getType().getName());
            relData = new RelationshipData(Long.valueOf(timeTable.getId().getValue()), timeColumn.getLocalId().getValue());
        } else {
            relData = new RelationshipData(Long.valueOf(rel.getTargetTableId().getValue()), rel.getTargetColumnId().getValue());
        }
        return relData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnViewData retrieveColumnViewData(TabularDataService service, Table table, Column c, PeriodTypeMetadata periodTypeMetadata) throws TDGWTServiceException {
        ViewColumnMetadata viewMetadata = (ViewColumnMetadata)c.getMetadata(ViewColumnMetadata.class);
        logger.debug("ViewColumnMetadata: " + viewMetadata.toString());
        ColumnViewData columnViewData = null;
        Column sourceColumn = table.getColumnById(viewMetadata.getSourceTableDimensionColumnId());
        if (sourceColumn.getColumnType().getCode().compareTo(ColumnTypeCode.TIMEDIMENSION.toString()) == 0) {
            PeriodTypeMetadata periodTypeMetadataSourceColumn = null;
            if (sourceColumn.contains(PeriodTypeMetadata.class)) {
                periodTypeMetadataSourceColumn = (PeriodTypeMetadata)sourceColumn.getMetadata(PeriodTypeMetadata.class);
                Table timeTable = service.getTimeTable(periodTypeMetadataSourceColumn.getType());
                if (timeTable == null) throw new TDGWTServiceException("Error retrieving Time Table: " + table);
                if (timeTable.getId() == null) {
                    throw new TDGWTServiceException("Error retrieving Time Table: " + table);
                }
                logger.debug("Time Table Id: " + timeTable.getId());
                Column timeColumn = timeTable.getColumnByName(periodTypeMetadataSourceColumn.getType().getName());
                String sourceTableDimensionColumnId = viewMetadata.getSourceTableDimensionColumnId().getValue();
                String targetTableColumnId = timeColumn.getLocalId().getValue();
                long targetTableId = timeTable.getId().getValue();
                return new ColumnViewData(sourceTableDimensionColumnId, targetTableColumnId, targetTableId);
            }
            logger.error("Error retrieving Time Table for view column:" + c + " , source column do not have a PeriodTypeMetadata: " + sourceColumn);
            throw new TDGWTServiceException("Error retrieving Time Table, source column do not have a PeriodTypeMetadata");
        }
        String sourceTableDimensionColumnId = viewMetadata.getSourceTableDimensionColumnId().getValue();
        String targetTableColumnId = viewMetadata.getTargetTableColumnId().getValue();
        long targetTableId = viewMetadata.getTargetTableId().getValue();
        return new ColumnViewData(sourceTableDimensionColumnId, targetTableColumnId, targetTableId);
    }

    @Override
    public ColumnData getColumn(String columnLocalId, TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ColumnData cData = new ColumnData();
            ColumnLocalId columnId = new ColumnLocalId(columnLocalId);
            Column c = table.getColumnById(columnId);
            if (!(c.getColumnType() instanceof IdColumnType)) {
                cData.setId(Integer.toString(0));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if (c.contains(ViewColumnMetadata.class)) {
                    ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, c, periodTypeMetadata);
                    cData.setColumnViewData(columnViewData);
                    cData.setViewColumn(true);
                } else {
                    cData.setViewColumn(false);
                }
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                ColumnRelationship rel = c.getRelationship();
                if (rel != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                cData.setTrId(trId);
            }
            return cData;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Column: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Column: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ColumnData getColumn(TRId trId, String columnName) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ColumnData cData = new ColumnData();
            Column c = table.getColumnByName(columnName);
            if (!(c.getColumnType() instanceof IdColumnType)) {
                cData.setId(Integer.toString(0));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                PeriodTypeMetadata periodTypeMetadata = null;
                if (c.contains(PeriodTypeMetadata.class)) {
                    periodTypeMetadata = (PeriodTypeMetadata)c.getMetadata(PeriodTypeMetadata.class);
                    PeriodType periodType = periodTypeMetadata.getType();
                    cData.setPeriodDataType(PeriodTypeMap.map(periodType));
                }
                if (c.contains(ViewColumnMetadata.class)) {
                    ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, c, periodTypeMetadata);
                    cData.setColumnViewData(columnViewData);
                    cData.setViewColumn(true);
                } else {
                    cData.setViewColumn(false);
                }
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                ColumnRelationship rel = c.getRelationship();
                if (rel != null) {
                    RelationshipData relData = this.retrieveRelationship(service, table, c, periodTypeMetadata, rel);
                    cData.setRelationship(relData);
                }
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                cData.setTrId(trId);
            }
            return cData;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Column: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Column: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getValidationColumns(String columnId, TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getValidationColumns():[" + trId.toString() + " columnLocalId: " + columnId + "]");
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            logger.debug("getValidationColumns() on Table: " + table.toString());
            ColumnLocalId id = new ColumnLocalId(columnId);
            Column columnSource = table.getColumnById(id);
            if (columnSource == null) {
                logger.error("Column not present on table");
                throw new TDGWTServiceException("Column not present on table");
            }
            logger.debug("getValidationColumns(): columnSource " + columnSource.getLocalId());
            String columnSourceId = columnSource.getLocalId().getValue();
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            block6: for (Column c : cols) {
                if (!(c.getColumnType() instanceof ValidationColumnType)) continue;
                logger.debug("ValidationColumn present: [" + c.getColumnType() + " " + c.getLocalId() + "]");
                if (!c.contains(ValidationReferencesMetadata.class)) continue;
                logger.debug("ValidationReferencesMetadata present");
                ValidationReferencesMetadata validationReferenceMetadata = (ValidationReferencesMetadata)c.getMetadata(ValidationReferencesMetadata.class);
                List valColumnList = validationReferenceMetadata.getValidationReferenceColumn();
                for (ColumnLocalId columnLocalId : valColumnList) {
                    if (columnLocalId.getValue().compareTo(columnSourceId) != 0) continue;
                    ColumnData cData = new ColumnData();
                    cData.setId(Integer.toString(i));
                    cData.setColumnId(c.getLocalId().getValue());
                    cData.setName(c.getName());
                    cData.setTypeCode(c.getColumnType().getCode());
                    cData.setTypeName(c.getColumnType().getName());
                    cData.setDataTypeName(c.getDataType().getName());
                    NamesMetadata labelsMetadata = null;
                    try {
                        labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                    }
                    catch (NoSuchMetadataException e) {
                        logger.debug("labelMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
                    }
                    if (labelsMetadata == null) {
                        cData.setLabel("nolabel");
                        logger.debug("LabelsMetadata no labels");
                    } else {
                        LocalizedText cl = null;
                        cl = labelsMetadata.getTextWithLocale("en");
                        if (cl == null) {
                            cData.setLabel("nolabel");
                            logger.debug("ColumnLabel no label in en");
                        } else {
                            cData.setLabel(cl.getValue());
                            logger.debug("Column Set Label: " + cl.getValue());
                        }
                    }
                    cData.setTrId(trId);
                    cData.setValidationColumn(true);
                    ArrayList<String> validatedColumnReferences = new ArrayList<String>();
                    for (ColumnLocalId cLocalId : valColumnList) {
                        validatedColumnReferences.add(cLocalId.getValue());
                    }
                    cData.setValidatedColumns(validatedColumnReferences);
                    columns.add(cData);
                    ++i;
                    continue block6;
                }
            }
            logger.debug("Validation Column: " + columns.size());
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Validation Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Validation Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getValidationColumns(TRId trId, String columnName) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getValidationColumns():[" + trId.toString() + " columnName: " + columnName + "]");
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            logger.debug("getValidationColumns() on Table: " + table.toString());
            Column columnSource = table.getColumnByName(columnName);
            if (columnSource == null) {
                logger.error("Column not present on table");
                throw new TDGWTServiceException("Column not present on table");
            }
            logger.debug("getValidationColumns(): columnSource " + columnSource.getLocalId());
            String columnSourceId = columnSource.getLocalId().getValue();
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            block6: for (Column c : cols) {
                if (!(c.getColumnType() instanceof ValidationColumnType)) continue;
                logger.debug("ValidationColumn present: [" + c.getColumnType() + " " + c.getLocalId() + "]");
                if (!c.contains(ValidationReferencesMetadata.class)) continue;
                logger.debug("ValidationReferencesMetadata present");
                ValidationReferencesMetadata validationReferenceMetadata = (ValidationReferencesMetadata)c.getMetadata(ValidationReferencesMetadata.class);
                List valColumnList = validationReferenceMetadata.getValidationReferenceColumn();
                for (ColumnLocalId columnLocalId : valColumnList) {
                    if (columnLocalId.getValue().compareTo(columnSourceId) != 0) continue;
                    ColumnData cData = new ColumnData();
                    cData.setId(Integer.toString(i));
                    cData.setColumnId(c.getLocalId().getValue());
                    cData.setName(c.getName());
                    cData.setTypeCode(c.getColumnType().getCode());
                    cData.setTypeName(c.getColumnType().getName());
                    cData.setDataTypeName(c.getDataType().getName());
                    NamesMetadata labelsMetadata = null;
                    try {
                        labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                    }
                    catch (NoSuchMetadataException e) {
                        logger.debug("labelMetadata: NoSuchMetadataException " + e.getLocalizedMessage());
                    }
                    if (labelsMetadata == null) {
                        cData.setLabel("nolabel");
                        logger.debug("LabelsMetadata no labels");
                    } else {
                        LocalizedText cl = null;
                        cl = labelsMetadata.getTextWithLocale("en");
                        if (cl == null) {
                            cData.setLabel("nolabel");
                            logger.debug("ColumnLabel no label in en");
                        } else {
                            cData.setLabel(cl.getValue());
                            logger.debug("Column Set Label: " + cl.getValue());
                        }
                    }
                    cData.setTrId(trId);
                    cData.setValidationColumn(true);
                    ArrayList<String> validatedColumnReferences = new ArrayList<String>();
                    for (ColumnLocalId cLocalId : valColumnList) {
                        validatedColumnReferences.add(cLocalId.getValue());
                    }
                    cData.setValidatedColumns(validatedColumnReferences);
                    columns.add(cData);
                    ++i;
                    continue block6;
                }
            }
            logger.debug("Validation Column: " + columns.size());
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving Validation Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Validation Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TableData getLastTable(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getLastTable(): " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getLastTable(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            logger.debug("Table retrieved: " + table);
            if (table == null) {
                logger.error("Last Table is Null: " + Long.valueOf(trId.getId()));
                new TDGWTServiceException("Last Table is Null");
            }
            Table viewTable = null;
            if (table.contains(DatasetViewTableMetadata.class)) {
                DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                logger.debug("DatasetViewTableMetadata: " + dwm);
                try {
                    viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                }
                catch (Exception e) {
                    logger.error("View table not found: " + e.getLocalizedMessage());
                }
            } else {
                logger.debug("Table not contains DataseViewTableMetadata");
            }
            TableData tData = new TableData();
            if (viewTable == null) {
                logger.debug("ViewTable is null");
                TRId newTRId = new TRId(trId.getId());
                newTRId.setTabResourceType(trId.getTabResourceType());
                newTRId.setTableTypeName(trId.getTableTypeName());
                newTRId.setTableId(String.valueOf(table.getId().getValue()));
                newTRId.setTableType(table.getTableType().getName());
                newTRId.setViewTable(false);
                logger.debug("NewTRId: " + newTRId);
                tData.setTrId(newTRId);
                tData.setName(table.getName());
                tData.setTypeName(table.getTableType().getName());
                tData.setTypeCode(table.getTableType().getCode());
                Collection cMeta = table.getAllMetadata();
                tData.setMetaData(cMeta.toString());
                ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
                for (Column column : table.getColumns()) {
                    ColumnRelationship rel;
                    ColumnData colData = new ColumnData();
                    colData.setColumnId(column.getLocalId().getValue());
                    colData.setName(column.getName());
                    colData.setTypeName(column.getColumnType().getName());
                    colData.setTypeCode(column.getColumnType().getCode());
                    colData.setDataTypeName(column.getDataType().getName());
                    colData.setTrId(newTRId);
                    PeriodTypeMetadata periodTypeMetadata = null;
                    if (column.contains(PeriodTypeMetadata.class)) {
                        periodTypeMetadata = (PeriodTypeMetadata)column.getMetadata(PeriodTypeMetadata.class);
                        PeriodType periodType = periodTypeMetadata.getType();
                        colData.setPeriodDataType(PeriodTypeMap.map(periodType));
                    }
                    if ((rel = column.getRelationship()) != null) {
                        RelationshipData relData = this.retrieveRelationship(service, table, column, periodTypeMetadata, rel);
                        colData.setRelationship(relData);
                    }
                    if (column.contains(ViewColumnMetadata.class)) {
                        ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, column, periodTypeMetadata);
                        colData.setColumnViewData(columnViewData);
                        colData.setViewColumn(true);
                    } else {
                        colData.setViewColumn(false);
                    }
                    lColumnData.add(colData);
                }
                tData.setListColumnData(lColumnData);
            } else {
                logger.debug("ViewTable is not null");
                TRId newTRId = new TRId(trId.getId());
                newTRId.setTabResourceType(trId.getTabResourceType());
                newTRId.setTableTypeName(trId.getTableTypeName());
                newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
                newTRId.setTableType(viewTable.getTableType().getName());
                newTRId.setReferenceTargetTableId(String.valueOf(table.getId().getValue()));
                newTRId.setViewTable(true);
                logger.debug("NewTRId: " + newTRId);
                tData.setTrId(newTRId);
                tData.setName(viewTable.getName());
                tData.setTypeName(viewTable.getTableType().getName());
                tData.setTypeCode(viewTable.getTableType().getCode());
                Collection cMeta = viewTable.getAllMetadata();
                tData.setMetaData(cMeta.toString());
                ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
                for (Column column : viewTable.getColumns()) {
                    ColumnRelationship rel;
                    ColumnData colData = new ColumnData();
                    colData.setColumnId(column.getLocalId().getValue());
                    colData.setName(column.getName());
                    colData.setTypeName(column.getColumnType().getName());
                    colData.setTypeCode(column.getColumnType().getCode());
                    colData.setDataTypeName(column.getDataType().getName());
                    colData.setTrId(newTRId);
                    PeriodTypeMetadata periodTypeMetadata = null;
                    if (column.contains(PeriodTypeMetadata.class)) {
                        periodTypeMetadata = (PeriodTypeMetadata)column.getMetadata(PeriodTypeMetadata.class);
                        PeriodType periodType = periodTypeMetadata.getType();
                        colData.setPeriodDataType(PeriodTypeMap.map(periodType));
                    }
                    if ((rel = column.getRelationship()) != null) {
                        RelationshipData relData = this.retrieveRelationship(service, viewTable, column, periodTypeMetadata, rel);
                        colData.setRelationship(relData);
                    }
                    if (column.contains(ViewColumnMetadata.class)) {
                        ColumnViewData columnViewData = this.retrieveColumnViewData(service, viewTable, column, periodTypeMetadata);
                        colData.setColumnViewData(columnViewData);
                        colData.setViewColumn(true);
                    } else {
                        colData.setViewColumn(false);
                    }
                    lColumnData.add(colData);
                }
                tData.setListColumnData(lColumnData);
            }
            logger.debug("getLastTable: " + tData);
            return tData;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getLastTable(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getLastTable(): " + e.getLocalizedMessage());
        }
    }

    @Override
    public TableData getTable(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getTable(): " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            Table viewTable = null;
            if (table.contains(DatasetViewTableMetadata.class)) {
                DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                try {
                    viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                }
                catch (Exception e) {
                    logger.error("view table not found");
                }
            }
            TableData tData = new TableData();
            if (viewTable == null) {
                logger.debug("ViewTable is null");
                TRId newTRId = new TRId(trId.getId());
                newTRId.setTabResourceType(trId.getTabResourceType());
                newTRId.setTableTypeName(trId.getTableTypeName());
                newTRId.setTableId(String.valueOf(table.getId().getValue()));
                newTRId.setTableType(table.getTableType().getName());
                newTRId.setViewTable(false);
                logger.debug("NewTRId: " + newTRId);
                tData.setTrId(newTRId);
                tData.setName(table.getName());
                tData.setTypeName(table.getTableType().getName());
                tData.setTypeCode(table.getTableType().getCode());
                Collection cMeta = table.getAllMetadata();
                tData.setMetaData(cMeta.toString());
                ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
                for (Column column : table.getColumns()) {
                    ColumnRelationship rel;
                    ColumnData colData = new ColumnData();
                    colData.setColumnId(column.getLocalId().getValue());
                    colData.setName(column.getName());
                    colData.setTypeName(column.getColumnType().getName());
                    colData.setTypeCode(column.getColumnType().getCode());
                    colData.setDataTypeName(column.getDataType().getName());
                    colData.setTrId(newTRId);
                    PeriodTypeMetadata periodTypeMetadata = null;
                    if (column.contains(PeriodTypeMetadata.class)) {
                        periodTypeMetadata = (PeriodTypeMetadata)column.getMetadata(PeriodTypeMetadata.class);
                        PeriodType periodType = periodTypeMetadata.getType();
                        colData.setPeriodDataType(PeriodTypeMap.map(periodType));
                    }
                    if ((rel = column.getRelationship()) != null) {
                        RelationshipData relData = this.retrieveRelationship(service, table, column, periodTypeMetadata, rel);
                        colData.setRelationship(relData);
                    }
                    if (column.contains(ViewColumnMetadata.class)) {
                        ColumnViewData columnViewData = this.retrieveColumnViewData(service, table, column, periodTypeMetadata);
                        colData.setColumnViewData(columnViewData);
                        colData.setViewColumn(true);
                    } else {
                        colData.setViewColumn(false);
                    }
                    lColumnData.add(colData);
                }
                tData.setListColumnData(lColumnData);
            } else {
                logger.debug("ViewTable is not null");
                TRId newTRId = new TRId(trId.getId());
                newTRId.setTabResourceType(trId.getTabResourceType());
                newTRId.setTableTypeName(trId.getTableTypeName());
                newTRId.setTableId(String.valueOf(viewTable.getId().getValue()));
                newTRId.setTableType(viewTable.getTableType().getName());
                newTRId.setReferenceTargetTableId(String.valueOf(table.getId().getValue()));
                newTRId.setViewTable(true);
                logger.debug("NewTRId: " + newTRId);
                tData.setTrId(newTRId);
                tData.setName(viewTable.getName());
                tData.setTypeName(viewTable.getTableType().getName());
                tData.setTypeCode(viewTable.getTableType().getCode());
                Collection cMeta = viewTable.getAllMetadata();
                tData.setMetaData(cMeta.toString());
                ArrayList<ColumnData> lColumnData = new ArrayList<ColumnData>();
                for (Column column : viewTable.getColumns()) {
                    ColumnRelationship rel;
                    ColumnData colData = new ColumnData();
                    colData.setColumnId(column.getLocalId().getValue());
                    colData.setName(column.getName());
                    colData.setTypeName(column.getColumnType().getName());
                    colData.setTypeCode(column.getColumnType().getCode());
                    colData.setDataTypeName(column.getDataType().getName());
                    colData.setTrId(newTRId);
                    PeriodTypeMetadata periodTypeMetadata = null;
                    if (column.contains(PeriodTypeMetadata.class)) {
                        periodTypeMetadata = (PeriodTypeMetadata)column.getMetadata(PeriodTypeMetadata.class);
                        PeriodType periodType = periodTypeMetadata.getType();
                        colData.setPeriodDataType(PeriodTypeMap.map(periodType));
                    }
                    if ((rel = column.getRelationship()) != null) {
                        RelationshipData relData = this.retrieveRelationship(service, viewTable, column, periodTypeMetadata, rel);
                        colData.setRelationship(relData);
                    }
                    if (column.contains(ViewColumnMetadata.class)) {
                        ColumnViewData columnViewData = this.retrieveColumnViewData(service, viewTable, column, periodTypeMetadata);
                        colData.setColumnViewData(columnViewData);
                        colData.setViewColumn(true);
                    } else {
                        colData.setViewColumn(false);
                    }
                    lColumnData.add(colData);
                }
                tData.setListColumnData(lColumnData);
            }
            logger.debug("getTable: " + tData);
            return tData;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getTable(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTable(): " + e.getLocalizedMessage());
        }
    }

    @Override
    public void tdOpen(TDOpenSession s) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            SessionUtil.setTDOpenSession(session, s);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error setting TDOpenSession parameter: " + e.getLocalizedMessage());
            throw new TDGWTServiceException("Error setting TDOpenSession parameter: " + e.getLocalizedMessage());
        }
    }

    private void syncTRMetaData(TabularResource tr, TabResource tabResource) {
        logger.debug("TRservice [id:" + tr.getId() + " ,creationDate:" + tr.getCreationDate() + "]");
        logger.debug("TabResource [name:" + tabResource.getName() + " ,description:" + tabResource.getDescription() + " ,agency:" + tabResource.getAgency() + " ,rights:" + tabResource.getRight() + "]");
        tabResource.setDate(sdf.format(tr.getCreationDate().getTime()));
        tabResource.setValid(tr.isValid());
        tabResource.setFinalized(tr.isFinalized());
        tabResource.setLocked(tr.isLocked());
        ArrayList<Object> meta = new ArrayList<Object>();
        meta.add(new NameMetadata(tabResource.getName()));
        meta.add(new DescriptionMetadata(tabResource.getDescription()));
        if (tabResource.getAgency() != null && !tabResource.getAgency().isEmpty()) {
            meta.add(new AgencyMetadata(tabResource.getAgency()));
        }
        meta.add(new RightsMetadata(tabResource.getRight()));
        if (tabResource.getValidFrom() != null && !tabResource.getValidFrom().isEmpty()) {
            try {
                Date dateF = sdfDate.parse(tabResource.getValidFrom());
                GregorianCalendar validFromC = new GregorianCalendar();
                validFromC.setTime(dateF);
                ValidSinceMetadata validSince = new ValidSinceMetadata();
                validSince.setValue((Calendar)validFromC);
                meta.add(validSince);
            }
            catch (ParseException e) {
                logger.info("ValidFromMetadata is not set, no valid calendar present");
            }
        }
        if (tabResource.getValidUntilTo() != null && !tabResource.getValidUntilTo().isEmpty()) {
            try {
                Date dateU = sdfDate.parse(tabResource.getValidUntilTo());
                GregorianCalendar validUntilToC = new GregorianCalendar();
                validUntilToC.setTime(dateU);
                ValidUntilMetadata validUntil = new ValidUntilMetadata((Calendar)validUntilToC);
                meta.add(validUntil);
            }
            catch (ParseException e) {
                logger.info("ValidUntilMetadata is not set, no valid calendar present");
            }
        }
        if (tabResource.getLicence() != null && !tabResource.getLicence().isEmpty()) {
            LicenceMetadata licenceMetadata = new LicenceMetadata();
            Licence licence = LicenceMap.map(tabResource.getLicence());
            if (licence != null) {
                licenceMetadata.setValue(licence);
                meta.add(licenceMetadata);
            } else {
                logger.error("Licence type not found: " + tabResource.getLicence());
            }
        }
        tr.setAllMetadata(meta);
    }

    private TabResource retrieveTRMetadataFromService(TabularDataService service, TabularResource tr, int i) throws TDGWTServiceException {
        try {
            LicenceMetadata licenceMeta;
            ValidUntilMetadata validUntilMeta;
            ValidSinceMetadata validSinceMeta;
            TabResource t = new TabResource();
            TRId trId = new TRId(String.valueOf(tr.getId().getValue()));
            trId.setTabResourceType(TabularResourceTypeMap.map(tr.getTabularResourceType()));
            trId.setTableTypeName(tr.getTableType());
            t.setId(String.valueOf(i));
            t.setTrId(trId);
            t.setValid(tr.isValid());
            t.setFinalized(tr.isFinalized());
            t.setLocked(tr.isLocked());
            Contacts owner = new Contacts("", tr.getOwner(), false);
            t.setOwner(owner);
            if (tr.contains(NameMetadata.class)) {
                NameMetadata nameMeta = (NameMetadata)tr.getMetadata(NameMetadata.class);
                if (nameMeta != null && nameMeta.getValue() != null) {
                    t.setName(nameMeta.getValue());
                } else {
                    t.setName("Unknown_" + trId.getId());
                }
            } else {
                t.setName("Unknown_" + trId.getId());
            }
            if (tr.contains(AgencyMetadata.class)) {
                AgencyMetadata agencyMeta = (AgencyMetadata)tr.getMetadata(AgencyMetadata.class);
                if (agencyMeta != null && agencyMeta.getValue() != null) {
                    t.setAgency(agencyMeta.getValue());
                } else {
                    t.setAgency("");
                }
            } else {
                t.setAgency("");
            }
            t.setDate(sdf.format(tr.getCreationDate().getTime()));
            if (tr.contains(ValidSinceMetadata.class) && (validSinceMeta = (ValidSinceMetadata)tr.getMetadata(ValidSinceMetadata.class)) != null && validSinceMeta.getValue() != null) {
                Calendar validSinceC = validSinceMeta.getValue();
                t.setValidFrom(sdfDate.format(validSinceC.getTime()));
            }
            if (tr.contains(ValidUntilMetadata.class) && (validUntilMeta = (ValidUntilMetadata)tr.getMetadata(ValidUntilMetadata.class)) != null && validUntilMeta.getValue() != null) {
                Calendar validUntilC = validUntilMeta.getValue();
                t.setValidUntilTo(sdfDate.format(validUntilC.getTime()));
            }
            if (tr.contains(LicenceMetadata.class) && (licenceMeta = (LicenceMetadata)tr.getMetadata(LicenceMetadata.class)) != null && licenceMeta.getValue() != null) {
                t.setLicence(licenceMeta.getValue().toString());
            }
            return t;
        }
        catch (Throwable e) {
            logger.error("Error retrieving tabular resources metadata in retrieveTRMetadataFromService(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving tabular resources metadata in retrieveTRMetadataFromService() on server");
        }
    }

    private TabResource retrieveTRMetadataFromServiceAndLastTable(TabularDataService service, TabularResource tr, int i) throws TDGWTServiceException {
        TabResource t;
        Table table = null;
        try {
            table = service.getLastTable(tr.getId());
        }
        catch (Throwable e) {
            logger.error("Error retrieving last table: " + e.getMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving last table: " + e.getMessage());
        }
        TableId tableId = null;
        Table viewTable = null;
        if (table == null) {
            logger.info("Tabular resource " + tr.getId() + " has no table.");
            t = new TabResource();
            t.setTrId(null);
        } else {
            tableId = table.getId();
            if (tableId == null) {
                logger.info("Tabular Resource " + tr.getId() + " has last table with id null.");
                t = new TabResource();
                t.setTrId(null);
            } else {
                if (table.contains(DatasetViewTableMetadata.class)) {
                    DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                    try {
                        viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                    }
                    catch (Exception e) {
                        logger.error("view table not found");
                    }
                }
                TRId trId = viewTable == null ? new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(tableId.getValue()), table.getTableType().getName()) : new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(viewTable.getId().getValue()), viewTable.getTableType().getName(), String.valueOf(tableId.getValue()), true);
                t = this.getTabResourceInformation(trId);
            }
        }
        t.setId(String.valueOf(i));
        return t;
    }

    @Override
    public void setCodelistsPagingLoader() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            CodelistTableType codType = new CodelistTableType();
            List trs = service.getTabularResourcesByType(codType.getName());
            SessionUtil.setTabularResources(session, trs);
            ArrayList<TabResource> ltr = new ArrayList<TabResource>();
            int i = 0;
            while (i < trs.size()) {
                TabularResource tr = (TabularResource)trs.get(i);
                try {
                    TabResource t = this.retrieveTRMetadataFromService(service, tr, i);
                    if (t.getTrId() != null && t.isValid() && t.isFinalized()) {
                        ltr.add(t);
                    }
                }
                catch (Throwable e) {
                    logger.error("TabResource discarded: " + tr + " cause: " + e.getMessage());
                }
                ++i;
            }
            logger.debug("Codelists retrived: " + ltr);
            SessionUtil.setCodelistsPagingLoaded(session, ltr);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("Error retrieving Codelist in setCodelistsPagingLoader(): " + e.getLocalizedMessage());
            throw new TDGWTServiceException("Error retrieving Codelist: " + e.getLocalizedMessage());
        }
    }

    @Override
    public CodelistPagingLoadResult getCodelistsPagingLoader(CodelistPagingLoadConfig plc) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            logger.debug(plc.toString());
            ArrayList<TabResource> ltr = SessionUtil.getCodelistsPagingLoaded(session);
            if (ltr == null) {
                logger.error("Error no codelist present in session");
                throw new TDGWTServiceException("Error no codelist present in session");
            }
            ArrayList<TabResource> ltrTemp = new ArrayList<TabResource>();
            if (ltr.size() != 0) {
                ArrayList<TabResource> ltrCopy = this.filterPagingRow(plc, ltr, session);
                if ((ltrCopy = this.OrderPagingRow(plc, ltrCopy, session)).size() != 0) {
                    if (plc.getOffset() < 0 || plc.getOffset() >= ltrCopy.size()) {
                        logger.error("Error CodelistPagingLoadConfig no valid range request, listsize: " + ltrCopy.size());
                        throw new TDGWTServiceException("Error CodelistPagingLoadConfig no valid range request");
                    }
                    int request_end = plc.getOffset() + plc.getLimit();
                    if (request_end > ltrCopy.size()) {
                        request_end = ltrCopy.size();
                    }
                    int i = plc.getOffset();
                    while (i < request_end) {
                        try {
                            ltrTemp.add(ltrCopy.get(i));
                        }
                        catch (IndexOutOfBoundsException e) {
                            logger.debug("OutOfBounds in getCodelistsPagingLoader() size:" + ltrCopy.size() + " index: " + i + " Error:" + e.getMessage() + "\n");
                        }
                        ++i;
                    }
                }
            }
            CodelistPagingLoadResult codelistPagingLoadResult = new CodelistPagingLoadResult();
            codelistPagingLoadResult.setFilter(plc.getFilter());
            codelistPagingLoadResult.setListOrderInfo(plc.getListOrderInfo());
            codelistPagingLoadResult.setLimit(plc.getLimit());
            codelistPagingLoadResult.setOffset(plc.getOffset());
            codelistPagingLoadResult.setTotalLenght(ltrTemp.size());
            codelistPagingLoadResult.setLtr(ltrTemp);
            logger.debug("Codelists retrieved: " + ltrTemp);
            return codelistPagingLoadResult;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("Error retrieving Codelist in getCodelistsPagingLoader(): " + e.getLocalizedMessage());
            throw new TDGWTServiceException("Error retrieving Codelist: " + e.getLocalizedMessage());
        }
    }

    private ArrayList<TabResource> filterPagingRow(CodelistPagingLoadConfig plc, ArrayList<TabResource> ltr, HttpSession session) {
        String filter = SessionUtil.getCodelistsPagingLoadedFilter(session);
        ArrayList<TabResource> ltrCopy = new ArrayList<TabResource>();
        SessionUtil.setCodelistsPagingLoadedFilter(session, plc.getFilter());
        if (filter == null) {
            logger.debug("No filter filter present in session");
            logger.debug("New Filter: " + plc.getFilter());
            if (plc.getFilter() == null || plc.getFilter().isEmpty()) {
                SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
                return ltr;
            }
            for (TabResource tr : ltr) {
                if (tr.getName() != null && !tr.getName().isEmpty() && tr.getName().contains(plc.getFilter())) {
                    ltrCopy.add(tr);
                    continue;
                }
                if (tr.getAgency() == null || tr.getAgency().isEmpty() || !tr.getAgency().contains(plc.getFilter())) continue;
                ltrCopy.add(tr);
            }
            SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltrCopy);
            return ltrCopy;
        }
        logger.debug("Old Filter:" + filter);
        logger.debug("New Filter: " + plc.getFilter());
        if (plc.getFilter() == null || plc.getFilter().isEmpty()) {
            SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltr);
            return ltr;
        }
        if (filter.compareTo(plc.getFilter()) == 0) {
            ArrayList<TabResource> ltrFilteredCopy = SessionUtil.getCodelistsPagingLoadedFilteredCopy(session);
            return ltrFilteredCopy;
        }
        for (TabResource tr : ltr) {
            if (tr.getName() != null && !tr.getName().isEmpty() && tr.getName().contains(plc.getFilter())) {
                ltrCopy.add(tr);
                continue;
            }
            if (tr.getAgency() == null || tr.getAgency().isEmpty() || !tr.getAgency().contains(plc.getFilter())) continue;
            ltrCopy.add(tr);
        }
        SessionUtil.setCodelistsPagingLoadedFilteredCopy(session, ltrCopy);
        return ltrCopy;
    }

    private ArrayList<TabResource> OrderPagingRow(CodelistPagingLoadConfig plc, ArrayList<TabResource> ltrCopy, HttpSession session) {
        ArrayList<OrderInfo> orders = plc.getListOrderInfo();
        for (OrderInfo order : orders) {
            Direction direction;
            if (order.getField().compareTo("name") == 0) {
                direction = order.getDirection();
                if (direction == Direction.ASC) {
                    Collections.sort(ltrCopy, new Comparator<TabResource>(){

                        @Override
                        public int compare(TabResource tr1, TabResource tr2) {
                            int comp = 0;
                            comp = tr1.getName() == null ? -1 : (tr2.getName() == null ? 1 : tr1.getName().compareTo(tr2.getName()));
                            return comp;
                        }
                    });
                } else {
                    Collections.sort(ltrCopy, new Comparator<TabResource>(){

                        @Override
                        public int compare(TabResource tr1, TabResource tr2) {
                            int comp = 0;
                            comp = tr1.getName() == null ? -1 : (tr2.getName() == null ? 1 : tr1.getName().compareTo(tr2.getName()));
                            return -comp;
                        }
                    });
                }
                logger.debug("LTR Ordered by name;");
                continue;
            }
            if (order.getField().compareTo("agency") == 0) {
                direction = order.getDirection();
                if (direction == Direction.ASC) {
                    Collections.sort(ltrCopy, new Comparator<TabResource>(){

                        @Override
                        public int compare(TabResource tr1, TabResource tr2) {
                            int comp = 0;
                            comp = tr1.getAgency() == null ? -1 : (tr2.getAgency() == null ? 1 : tr1.getAgency().compareTo(tr2.getAgency()));
                            return comp;
                        }
                    });
                } else {
                    Collections.sort(ltrCopy, new Comparator<TabResource>(){

                        @Override
                        public int compare(TabResource tr1, TabResource tr2) {
                            int comp = 0;
                            comp = tr1.getAgency() == null ? -1 : (tr2.getAgency() == null ? 1 : tr1.getAgency().compareTo(tr2.getAgency()));
                            return -comp;
                        }
                    });
                }
                logger.debug("LTR Ordered by agency;");
                continue;
            }
            if (order.getField().compareTo("date") != 0) continue;
            direction = order.getDirection();
            if (direction == Direction.ASC) {
                Collections.sort(ltrCopy, new Comparator<TabResource>(){

                    @Override
                    public int compare(TabResource tr1, TabResource tr2) {
                        int comp = 0;
                        comp = tr1.getDate() == null ? -1 : (tr2.getDate() == null ? 1 : tr1.getDate().compareTo(tr2.getDate()));
                        return comp;
                    }
                });
            } else {
                Collections.sort(ltrCopy, new Comparator<TabResource>(){

                    @Override
                    public int compare(TabResource tr1, TabResource tr2) {
                        int comp = 0;
                        comp = tr1.getDate() == null ? -1 : (tr2.getDate() == null ? 1 : tr1.getDate().compareTo(tr2.getDate()));
                        return -comp;
                    }
                });
            }
            logger.debug("LTR Ordered by date;");
        }
        return ltrCopy;
    }

    @Override
    public ArrayList<TabResource> getTabularResourcesAndLastTables() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTabularResources");
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            List trs = service.getTabularResources();
            SessionUtil.setTabularResources(session, trs);
            ArrayList<TabResource> ltr = new ArrayList<TabResource>();
            int i = 0;
            while (i < trs.size()) {
                TabularResource tr = (TabularResource)trs.get(i);
                logger.debug("GetTabularResources RetrieveMetadataAndLastTables");
                try {
                    TabResource t = this.retrieveTRMetadataFromServiceAndLastTable(service, tr, i);
                    if (t.getTrId() != null) {
                        ltr.add(t);
                    }
                }
                catch (Throwable e) {
                    logger.error("TabResource discarded: " + tr + " cause: " + e.getMessage());
                }
                ++i;
            }
            logger.debug("Tabular Resources retrived: " + ltr);
            return ltr;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("Error retrieving TabularResources: " + e.getLocalizedMessage());
            throw new TDGWTServiceException("Error retrieving TabularResources: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<TabResource> getTabularResources() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTabularResources");
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            List trs = service.getTabularResources();
            SessionUtil.setTabularResources(session, trs);
            ArrayList<TabResource> ltr = new ArrayList<TabResource>();
            int i = 0;
            while (i < trs.size()) {
                TabularResource tr = (TabularResource)trs.get(i);
                try {
                    TabResource t = this.retrieveTRMetadataFromService(service, tr, i);
                    if (t.getTrId() != null) {
                        ltr.add(t);
                    }
                }
                catch (Throwable e) {
                    logger.error("TabResource discarded: " + tr + " cause: " + e.getMessage());
                }
                ++i;
            }
            logger.debug("Tabular Resources retrieved: " + ltr);
            return ltr;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("Error retrieving TabularResources: " + e.getLocalizedMessage());
            throw new TDGWTServiceException("Error retrieving TabularResources: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void removeTabularResource(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (trId == null) {
                logger.error("Error removing TabularResource: trId is null");
                throw new TDGWTServiceException("Error removing TabularResource no parameters set");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabResourceId);
            this.checkTabularResourceLocked(tabularResource);
            String owner = tabularResource.getOwner();
            if (owner == null || owner.compareTo(aslSession.getUsername()) != 0) {
                throw new TDGWTServiceException("You are not the owner of this tabular resource (owner: " + owner + ")");
            }
            service.removeTabularResource(tabResourceId);
            SessionUtil.removeTaskInBackgroundOnTRId(session, trId);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error deleting the tabular resource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error deleting the tabular resource: " + e.getLocalizedMessage());
        }
    }

    @Override
    public TabResource createTabularResource(TabResource tabResource) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (tabResource == null) {
                logger.error("Error creating new TabularResource: tabResource is null");
                throw new TDGWTServiceException("Error creating new TabularResource no parameters set");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource serviceTR = service.createTabularResource();
            Table table = service.getLastTable(serviceTR.getId());
            this.syncTRMetaData(serviceTR, tabResource);
            TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()), TabularResourceTypeMap.map(serviceTR.getTabularResourceType()), serviceTR.getTableType(), String.valueOf(table.getId().getValue()), table.getTableType().getName());
            tabResource.setTrId(trId);
            return tabResource;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error creating new TabularResource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error creating new TabularResource: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<Codelist> getCodelists() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            return SessionUtil.retrieveCodelists(session);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving codelists: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<Dataset> getDatasets() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            return SessionUtil.retrieveDatasets(session);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving datasets: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<Agencies> getAgencies() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            return SessionUtil.retrieveAgencies(session);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving datasets: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startSDMXImport(SDMXImportSession sdmxImportSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setSDMXImportSession(session, sdmxImportSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource serviceTR = service.createTabularResource();
            TabResource sdmxImportTabResource = sdmxImportSession.getTabResource();
            this.syncTRMetaData(serviceTR, sdmxImportTabResource);
            TRId trId = new TRId(String.valueOf(serviceTR.getId().getValue()));
            sdmxImportTabResource.setTrId(trId);
            logger.debug(sdmxImportTabResource.toString());
            SessionUtil.setSDMXImportTabResource(session, sdmxImportTabResource);
            OpExecution4SDMXCodelistImport opEx = new OpExecution4SDMXCodelistImport(service, sdmxImportSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error SDMX Codelist Import: Operation not supported!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, serviceTR.getId());
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.SDMXImport, trId);
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in SDMX Import: " + e.getLocalizedMessage());
        }
    }

    private TRId retrieveTabularResourceBasicData(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(new Long(trId.getId()).longValue());
            TabularResource tr = service.getTabularResource(tabularResourceId);
            Table table = service.getLastTable(tabularResourceId);
            Table viewTable = null;
            if (table.contains(DatasetViewTableMetadata.class)) {
                DatasetViewTableMetadata dwm = (DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class);
                try {
                    viewTable = service.getTable(dwm.getTargetDatasetViewTableId());
                }
                catch (Exception e) {
                    logger.error("view table not found");
                }
            }
            TRId newTRId = viewTable == null ? new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(table.getId().getValue()), table.getTableType().getName()) : new TRId(String.valueOf(tr.getId().getValue()), TabularResourceTypeMap.map(tr.getTabularResourceType()), tr.getTableType(), String.valueOf(viewTable.getId().getValue()), viewTable.getTableType().getName(), String.valueOf(table.getId().getValue()), true);
            logger.debug("Retrieved TRId basic info:" + newTRId.toString());
            return newTRId;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error on Service: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setSDMXRegistrySource(SDMXRegistrySource sdmxRegistrySource) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setSDMXRegistrySource(session, sdmxRegistrySource);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error setting SDMXRegistrySource parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting SDMXRegistrySource parameter: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setCSVSession(CSVImportSession importSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setCSVImportSession(session, importSession);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error setting SDMXImportSession parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting SDMXImportSession parameter: " + e.getLocalizedMessage());
        }
    }

    @Override
    public FileUploadMonitor getFileUploadMonitor() throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        if (session == null) {
            throw new TDGWTServiceException("Error retrieving the session: null");
        }
        FileUploadMonitor fileUploadMonitor = SessionUtil.getFileUploadMonitor(session);
        if (fileUploadMonitor == null) {
            throw new TDGWTServiceException("Error retrieving the fileUploadMonitor: null");
        }
        logger.debug("FileUploadMonitor: " + fileUploadMonitor);
        return fileUploadMonitor;
    }

    @Override
    public AvailableCharsetList getAvailableCharset() throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        if (session == null) {
            throw new TDGWTServiceException("Error retrieving the session: null");
        }
        logger.info("Session:" + session.getId());
        String defaultEncoding = Charset.defaultCharset().displayName();
        ArrayList<String> charsetList = new ArrayList<String>(Charset.availableCharsets().keySet());
        return new AvailableCharsetList(charsetList, defaultEncoding);
    }

    @Override
    public ArrayList<String> configureCSVParser(String encoding, HeaderPresence headerPresence, char delimiter, char comment) throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        if (session == null) {
            throw new TDGWTServiceException("Error retrieving the session: null");
        }
        logger.debug("Session:" + session.getId());
        logger.debug("configureCSVParser  encoding: " + encoding + " headerPresence: " + (Object)((Object)headerPresence) + " delimiter: " + delimiter + " comment: " + comment);
        CSVFileUploadSession fileUploadSession = SessionUtil.getCSVFileUploadSession(session);
        if (fileUploadSession == null) {
            throw new TDGWTServiceException("Error retrieving the fileUploadSession: null");
        }
        CSVParserConfiguration parserConfiguration = fileUploadSession.getParserConfiguration();
        if (parserConfiguration == null) {
            parserConfiguration = new CSVParserConfiguration(Charset.forName(encoding), delimiter, comment, headerPresence);
            fileUploadSession.setParserConfiguration(parserConfiguration);
        } else {
            parserConfiguration.update(encoding, delimiter, comment, headerPresence);
        }
        SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
        try {
            return CSVFileUtil.getHeader(fileUploadSession.getCsvFile(), fileUploadSession.getParserConfiguration());
        }
        catch (Throwable e) {
            logger.error("Error retrieving the CSV header", e);
            throw new TDGWTServiceException("Error calculating the CSV header: " + e.getLocalizedMessage());
        }
    }

    @Override
    public CheckCSVSession checkCSV(long errorsLimit) throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        if (session == null) {
            throw new TDGWTServiceException("Error retrieving the session: null");
        }
        logger.debug("Session:" + session.getId());
        CSVFileUploadSession fileUploadSession = SessionUtil.getCSVFileUploadSession(session);
        if (fileUploadSession == null) {
            throw new TDGWTServiceException("Error retrieving the fileUploadSession: null");
        }
        try {
            return CSVFileUtil.checkCSV(fileUploadSession.getCsvFile(), fileUploadSession.getParserConfiguration(), errorsLimit);
        }
        catch (Throwable e) {
            logger.error("Error checking the CSV file", e);
            throw new TDGWTServiceException("Error checking the CSV file: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startCSVImport(CSVImportSession csvImportSession) throws TDGWTServiceException {
        CSVFileUploadSession fileUploadSession = null;
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            if (session == null) {
                throw new TDGWTServiceException("Error retrieving the session: null");
            }
            logger.debug("Session:" + session.getId());
            ASLSession aslSession = SessionUtil.getAslSession(session);
            String user = aslSession.getUsername();
            logger.debug("Session User:" + user);
            logger.debug("StartCSVImport: " + csvImportSession.toString());
            fileUploadSession = SessionUtil.getCSVFileUploadSession(session);
            if (fileUploadSession == null) {
                throw new TDGWTServiceException("Error retrieving the fileUploadSession: null");
            }
            String fileUrlOnStorage = this.loadCSVFileOnStorage(user, fileUploadSession, csvImportSession);
            fileUploadSession.getCsvFile().delete();
            String taskId = this.importCSVFileOnService(session, aslSession, user, fileUrlOnStorage, fileUploadSession, csvImportSession);
            return taskId;
        }
        catch (TDGWTServiceException e) {
            try {
                if (fileUploadSession != null && fileUploadSession.getCsvFile() != null && fileUploadSession.getCsvFile().exists()) {
                    fileUploadSession.getCsvFile().delete();
                }
            }
            catch (Throwable e1) {
                logger.error(e1.getLocalizedMessage());
            }
            throw e;
        }
        catch (SecurityException e) {
            try {
                if (fileUploadSession != null && fileUploadSession.getCsvFile() != null && fileUploadSession.getCsvFile().exists()) {
                    fileUploadSession.getCsvFile().delete();
                }
            }
            catch (Throwable e1) {
                logger.error(e1.getLocalizedMessage());
            }
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            try {
                if (fileUploadSession != null && fileUploadSession.getCsvFile() != null && fileUploadSession.getCsvFile().exists()) {
                    fileUploadSession.getCsvFile().delete();
                }
            }
            catch (Throwable e1) {
                logger.error(e1.getLocalizedMessage());
            }
            e.printStackTrace();
            throw new TDGWTServiceException("Error in CSVImport: " + e.getLocalizedMessage());
        }
    }

    private Map<String, Object> csvImportFileParameter(String fileUrlOnStorage, CSVFileUploadSession fileUploadSession, CSVImportSession csvImportSession) {
        HashMap<String, Object> parameterInstances = new HashMap<String, Object>();
        parameterInstances.put("url", fileUrlOnStorage);
        parameterInstances.put("separator", String.valueOf(fileUploadSession.getParserConfiguration().getDelimiter()));
        parameterInstances.put("encoding", fileUploadSession.getParserConfiguration().getCharset().name());
        boolean hasHeader = true;
        if (fileUploadSession.getParserConfiguration().getHeaderPresence() == HeaderPresence.NONE) {
            hasHeader = false;
        }
        parameterInstances.put("hasHeader", hasHeader);
        parameterInstances.put("fieldMask", csvImportSession.getColumnToImportMask());
        parameterInstances.put("skipError", csvImportSession.isSkipInvalidLines());
        return parameterInstances;
    }

    private String loadCSVFileOnStorage(String user, CSVFileUploadSession fileUploadSession, CSVImportSession csvImportSession) throws TDGWTServiceException {
        String fileUrlOnStorage = null;
        logger.debug("File Storage Access");
        logger.debug("CSVImportSession skip:" + csvImportSession.isSkipInvalidLines());
        FilesStorage filesStorage = new FilesStorage();
        fileUrlOnStorage = filesStorage.storageCSVTempFile(user, fileUploadSession.getCsvFile());
        logger.debug("File Url On Storage:" + fileUrlOnStorage);
        if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
            throw new TDGWTServiceException("Tabular Data Service error loading file on storage");
        }
        return fileUrlOnStorage;
    }

    private String importCSVFileOnService(HttpSession session, ASLSession aslSession, String user, String fileUrlOnStorage, CSVFileUploadSession fileUploadSession, CSVImportSession csvImportSession) throws TDGWTServiceException {
        Task trTask;
        Map<String, Object> parameterInstance = this.csvImportFileParameter(fileUrlOnStorage, fileUploadSession, csvImportSession);
        logger.debug("Tabular Data Service");
        AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
        TabularDataService service = TabularDataServiceFactory.getService();
        OperationDefinition importCSVFileOperation = OperationDefinitionMap.map(OperationsId.CSVImport.toString(), service);
        OperationExecution invocation = new OperationExecution(importCSVFileOperation.getOperationId(), parameterInstance);
        logger.debug("OperationInvocation: \n" + invocation.toString());
        TabularResource tabularResource = service.createTabularResource();
        TabResource csvImportTabResource = csvImportSession.getTabResource();
        this.syncTRMetaData(tabularResource, csvImportTabResource);
        TRId trId = new TRId(String.valueOf(tabularResource.getId().getValue()));
        csvImportTabResource.setTrId(trId);
        logger.debug(csvImportTabResource.toString());
        SessionUtil.setCSVImportTabResource(session, csvImportTabResource);
        try {
            trTask = service.execute(invocation, tabularResource.getId());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Tabular Data Service error creating TabularResource: " + e.getLocalizedMessage());
        }
        logger.debug("Start Task on service: TaskId " + trTask.getId());
        TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.CSVImport, trId);
        SessionUtil.setStartedTask(session, taskWrapper);
        return trTask.getId().getValue();
    }

    @Override
    public void getFileFromWorkspace(CSVImportSession csvImportSession) throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession aslSession = SessionUtil.getAslSession(session);
        Workspace w = null;
        WorkspaceItem wi = null;
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            Home home = manager.getHome(aslSession.getUsername());
            w = home.getWorkspace();
            wi = w.getItem(csvImportSession.getItemId());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in importCSV getFileFromWorkspace accessing the workspace: " + e.getLocalizedMessage(), e);
        }
        if (wi == null) {
            logger.error("Error retrieving the item on workspace" + csvImportSession.getItemId());
            throw new TDGWTServiceException("Error retrieving the item on workspace" + csvImportSession.getItemId());
        }
        try {
            logger.debug("WorkspaceItem [id:" + wi.getId() + " name:" + wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
        }
        catch (InternalErrorException e1) {
            e1.printStackTrace();
            throw new TDGWTServiceException("Error retrieving the item on workspace" + wi);
        }
        CSVFileUploadSession fileUploadSession = new CSVFileUploadSession();
        FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();
        SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);
        fileUploadSession.setId(session.getId());
        fileUploadSession.setFileUploadState(FileUploadState.STARTED);
        SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
        try {
            FilesStorage filesStorage = new FilesStorage();
            InputStream is = filesStorage.retriveImputStream(aslSession.getUsername(), wi);
            FileUtil.setImportFileCSV(fileUploadSession, is, wi.getName(), "text/csv");
        }
        catch (Throwable e) {
            FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
            fum.setFailed("An error occured elaborating the file", FileUtil.exceptionDetailMessage(e));
            SessionUtil.setFileUploadMonitor(session, fum);
            fileUploadSession.setFileUploadState(FileUploadState.FAILED);
            SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
            logger.error("Error elaborating the input stream", e);
            throw new TDGWTServiceException("Error in importCSV getFileFromWorkspace: " + e.getLocalizedMessage(), e);
        }
        logger.trace("changing state");
        FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
        fum.setState(FileUploadState.COMPLETED);
        SessionUtil.setFileUploadMonitor(session, fum);
        SessionUtil.setCSVFileUploadSession(session, fileUploadSession);
    }

    @Override
    public String getTRCreationDate(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTRMetadata on " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            return sdf.format(tr.getCreationDate().getTime());
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error in getTRCreationDate(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTRCreationDate(): " + e.getLocalizedMessage());
        }
    }

    @Override
    public Boolean isTabularResourceValid(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("IsTabularResourceValid: " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            logger.debug("IsTabularResourceValid: " + tr.isValid());
            return tr.isValid();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error checking if it is a valid tabular resource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error checking if it is a valid tabular resource: " + e.getLocalizedMessage());
        }
    }

    public Boolean isTabularResourceFinalized(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("IsTabularResourceFinalized: " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            logger.debug("IsTabularResourceFinalized: " + tr.isFinalized());
            return tr.isFinalized();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error checking if it is a finalized tabular resource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error checking if it is a finalized tabular resource: " + e.getLocalizedMessage());
        }
    }

    public Boolean isTabularResourceLocked(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("IsTabularResourceLocked: " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            logger.debug("IsTabularResourceLocked: " + tr.isLocked());
            return tr.isLocked();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error checking if it is a locked tabular resource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error checking if it is a locked tabular resource: " + e.getLocalizedMessage());
        }
    }

    private ArrayList<TRMetadata> getTRMetadata(TabularResource tr) throws TDGWTServiceException {
        try {
            Collection trMetas = tr.getAllMetadata();
            logger.debug("GetTRMetadata size: " + trMetas.size());
            ArrayList<TRMetadata> listTRMetadata = new ArrayList<TRMetadata>();
            for (TabularResourceMetadata trMetadata : trMetas) {
                Calendar cal;
                if (trMetadata instanceof DescriptionMetadata) {
                    TRDescriptionMetadata trDescriptionMetadata = new TRDescriptionMetadata();
                    trDescriptionMetadata.setValue(((DescriptionMetadata)trMetadata).getValue());
                    listTRMetadata.add(trDescriptionMetadata);
                    continue;
                }
                if (trMetadata instanceof NameMetadata) {
                    TRNameMetadata trNameMetadata = new TRNameMetadata();
                    trNameMetadata.setValue(((NameMetadata)trMetadata).getValue());
                    listTRMetadata.add(trNameMetadata);
                    continue;
                }
                if (trMetadata instanceof AgencyMetadata) {
                    TRAgencyMetadata trAgencyMetadata = new TRAgencyMetadata();
                    trAgencyMetadata.setValue(((AgencyMetadata)trMetadata).getValue());
                    listTRMetadata.add(trAgencyMetadata);
                    continue;
                }
                if (trMetadata instanceof RightsMetadata) {
                    TRRightsMetadata trRightsMetadata = new TRRightsMetadata();
                    trRightsMetadata.setValue(((RightsMetadata)trMetadata).getValue());
                    listTRMetadata.add(trRightsMetadata);
                    continue;
                }
                if (trMetadata instanceof ValidSinceMetadata) {
                    TRValidSinceMetadata validSinceMetadata = new TRValidSinceMetadata();
                    cal = ((ValidSinceMetadata)trMetadata).getValue();
                    validSinceMetadata.setValue(sdfDate.format(cal.getTime()));
                    listTRMetadata.add(validSinceMetadata);
                    continue;
                }
                if (trMetadata instanceof ValidUntilMetadata) {
                    TRValidUntilMetadata validUntilMetadata = new TRValidUntilMetadata();
                    cal = ((ValidUntilMetadata)trMetadata).getValue();
                    validUntilMetadata.setValue(sdfDate.format(cal.getTime()));
                    listTRMetadata.add(validUntilMetadata);
                    continue;
                }
                if (!(trMetadata instanceof LicenceMetadata)) continue;
                TRLicenceMetadata licenceMetadata = new TRLicenceMetadata();
                licenceMetadata.setValue(((LicenceMetadata)trMetadata).getValue().toString());
                listTRMetadata.add(licenceMetadata);
            }
            logger.debug("GetTRMetadata retrived: " + listTRMetadata.size());
            logger.debug("GetTRMetadata: [" + listTRMetadata + "]");
            return listTRMetadata;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getTRMetadata(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTRMetadata(): " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<TRMetadata> getTRMetadata(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTRMetadata on " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResource tr = service.getTabularResource(new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            Collection trMetas = tr.getAllMetadata();
            logger.debug("GetTRMetadata size: " + trMetas.size());
            ArrayList<TRMetadata> listTRMetadata = new ArrayList<TRMetadata>();
            for (TabularResourceMetadata trMetadata : trMetas) {
                Calendar cal;
                if (trMetadata instanceof DescriptionMetadata) {
                    TRDescriptionMetadata trDescriptionMetadata = new TRDescriptionMetadata();
                    trDescriptionMetadata.setValue(((DescriptionMetadata)trMetadata).getValue());
                    listTRMetadata.add(trDescriptionMetadata);
                    continue;
                }
                if (trMetadata instanceof NameMetadata) {
                    TRNameMetadata trNameMetadata = new TRNameMetadata();
                    trNameMetadata.setValue(((NameMetadata)trMetadata).getValue());
                    listTRMetadata.add(trNameMetadata);
                    continue;
                }
                if (trMetadata instanceof AgencyMetadata) {
                    TRAgencyMetadata trAgencyMetadata = new TRAgencyMetadata();
                    trAgencyMetadata.setValue(((AgencyMetadata)trMetadata).getValue());
                    listTRMetadata.add(trAgencyMetadata);
                    continue;
                }
                if (trMetadata instanceof RightsMetadata) {
                    TRRightsMetadata trRightsMetadata = new TRRightsMetadata();
                    trRightsMetadata.setValue(((RightsMetadata)trMetadata).getValue());
                    listTRMetadata.add(trRightsMetadata);
                    continue;
                }
                if (trMetadata instanceof ValidSinceMetadata) {
                    TRValidSinceMetadata validSinceMetadata = new TRValidSinceMetadata();
                    cal = ((ValidSinceMetadata)trMetadata).getValue();
                    validSinceMetadata.setValue(sdfDate.format(cal.getTime()));
                    listTRMetadata.add(validSinceMetadata);
                    continue;
                }
                if (trMetadata instanceof ValidUntilMetadata) {
                    TRValidUntilMetadata validUntilMetadata = new TRValidUntilMetadata();
                    cal = ((ValidUntilMetadata)trMetadata).getValue();
                    validUntilMetadata.setValue(sdfDate.format(cal.getTime()));
                    listTRMetadata.add(validUntilMetadata);
                    continue;
                }
                if (!(trMetadata instanceof LicenceMetadata)) continue;
                TRLicenceMetadata licenceMetadata = new TRLicenceMetadata();
                licenceMetadata.setValue(((LicenceMetadata)trMetadata).getValue().toString());
                listTRMetadata.add(licenceMetadata);
            }
            logger.debug("GetTRMetadata retrived: " + listTRMetadata.size());
            logger.debug("GetTRMetadata: [" + listTRMetadata + "]");
            return listTRMetadata;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getTRMetadata(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTRMetadata(): " + e.getLocalizedMessage());
        }
    }

    @Override
    public TabValidationsMetadata getTableValidationsMetadata(TRId trId) throws TDGWTServiceException {
        try {
            List vals;
            ValidationsMetadata validationsMetadata;
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTableValidationsMetadata on " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            TabValidationsMetadata tabValidationsMetadata = new TabValidationsMetadata();
            if (table.contains(ValidationsMetadata.class) && (validationsMetadata = (ValidationsMetadata)table.getMetadata(ValidationsMetadata.class)) != null && (vals = validationsMetadata.getValidations()) != null && vals.size() > 0) {
                Validations valid = null;
                ArrayList<Validations> vList = new ArrayList<Validations>();
                int i = 0;
                for (Validation v : vals) {
                    valid = new Validations(String.valueOf(i), "", v.getDescription(), v.isValid(), null, null);
                    vList.add(valid);
                    ++i;
                }
                tabValidationsMetadata.setValidations(vList);
            }
            logger.debug("TabValidationsMetadata: " + tabValidationsMetadata);
            return tabValidationsMetadata;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getTableValidationMetadata(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTableValidationMetadata: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<TabMetadata> getTableMetadata(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTableMetadata on " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            Collection cMeta = table.getAllMetadata();
            ArrayList<TabMetadata> listTabMetadata = new ArrayList<TabMetadata>();
            logger.debug("Metadata size:" + cMeta.size());
            for (TableMetadata tMetadata : cMeta) {
                TRLocalizedText trLocalizedText;
                int i;
                List lLocalizedText;
                ArrayList<TRLocalizedText> listTRLocalizedText;
                if (tMetadata instanceof DescriptionsMetadata) {
                    TabDescriptionsMetadata trDescriptionsMetadata = new TabDescriptionsMetadata();
                    listTRLocalizedText = new ArrayList<TRLocalizedText>();
                    lLocalizedText = ((DescriptionsMetadata)tMetadata).getTexts();
                    i = 0;
                    for (LocalizedText lt : lLocalizedText) {
                        trLocalizedText = new TRLocalizedText();
                        trLocalizedText.setId(i);
                        trLocalizedText.setValue(lt.getValue());
                        trLocalizedText.setLocaleCode(lt.getLocale());
                        listTRLocalizedText.add(trLocalizedText);
                        ++i;
                    }
                    trDescriptionsMetadata.setListTRLocalizedText(listTRLocalizedText);
                    listTabMetadata.add(trDescriptionsMetadata);
                    continue;
                }
                if (tMetadata instanceof NamesMetadata) {
                    TabNamesMetadata trNamesMetadata = new TabNamesMetadata();
                    listTRLocalizedText = new ArrayList();
                    lLocalizedText = ((NamesMetadata)tMetadata).getTexts();
                    i = 0;
                    for (LocalizedText lt : lLocalizedText) {
                        trLocalizedText = new TRLocalizedText();
                        trLocalizedText.setId(i);
                        trLocalizedText.setValue(lt.getValue());
                        trLocalizedText.setLocaleCode(lt.getLocale());
                        listTRLocalizedText.add(trLocalizedText);
                        ++i;
                    }
                    trNamesMetadata.setListTRLocalizedText(listTRLocalizedText);
                    listTabMetadata.add(trNamesMetadata);
                    continue;
                }
                if (tMetadata instanceof VersionMetadata) {
                    TabVersionMetadata trVersionMetadata = new TabVersionMetadata();
                    trVersionMetadata.setVersion(((VersionMetadata)tMetadata).getVersion());
                    listTabMetadata.add(trVersionMetadata);
                    continue;
                }
                if (tMetadata instanceof ExportMetadata) {
                    TabExportMetadata trExportMetadata = new TabExportMetadata();
                    trExportMetadata.setDestinationType(((ExportMetadata)tMetadata).getDestinationType());
                    trExportMetadata.setExportDate(sdf.format(((ExportMetadata)tMetadata).getExportDate()));
                    trExportMetadata.setUrl(((ExportMetadata)tMetadata).getUri());
                    listTabMetadata.add(trExportMetadata);
                    continue;
                }
                if (tMetadata instanceof ImportMetadata) {
                    TabImportMetadata trImportMetadata = new TabImportMetadata();
                    trImportMetadata.setSourceType(((ImportMetadata)tMetadata).getSourceType());
                    trImportMetadata.setImportDate(sdf.format(((ImportMetadata)tMetadata).getImportDate()));
                    trImportMetadata.setUrl(((ImportMetadata)tMetadata).getUri());
                    listTabMetadata.add(trImportMetadata);
                    continue;
                }
                if (!(tMetadata instanceof GenericMapMetadata)) continue;
                TabGenericMapMetadata trGenericMapMetadata = new TabGenericMapMetadata();
                trGenericMapMetadata.setMetadataMap((HashMap)((GenericMapMetadata)tMetadata).getMetadataMap());
                listTabMetadata.add(trGenericMapMetadata);
            }
            return listTabMetadata;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error in getTableMetadata(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in getTableMetadata(): " + e.getLocalizedMessage());
        }
    }

    private Map<String, Object> sdmxExportParameter(SDMXExportSession exportSession) throws TDGWTServiceException {
        boolean internalRegistry = false;
        String destination = null;
        if (exportSession != null) {
            if (exportSession.getRegistryBaseUrl() != null && !exportSession.getRegistryBaseUrl().isEmpty()) {
                destination = exportSession.getRegistryBaseUrl();
            } else {
                internalRegistry = true;
            }
        } else {
            internalRegistry = true;
        }
        if (internalRegistry) {
            ServiceEndpoint serviceEnd;
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'SDMX'").addCondition("$resource/Profile/Name/text() eq 'SDMXRegistry'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List listService = client.submit((Query)query);
            if (listService.size() > 0 && (serviceEnd = (ServiceEndpoint)listService.get(0)) != null) {
                ServiceEndpoint.Profile prof = serviceEnd.profile();
                Group groupA = prof.accessPoints();
                for (ServiceEndpoint.AccessPoint acc : groupA) {
                    if (acc.description().compareTo("REST Interface v2.1") != 0) continue;
                    destination = acc.address();
                    break;
                }
            }
        }
        if (destination == null) {
            logger.debug("Destination: " + destination);
            throw new TDGWTServiceException("SDMX Service not discovered");
        }
        HashMap<String, Object> parameterInstances = new HashMap<String, Object>();
        parameterInstances.put("registryBaseUrl", destination);
        parameterInstances.put("agency", "SDMX");
        parameterInstances.put("id", "NEW_CL_DIVISION");
        parameterInstances.put("version", "2.0");
        return parameterInstances;
    }

    private void checkTRId(TRId trId) throws TDGWTServiceException {
        if (trId == null) {
            logger.error("TRId is null");
            new TDGWTServiceException(NO_VALID_TABULAR_RESOURCE_ID_PRESENT);
        }
        if (trId.getId() == null || trId.getId().isEmpty()) {
            logger.error("TRId not valid: " + trId);
            new TDGWTServiceException(NO_VALID_TABULAR_RESOURCE_ID_PRESENT);
        }
    }

    private void checkTabularResourceLocked(TabularResource tabularResource) throws TDGWTServiceException {
        try {
            if (tabularResource.isLocked()) {
                logger.error(TABULAR_RESOURCE_IS_LOCKED);
                throw new TDGWTIsLockedException(TABULAR_RESOURCE_IS_LOCKED);
            }
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException(e.getLocalizedMessage());
        }
    }

    private void checkTabularResourceIsFinal(TabularResource tabularResource) throws TDGWTServiceException {
        try {
            if (tabularResource.isFinalized()) {
                logger.error(TABULAR_RESOURCE_IS_FINAL);
                throw new TDGWTIsFinalException(TABULAR_RESOURCE_IS_FINAL);
            }
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException(e.getLocalizedMessage());
        }
    }

    private void checkTabularResourceIsFlow(TabularResource tabularResource) throws TDGWTServiceException {
        try {
            if (tabularResource.getTabularResourceType().compareTo((Enum)TabularResourceType.FLOW) == 0) {
                logger.error("Operation not allowed on a tabular resource of type flow");
                throw new TDGWTIsFlowException("Operation not allowed on a tabular resource of type flow");
            }
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException(e.getLocalizedMessage());
        }
    }

    @Override
    public String startSDMXExport(SDMXExportSession exportSession) throws TDGWTServiceException {
        try {
            logger.debug("Start SDMX Export");
            HttpSession session = this.getThreadLocalRequest().getSession();
            if (session == null) {
                throw new TDGWTServiceException("Error retrieving the session: null");
            }
            logger.debug("Session:" + session.getId());
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("Session User:" + aslSession.getUsername());
            TRId trId = SessionUtil.getTRId(session);
            if (trId == null) {
                throw new TDGWTServiceException("Error no tabular resource in session");
            }
            if (trId.getTableId() == null) {
                throw new TDGWTServiceException("Error no table present in session");
            }
            SessionUtil.setSDMXExportSession(session, exportSession);
            Map<String, Object> parameterInstance = this.sdmxExportParameter(exportSession);
            logger.debug("Tabular Data Service");
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OperationDefinition exportSDMXOperation = OperationDefinitionMap.map(OperationsId.SDMXCodelistExport.toString(), service);
            OperationExecution invocation = new OperationExecution(exportSDMXOperation.getOperationId(), parameterInstance);
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, new TabularResourceId(Long.valueOf(trId.getId()).longValue()));
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.SDMXExport, trId);
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in CSVExport: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startCSVExport(CSVExportSession exportSession) throws TDGWTServiceException {
        try {
            logger.debug("Start CSV Export");
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TRId trId = SessionUtil.getTRId(session);
            if (trId == null) {
                throw new TDGWTServiceException("Error no tabular resource in session");
            }
            if (trId.getTableId() == null) {
                throw new TDGWTServiceException("Error no table present in session");
            }
            SessionUtil.setCSVExportSession(session, exportSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4CSVExport opEx = new OpExecution4CSVExport(session, service, exportSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in CSVExport: Operation not supported for now!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.CSVExport, trId);
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in CSV Export: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startJSONExport(JSONExportSession exportSession) throws TDGWTServiceException {
        try {
            logger.debug("Start JSON Export");
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TRId trId = SessionUtil.getTRId(session);
            if (trId == null) {
                throw new TDGWTServiceException("Error no tabular resource in session");
            }
            if (trId.getTableId() == null) {
                throw new TDGWTServiceException("Error no table present in session");
            }
            SessionUtil.setJSONExportSession(session, exportSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4JSONExport opEx = new OpExecution4JSONExport(session, service, exportSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in JSONExport: Operation not supported for now!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.JSONExport, trId);
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in JSON Export: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startChangeColumnType(ChangeColumnTypeSession changeColumnTypeSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            SessionUtil.setChangeColumnTypeSession(session, changeColumnTypeSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(changeColumnTypeSession.getColumnData().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(changeColumnTypeSession.getColumnData().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ChangeColumnType opEx = new OpExecution4ChangeColumnType(service, changeColumnTypeSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in ChangeColumnType: Operation not supported for now!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ChangeColumnType, changeColumnTypeSession.getColumnData().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in ChangeColumnType: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startAddColumn(AddColumnSession addColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setAddColumnSession(session, addColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(addColumnSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(addColumnSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4AddColumn opEx = new OpExecution4AddColumn(service, addColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Add Column: Operation not supported for now!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.AddColumn, addColumnSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in AddColumn: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startDeleteColumn(DeleteColumnSession deleteColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setDeleteColumnSession(session, deleteColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(deleteColumnSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(deleteColumnSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4DeleteColumn opEx = new OpExecution4DeleteColumn(service, deleteColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocation = director.getListOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Delete Column: Operation not supported for now!");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.executeBatch(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.DeleteColumn, deleteColumnSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in DeleteColumn: " + e.getLocalizedMessage());
        }
    }

    public String startFilterColumn(FilterColumnSession filterColumnSession, Expression expression, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setFilterColumnSession(session, filterColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (filterColumnSession == null) {
                logger.error("FilterColumnSession is null");
                throw new TDGWTServiceException("Error in filter column: FilterColumnSession is null");
            }
            logger.debug("StartFilterColumn: " + filterColumnSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(filterColumnSession.getColumn().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(filterColumnSession.getColumn().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4FilterColumn opEx = new OpExecution4FilterColumn(service, filterColumnSession, expression);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Filter Column on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.FilterColumn, filterColumnSession.getColumn().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in filter column: " + e.getLocalizedMessage());
        }
    }

    public String startReplaceColumnByExpression(ReplaceColumnByExpressionSession replaceColumnByExpressionSession, Expression conditionExpression, Expression replaceExpression, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setReplaceColumnByExpressionSession(session, replaceColumnByExpressionSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (replaceColumnByExpressionSession == null) {
                logger.error("ReplaceColumnByExpressionSession is null");
                throw new TDGWTServiceException("Error in replace column by expression: ReplaceColumnByExpressionSession is null");
            }
            logger.debug("StartReplaceColumnByExpression: " + replaceColumnByExpressionSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(replaceColumnByExpressionSession.getColumn().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(replaceColumnByExpressionSession.getColumn().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ReplaceColumnByExpression opEx = new OpExecution4ReplaceColumnByExpression(service, replaceColumnByExpressionSession, conditionExpression, replaceExpression);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            logger.debug("Start Replace on Service:" + sdfPerformance.format(new Date()));
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Replace returned task:" + sdfPerformance.format(new Date()));
            logger.debug("Replace Column by Expression on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ReplaceByExpression, replaceColumnByExpressionSession.getColumn().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in replace column by expression: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startLabelColumn(LabelColumnSession labelColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setLabelColumnSession(session, labelColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug(labelColumnSession.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(labelColumnSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(labelColumnSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4LabelColumn opEx = new OpExecution4LabelColumn(service, labelColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            logger.debug("OperationInvocation: \n" + invocation);
            service.executeSynchMetadataOperation(invocation, tabularResourceId);
            return "ok";
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error Changing The Column Label: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startChangeTableType(ChangeTableTypeSession changeTableTypeSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setChangeTableTypeSession(session, changeTableTypeSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(changeTableTypeSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(changeTableTypeSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ChangeTableType opEx = new OpExecution4ChangeTableType(service, changeTableTypeSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Change Table Type invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ChangeTableType, changeTableTypeSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error Changing Table Type: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ColumnData> getColumnsForDimension(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            logger.debug("getColumnsForDimension():" + trId.toString());
            Table table = service.getTable(new TableId(Long.valueOf(trId.getTableId()).longValue()));
            ArrayList<ColumnData> columns = new ArrayList<ColumnData>();
            List cols = table.getColumns();
            int i = 0;
            for (Column c : cols) {
                ColumnType ctype = c.getColumnType();
                if (c.getColumnType() instanceof IdColumnType || c.getColumnType() instanceof ValidationColumnType || c.getColumnType() instanceof DimensionColumnType || c.getColumnType() instanceof TimeDimensionColumnType || c.contains(ViewColumnMetadata.class) || !(ctype instanceof CodeColumnType) && !(ctype instanceof CodeNameColumnType) && !(ctype instanceof CodeDescriptionColumnType) && !(ctype instanceof AnnotationColumnType)) continue;
                ColumnData cData = new ColumnData();
                cData.setId(Integer.toString(i));
                cData.setColumnId(c.getLocalId().getValue());
                cData.setName(c.getName());
                cData.setTypeCode(c.getColumnType().getCode());
                cData.setTypeName(c.getColumnType().getName());
                cData.setDataTypeName(c.getDataType().getName());
                NamesMetadata labelsMetadata = null;
                if (c.contains(NamesMetadata.class)) {
                    labelsMetadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                }
                if (labelsMetadata == null) {
                    cData.setLabel("nolabel");
                    logger.debug("LabelsMetadata no labels");
                } else {
                    LocalizedText cl = null;
                    cl = labelsMetadata.getTextWithLocale("en");
                    if (cl == null) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else if (cl.getValue() == null || cl.getValue().isEmpty()) {
                        cData.setLabel("nolabel");
                        logger.debug("ColumnLabel no label in en");
                    } else {
                        cData.setLabel(cl.getValue());
                        logger.debug("Column Set Label: " + cl.getValue());
                    }
                }
                DataLocaleMetadata dataLocaleMetadata = null;
                if (c.contains(DataLocaleMetadata.class)) {
                    dataLocaleMetadata = (DataLocaleMetadata)c.getMetadata(DataLocaleMetadata.class);
                    cData.setLocale(dataLocaleMetadata.getLocale());
                }
                cData.setTrId(trId);
                columns.add(cData);
                ++i;
            }
            return columns;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in getColumnsForDimension() retrieving Columns: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving Columns: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startDeleteRows(DeleteRowsSession deleteRowsSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setDeleteRowsSession(session, deleteRowsSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(deleteRowsSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(deleteRowsSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4DeleteRows opEx = new OpExecution4DeleteRows(service, deleteRowsSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Delete Rows invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.DeleteRow, deleteRowsSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error Deleting Rows: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startCloneTabularResource(CloneTabularResourceSession cloneTabularResourceSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            logger.debug("CloneTabularResourceSession: " + cloneTabularResourceSession);
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(cloneTabularResourceSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(cloneTabularResourceSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4Clone opEx = new OpExecution4Clone(service, cloneTabularResourceSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            TabularResource cloneTR = service.createTabularResource();
            cloneTR.setAllMetadata(tabularResource.getAllMetadata());
            NameMetadata nameMetadata = (NameMetadata)cloneTR.getMetadata(NameMetadata.class);
            if (nameMetadata != null) {
                String name = nameMetadata.getValue();
                name = name != null ? String.valueOf(name) + "_cloned" : "cloned";
                nameMetadata.setValue(name);
            } else {
                String name = "cloned";
                nameMetadata = new NameMetadata("cloned");
            }
            cloneTR.setMetadata((Metadata)nameMetadata);
            TRId trIdClone = new TRId(String.valueOf(cloneTR.getId().getValue()));
            cloneTabularResourceSession.setTrIdClone(trIdClone);
            SessionUtil.setCloneTabularResourceSession(session, cloneTabularResourceSession);
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, cloneTR.getId());
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.Clone, trIdClone);
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error Cloning: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startDuplicates(DuplicatesSession duplicatesSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setDuplicatesSession(session, duplicatesSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(duplicatesSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(duplicatesSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4Duplicates opEx = new OpExecution4Duplicates(service, duplicatesSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Delete Rows invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.DuplicateTuples, duplicatesSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in operation for duplicates: " + e.getLocalizedMessage());
        }
    }

    private ArrayList<Contacts> retrieveShareInfo(TabularResource tr) throws TDGWTServiceException {
        try {
            ArrayList<Contacts> contacts = new ArrayList<Contacts>();
            List sharedWithUsers = tr.getSharedWithUsers();
            logger.debug("Shared with Users: " + sharedWithUsers);
            if (sharedWithUsers != null) {
                for (String user : sharedWithUsers) {
                    Contacts cont = new Contacts(user, user, false);
                    contacts.add(cont);
                }
            }
            List sharedWithGroups = tr.getSharedWithGroups();
            logger.debug("Shared with Groups: " + sharedWithUsers);
            if (sharedWithGroups != null) {
                for (String group : sharedWithGroups) {
                    Contacts cont = new Contacts(group, group, true);
                    contacts.add(cont);
                }
            }
            return contacts;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in retrieveShareInfo: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setShare(ShareTabResource shareInfo) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("ShareInfo: " + shareInfo);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(shareInfo.getTabResource().getTrId().getId()).longValue());
            ArrayList<AuthorizationToken> users = new ArrayList<AuthorizationToken>();
            for (Contacts cont : shareInfo.getContacts()) {
                AuthorizationToken at = cont.isGroup() ? new AuthorizationToken(null, cont.getLogin()) : new AuthorizationToken(cont.getLogin());
                users.add(at);
            }
            AuthorizationToken[] usersArray = users.toArray(new AuthorizationToken[0]);
            logger.debug("Share with Users: " + users);
            service.share(tabularResourceId, usersArray);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error on service");
        }
    }

    @Override
    public void setShareTemplate(ShareTemplate shareTemplate) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("ShareTemplate: " + shareTemplate);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TemplateId templateId = new TemplateId(Long.valueOf(shareTemplate.getTemplateData().getId()).longValue());
            ArrayList<AuthorizationToken> users = new ArrayList<AuthorizationToken>();
            for (Contacts cont : shareTemplate.getContacts()) {
                AuthorizationToken at = cont.isGroup() ? new AuthorizationToken(null, cont.getLogin()) : new AuthorizationToken(cont.getLogin());
                users.add(at);
            }
            AuthorizationToken[] usersArray = users.toArray(new AuthorizationToken[0]);
            logger.debug("Share with Users: " + users);
            service.share(templateId, usersArray);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error on service");
        }
    }

    public boolean checkTabularResourceNotFinal(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("checkTabularResourceNotFinal: " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(new Long(trId.getId()).longValue());
            TabularResource tr = service.getTabularResource(tabularResourceId);
            return tr.isFinalized();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error in checkTabularResourceNotFinal: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in checkTabularResourceNotFinal: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setTabResourceInformation(TabResource tabResource) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("SetTabResourceInformation: " + tabResource);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(tabResource.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(tabResource.getTrId().getId()).longValue());
            TabularResource tr = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tr);
            this.checkTabularResourceIsFinal(tr);
            logger.debug("setTabResourceInformation - old information:" + tr);
            ArrayList<Object> meta = new ArrayList<Object>();
            if (tabResource.getName() != null) {
                NameMetadata name = new NameMetadata(tabResource.getName());
                meta.add(name);
            }
            if (tabResource.getDescription() != null) {
                DescriptionMetadata description = new DescriptionMetadata(tabResource.getDescription());
                meta.add(description);
            }
            if (tabResource.getAgency() != null) {
                AgencyMetadata agency = new AgencyMetadata(tabResource.getAgency());
                meta.add(agency);
            }
            if (tabResource.getRight() != null) {
                RightsMetadata rights = new RightsMetadata(tabResource.getRight());
                meta.add(rights);
            }
            if (tabResource.getValidFrom() != null && !tabResource.getValidFrom().isEmpty()) {
                try {
                    Date dateF = sdfDate.parse(tabResource.getValidFrom());
                    GregorianCalendar validFromC = new GregorianCalendar();
                    validFromC.setTime(dateF);
                    ValidSinceMetadata validSince = new ValidSinceMetadata();
                    validSince.setValue((Calendar)validFromC);
                    meta.add(validSince);
                }
                catch (ParseException e) {
                    logger.info("ValidFromMetadata is not set, no valid calendar present");
                }
            }
            if (tabResource.getValidUntilTo() != null && !tabResource.getValidUntilTo().isEmpty()) {
                try {
                    Date dateU = sdfDate.parse(tabResource.getValidUntilTo());
                    GregorianCalendar validUntilToC = new GregorianCalendar();
                    validUntilToC.setTime(dateU);
                    ValidUntilMetadata validUntil = new ValidUntilMetadata((Calendar)validUntilToC);
                    meta.add(validUntil);
                }
                catch (ParseException e) {
                    logger.info("ValidUntilMetadata is not set, no valid calendar present");
                }
            }
            if (tabResource.getLicence() != null && !tabResource.getLicence().isEmpty()) {
                LicenceMetadata licenceMetadata = new LicenceMetadata();
                Licence licence = LicenceMap.map(tabResource.getLicence());
                if (licence != null) {
                    licenceMetadata.setValue(licence);
                    meta.add(licenceMetadata);
                } else {
                    logger.error("Licence type not found: " + tabResource.getLicence());
                }
            }
            tr.setAllMetadata(meta);
            if (tabResource.isFinalized()) {
                if (tr.isValid()) {
                    if (!tr.isFinalized()) {
                        tr.finalize();
                    }
                } else {
                    throw new TDGWTServiceException("Only valid tabular resource can be finalized!");
                }
            }
            logger.debug("setTabResourceInformation - new information:" + tr);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error in setTabResourceInformation: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in setTabResourceInformation: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setTabResourceToFinal(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("SetTabResourceToFinal: " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tr = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tr);
            this.checkTabularResourceIsFinal(tr);
            logger.debug("setTabResourceToFinal: " + tr);
            if (tr.isValid()) {
                if (!tr.isFinalized()) {
                    tr.finalize();
                }
            } else {
                throw new TDGWTServiceException("Only valid tabular resource can be finalized!");
            }
            logger.debug("setTabResourceToFinal - new information:" + tr);
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error in setTabResourceToFinal: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in setTabResourceToFinal: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<Occurrences> getOccurrencesForBatchReplace(OccurrencesForReplaceBatchColumnSession occurrencesForReplaceBatchColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetOccurencesForBatchReplace: " + occurrencesForReplaceBatchColumnSession.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            ArrayList<Occurrences> occurences = QueryService.queryOccurences(service, occurrencesForReplaceBatchColumnSession, Direction.ASC);
            logger.debug("Retrieved Occurences");
            return occurences;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error in GetOccurencesForBatchReplace: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in GetOccurencesForBatchReplace: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<TemplateData> getTemplates() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTemplates");
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            List templateDescriptorList = service.getTemplates();
            ArrayList<TemplateData> templateDataList = new ArrayList<TemplateData>();
            for (TemplateDescription desc : templateDescriptorList) {
                TemplateData templateData = new TemplateData();
                templateData.setId(desc.getId());
                templateData.setName(desc.getName());
                templateData.setDescription(desc.getDescription());
                templateData.setAgency(desc.getAgency());
                switch (desc.getTemplate().getCategory()) {
                    case CODELIST: {
                        templateData.setCategory("Codelist");
                        break;
                    }
                    case DATASET: {
                        templateData.setCategory("Dataset");
                        break;
                    }
                    case GENERIC: {
                        templateData.setCategory("Generic");
                        break;
                    }
                }
                Contacts owner = new Contacts("", desc.getOwner(), false);
                templateData.setOwner(owner);
                templateData.setContacts(this.retrieveTemplateShareInfo(desc));
                templateDataList.add(templateData);
            }
            logger.debug("Retrieved TemplateData List");
            return templateDataList;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error in GetTemplates: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error in GetOccurencesForBatchReplace: " + e.getLocalizedMessage());
        }
    }

    private ArrayList<Contacts> retrieveTemplateShareInfo(TemplateDescription templateDescription) throws TDGWTServiceException {
        try {
            ArrayList<Contacts> contacts = new ArrayList<Contacts>();
            List sharedWithUsers = templateDescription.getSharedWithUsers();
            logger.debug("Shared with Users: " + sharedWithUsers);
            if (sharedWithUsers != null) {
                for (String user : sharedWithUsers) {
                    Contacts cont = new Contacts(user, user, false);
                    contacts.add(cont);
                }
            }
            List sharedWithGroups = templateDescription.getSharedWithGroups();
            logger.debug("Shared with Groups: " + sharedWithUsers);
            if (sharedWithGroups != null) {
                for (String group : sharedWithGroups) {
                    Contacts cont = new Contacts(group, group, true);
                    contacts.add(cont);
                }
            }
            return contacts;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in retrieveShareInfo: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startTemplateApply(TemplateApplySession templateApplySession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("startTemplateApply: " + templateApplySession);
            SessionUtil.setTemplateApplySession(session, templateApplySession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(templateApplySession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(templateApplySession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            TemplateId templateId = new TemplateId(templateApplySession.getTemplateData().getId());
            Task trTask = service.applyTemplate(templateId, tabularResourceId);
            logger.debug("startTemplateApply task start");
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ApplyTemplate, templateApplySession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error StartTemplateApply: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error StartTemplateApply: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void templateDelete(TemplateDeleteSession templateDeleteSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("startTemplateDelete: " + templateDeleteSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            for (TemplateData template : templateDeleteSession.getTemplates()) {
                TemplateId templateId = new TemplateId(template.getId());
                service.remove(templateId);
            }
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (NoSuchTemplateException e) {
            logger.debug("Error StartTemplateDelete: No such Template");
            e.printStackTrace();
            throw new TDGWTServiceException("Error StartTemplateDelete: No such Template");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("Error StartTemplateDelete: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error StartTemplateDelete: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startReplaceColumn(ReplaceColumnSession replaceColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setReplaceColumnSession(session, replaceColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(replaceColumnSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(replaceColumnSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ReplaceColumn opEx = new OpExecution4ReplaceColumn(service, replaceColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Replace Column Value invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ReplaceValue, replaceColumnSession.getColumnData().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in operation for replace column value: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startReplaceBatchColumn(ReplaceBatchColumnSession replaceBatchColumnSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setReplaceBatchColumnSession(session, replaceBatchColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(replaceBatchColumnSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(replaceBatchColumnSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ReplaceBatch opEx = new OpExecution4ReplaceBatch(service, replaceBatchColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocations = director.getListOperationExecution();
            if (invocations == null) {
                throw new TDGWTServiceException("Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + ((Object)invocations).toString());
            Task trTask = service.executeBatch(invocations, tabularResourceId);
            if (trTask == null) {
                logger.error("Error on service Task null");
                throw new TDGWTServiceException("Task not started");
            }
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ReplaceBatch, replaceBatchColumnSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in operation for batch replace on column: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<String> getLocales() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getLocales()");
            List<String> listLocales = Arrays.asList(Locales.ALLOWED_LOCALES);
            ArrayList<String> locales = new ArrayList<String>();
            locales.addAll(listLocales);
            logger.debug("locales :" + locales);
            return locales;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.debug("getLocales(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving locales: " + e.getLocalizedMessage());
        }
    }

    @Override
    public OpHistory getLastOperationInfo() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getLastOperationInfo()");
            TabResource currentTR = SessionUtil.getTabResource(session);
            if (currentTR == null) {
                logger.error("Current Tabular Resource is null");
                throw new TDGWTServiceException("Current Tabular Resource is null");
            }
            TRId trId = currentTR.getTrId();
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            List history = tabularResource.getHistory();
            long historyId = 0L;
            String opDesc = null;
            String opName = null;
            HistoryStep lastStep = null;
            OpHistory op = null;
            if (history != null && history.size() > 0 && (lastStep = (HistoryStep)history.get(0)) != null) {
                opName = opDesc = lastStep.getOperationDescription();
                historyId = lastStep.getId().getValue();
                op = new OpHistory(historyId, opName, opDesc, sdf.format(lastStep.getExecutionDate().getTime()));
            }
            logger.debug("Last Operation Info :" + op);
            return op;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving last operation info: " + e.getLocalizedMessage());
        }
    }

    @Override
    public OpHistory getLastOperationInfo(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getLastOperationInfo: " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            List history = tabularResource.getHistory();
            long historyId = 0L;
            String opDesc = null;
            String opName = null;
            HistoryStep lastStep = null;
            OpHistory op = null;
            if (history != null && history.size() > 0 && (lastStep = (HistoryStep)history.get(0)) != null) {
                opName = opDesc = lastStep.getOperationDescription();
                historyId = lastStep.getId().getValue();
                op = new OpHistory(historyId, opName, opDesc, sdf.format(lastStep.getExecutionDate().getTime()));
            }
            logger.debug("Last Operation Info :" + op);
            return op;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("getLastOperationInfo(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving last operation info: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<OpHistory> getHistory() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getHistory()");
            TabResource currentTR = SessionUtil.getTabResource(session);
            if (currentTR == null) {
                logger.error("Current Tabular Resource is null");
                throw new TDGWTServiceException("Current Tabular Resource is null");
            }
            TRId trId = currentTR.getTrId();
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            List history = tabularResource.getHistory();
            ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();
            long historyId = 0L;
            String opDesc = null;
            String opName = null;
            OpHistory op = null;
            for (HistoryStep step : history) {
                if (step == null) continue;
                historyId = step.getId().getValue();
                opDesc = step.getOperationDescription();
                opName = step.getOperationDescription();
                op = new OpHistory(historyId, opName, opDesc, sdf.format(step.getExecutionDate().getTime()));
                opHistoryList.add(op);
            }
            logger.debug("History :" + opHistoryList);
            return opHistoryList;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("getHistory(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving history: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<OpHistory> getHistory(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getHistory(): " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            List history = tabularResource.getHistory();
            ArrayList<OpHistory> opHistoryList = new ArrayList<OpHistory>();
            long historyId = 0L;
            String opDesc = null;
            String opName = null;
            OpHistory op = null;
            for (HistoryStep step : history) {
                if (step == null) continue;
                historyId = step.getId().getValue();
                opDesc = step.getOperationDescription();
                opName = step.getOperationDescription();
                op = new OpHistory(historyId, opName, opDesc, sdf.format(step.getExecutionDate().getTime()));
                opHistoryList.add(op);
            }
            logger.debug("History :" + opHistoryList);
            return opHistoryList;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("getHistory(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving history: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startDiscard(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartDiscard: " + trId);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            List history = tabularResource.getHistory();
            long historyId = 0L;
            String opDesc = null;
            String opName = null;
            OpHistory op = null;
            RollBackSession rollBackSession = null;
            String taskId = null;
            if (history != null) {
                if (history.size() > 1) {
                    HistoryStep step = (HistoryStep)history.get(history.size() - 2);
                    if (step != null) {
                        historyId = step.getId().getValue();
                        opName = opDesc = step.getOperationDescription();
                        op = new OpHistory(historyId, opName, opDesc, sdf.format(step.getExecutionDate().getTime()));
                        logger.debug("Discard :" + op);
                        rollBackSession = new RollBackSession(trId, historyId);
                        logger.debug("Start Discard:" + sdfPerformance.format(new Date()));
                        logger.debug("rollBack(): " + rollBackSession);
                        SessionUtil.setRollBackSession(session, rollBackSession);
                        HistoryStepId historyStepId = new HistoryStepId(rollBackSession.getHistoryId().longValue());
                        logger.debug("Start RollBack task:" + sdfPerformance.format(new Date()));
                        Task trTask = service.rollbackTo(tabularResourceId, historyStepId);
                        logger.debug("Start RollBack returned task:" + sdfPerformance.format(new Date()));
                        if (trTask == null) {
                            logger.error("Error on service Task null");
                            throw new TDGWTServiceException("Task not started");
                        }
                        logger.debug("Start Task on service: " + trTask.getId());
                        TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.RollBack, rollBackSession.getTrId());
                        SessionUtil.setStartedTask(session, taskWrapper);
                        taskId = trTask.getId().getValue();
                        logger.debug("Start Discard returned task:" + sdfPerformance.format(new Date()));
                    } else {
                        logger.debug("Discard : step null");
                    }
                } else {
                    logger.debug("Discard : no previous step exist");
                }
            } else {
                logger.debug("Discard : not present");
            }
            return taskId;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("discard(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Discard: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startRollBack(RollBackSession rollBackSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("rollBack(): " + rollBackSession);
            SessionUtil.setRollBackSession(session, rollBackSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(rollBackSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(rollBackSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            HistoryStepId historyStepId = new HistoryStepId(rollBackSession.getHistoryId().longValue());
            logger.debug("Start RollBack task:" + sdfPerformance.format(new Date()));
            Task trTask = service.rollbackTo(tabularResourceId, historyStepId);
            logger.debug("Start RollBack returned task:" + sdfPerformance.format(new Date()));
            if (trTask == null) {
                logger.error("Error on service Task null");
                throw new TDGWTServiceException("Task not started");
            }
            logger.debug("Start Task on service: " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.RollBack, rollBackSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.debug("rollBack(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("RollBack: " + e.getLocalizedMessage());
        }
    }

    private String retrieveTabularResourceIdFromTable(TabularDataService service, TableId tableId) throws TDGWTServiceException {
        try {
            Table table = service.getTable(tableId);
            if (table.contains(TableDescriptorMetadata.class)) {
                TableDescriptorMetadata tdm = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
                return String.valueOf(tdm.getRefId());
            }
            throw new TDGWTServiceException("No TableDescriptorMetadata present in tableId: " + tableId);
        }
        catch (Exception e) {
            throw new TDGWTServiceException(e.getLocalizedMessage());
        }
    }

    @Override
    public ValidationsTasksMetadata getValidationsTasksMetadata(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetTableValidationsMetadata on " + trId.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TabularResourceId tabularResourceId = new TabularResourceId(new Long(trId.getId()).longValue());
            ArrayList<TaskS> taskSList = new ArrayList<TaskS>();
            List tasks = service.getTasks(tabularResourceId);
            if (tasks.size() > 0) {
                Task task = (Task)tasks.get(0);
                ArrayList<JobS> jobSList = new ArrayList<JobS>();
                int j = 1;
                for (Job job : task.getTaskJobs()) {
                    int i = 1;
                    ArrayList<Validations> validations = new ArrayList<Validations>();
                    for (ValidationDescriptor val : job.getValidations()) {
                        Validations validation = new Validations(String.valueOf(i), val.getTitle(), val.getDescription(), val.isValid(), ConditionCodeMap.mapConditionCode(val.getConditionCode()), val.getValidationColumn());
                        validations.add(validation);
                        ++i;
                    }
                    InvocationS invocationS = null;
                    if (job.getInvocation() != null) {
                        OperationExecution operationExecution = job.getInvocation();
                        HashMap<String, Object> mapSent = new HashMap<String, Object>();
                        Map map = operationExecution.getParameters();
                        Set keys = map.keySet();
                        for (String key : keys) {
                            Object o = map.get(key);
                            mapSent.put(key, o.toString());
                        }
                        RefColumn refColumn = ExtractReferences.extract(operationExecution);
                        invocationS = new InvocationS(j, operationExecution.getColumnId(), operationExecution.getIdentifier(), operationExecution.getOperationId(), mapSent, task.getId().getValue(), refColumn);
                    }
                    JobSClassifier jobClassifier = JobClassifierMap.map(job.getJobClassifier());
                    JobS jobS = new JobS(String.valueOf(j), job.getProgress(), job.getHumaReadableStatus(), jobClassifier, job.getDescription(), validations, invocationS);
                    jobSList.add(jobS);
                    ++j;
                }
                ArrayList<TRId> collateralTRIds = new ArrayList<TRId>();
                TaskResult taskResult = task.getResult();
                if (taskResult != null) {
                    List collateral = taskResult.getCollateralTables();
                    for (TableId tId : collateral) {
                        String id = this.retrieveTabularResourceIdFromTable(service, tId);
                        TRId tabularRId = new TRId(id);
                        tabularRId.setTableId(String.valueOf(tId));
                        collateralTRIds.add(tabularRId);
                    }
                }
                State state = TaskStateMap.map(task.getStatus());
                TaskS taskS = new TaskS(task.getId().getValue(), task.getProgress(), state, task.getErrorCause(), task.getSubmitter(), task.getStartTime(), task.getEndTime(), jobSList, collateralTRIds, null);
                taskSList.add(taskS);
            }
            ValidationsTasksMetadata validationsTasksMetadata = new ValidationsTasksMetadata(taskSList);
            logger.debug("ValidationsTasksMetadata: " + validationsTasksMetadata);
            return validationsTasksMetadata;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error in  getValidationsTasksMetadata(): " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error in  getValidationsTasksMetadata: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startEditRow(EditRowSession editRowSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setEditRowSession(session, editRowSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(editRowSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(editRowSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4EditRow opEx = new OpExecution4EditRow(service, editRowSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocations = director.getListOperationExecution();
            if (invocations == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocations.toString());
            Task trTask = service.executeBatch(invocations, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.EditRow, editRowSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in operation: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ColumnData getConnection(RefColumn refColumn) throws TDGWTServiceException {
        try {
            TRId trId;
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("GetConnection on " + refColumn.toString());
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            TableId tableId = new TableId(new Long(refColumn.getTableId()).longValue());
            Table table = service.getTable(tableId);
            TableDescriptorMetadata tableDesc = null;
            if (table.contains(TableDescriptorMetadata.class)) {
                tableDesc = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
                if (tableDesc.getRefId() == 0L) {
                    logger.error("Error refId=0 for Table:" + table.toString());
                    throw new TDGWTServiceException("Error refId=0 for Table:" + table.toString());
                }
                logger.debug("Table connect to tabular resource: " + tableDesc.getRefId());
                TRId tId = new TRId(String.valueOf(tableDesc.getRefId()));
                trId = this.retrieveTabularResourceBasicData(tId);
            } else {
                logger.debug("Attention: No TableDescriptorMetadata found for table. Supposed Time Dimension :" + table);
                trId = new TRId();
                trId.setTableId(refColumn.getTableId());
            }
            ColumnData columnData = this.getColumn(refColumn.getColumnId(), trId);
            return columnData;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Error in getConnection(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new TDGWTServiceException("Error: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startTaskResubmit(TaskResubmitSession taskResubmitSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setTaskResubmitSession(session, taskResubmitSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartTaskResubmit: " + taskResubmitSession);
            if (taskResubmitSession == null) {
                logger.error("TaskResubmitSession is null");
                throw new TDGWTServiceException("Error in resubmit task: TaskResubmitSession is null");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(taskResubmitSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(taskResubmitSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            if (taskResubmitSession.getTaskId() == null || taskResubmitSession.getTaskId().isEmpty()) {
                logger.error("Task Id is: " + taskResubmitSession.getTaskId());
                throw new TDGWTServiceException("Error in resubmit task, Task Id is: " + taskResubmitSession.getTaskId());
            }
            TaskId taskId = new TaskId(taskResubmitSession.getTaskId());
            Task trTask = service.resubmit(taskId);
            logger.debug("Resubmit Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ResubmitTask, taskResubmitSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in resubmit task: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startTaskResume(TaskResumeSession taskResumeSession) throws TDGWTServiceException {
        try {
            Task trTask;
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setTaskResumeSession(session, taskResumeSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartTaskResume: " + taskResumeSession);
            if (taskResumeSession == null) {
                logger.error("TaskResumeSession is null");
                throw new TDGWTServiceException("Error in resume: TaskResumeSession is null");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(taskResumeSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(taskResumeSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            if (taskResumeSession.getTaskId() == null || taskResumeSession.getTaskId().isEmpty()) {
                logger.error("Task Id is: " + taskResumeSession.getTaskId());
                throw new TDGWTServiceException("Error in resume task, Task Id is: " + taskResumeSession.getTaskId());
            }
            TaskId taskId = new TaskId(taskResumeSession.getTaskId());
            HashMap map = new HashMap();
            ArrayList<ColumnMappingData> columnMapping = taskResumeSession.getColumnMapping();
            if (columnMapping != null && columnMapping.size() > 0) {
                HashMap<TDTypeValue, Long> mapping = new HashMap<TDTypeValue, Long>();
                logger.debug("New Mapping");
                for (ColumnMappingData columnMappingData : columnMapping) {
                    if (columnMappingData.getSourceArg() == null || columnMappingData.getTargetArg() == null) continue;
                    DimensionRow source = columnMappingData.getSourceArg();
                    DimensionRow target = columnMappingData.getTargetArg();
                    TDTypeValue tdValue = TDTypeValueMap.map(taskResumeSession.getColumn().getDataTypeName(), source.getValue());
                    logger.debug("Key = " + tdValue + " - " + new Long(target.getRowId()));
                    mapping.put(tdValue, new Long(target.getRowId()));
                }
                InvocationS invocationS = taskResumeSession.getInvocationS();
                if (invocationS != null) {
                    if (invocationS.getJobNumber() != null) {
                        if (invocationS.getTaskId() != null) {
                            Integer jobNumber = invocationS.getJobNumber();
                            TaskId previousTaskId = new TaskId(invocationS.getTaskId());
                            Task previousTask = service.getTask(previousTaskId);
                            List previousJobs = previousTask.getTaskJobs();
                            if (previousJobs != null) {
                                Job previousJob = (Job)previousJobs.get(jobNumber - 1);
                                if (previousJob != null) {
                                    Map mapParameters = previousJob.getInvocation().getParameters();
                                    if (mapParameters != null) {
                                        Map mappingPrevious = (Map)mapParameters.get("mapping");
                                        logger.debug("Previous Mapping");
                                        if (mappingPrevious != null) {
                                            for (TDTypeValue key : mappingPrevious.keySet()) {
                                                logger.debug("Key = " + key + " - " + mappingPrevious.get(key));
                                                mapping.put(key, (Long)mappingPrevious.get(key));
                                            }
                                        } else {
                                            logger.debug("Previous Mapping is null");
                                        }
                                    } else {
                                        logger.debug("Parameters is null");
                                    }
                                } else {
                                    logger.debug("PreviousJob is null");
                                }
                            } else {
                                logger.debug("PreviousJobs is null");
                            }
                        } else {
                            logger.debug("TaskId is null");
                        }
                    } else {
                        logger.debug("JobNumber is null");
                    }
                } else {
                    logger.debug("InvocationS is null");
                }
                map.put("mapping", mapping);
                trTask = service.resume(taskId, map);
                logger.debug("Resume Task on service: [TaskId:" + trTask.getId() + ", Map:" + map + "]");
            } else {
                trTask = service.resume(taskId);
                logger.debug("Resume Task on service: [TaskId:" + trTask.getId() + "]");
            }
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ResumeTask, taskResumeSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in resume task: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startExtractCodelist(ExtractCodelistSession extractCodelistSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setExtractCodelistSession(session, extractCodelistSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartExtractCodelist: " + extractCodelistSession);
            if (extractCodelistSession == null) {
                logger.error("ExtractCodelistSession is null");
                throw new TDGWTServiceException("Error in extract codelist: ExtractCodelistSession is null");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(extractCodelistSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(extractCodelistSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4ExtractCodelist opEx = new OpExecution4ExtractCodelist(service, extractCodelistSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Extract Codelist on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ExtractCodelist, extractCodelistSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in extract codelist: " + e.getLocalizedMessage());
        }
    }

    public String startSplitColumn(SplitColumnSession splitColumnSession, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setSplitColumnSession(session, splitColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (splitColumnSession == null) {
                logger.error("SplitColumnSession is null");
                throw new TDGWTServiceException("Error in split column: SplitColumnSession is null");
            }
            logger.debug("StartSplitColumn: " + splitColumnSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(splitColumnSession.getColumnData().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(splitColumnSession.getColumnData().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4SplitColumn opEx = new OpExecution4SplitColumn(service, splitColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocations = director.getListOperationExecution();
            if (invocations == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocations.toString());
            Task trTask = service.executeBatch(invocations, tabularResourceId);
            logger.debug("Split Column on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.SplitColumn, splitColumnSession.getColumnData().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in split column: " + e.getLocalizedMessage());
        }
    }

    public String startMergeColumn(MergeColumnSession mergeColumnSession, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setMergeColumnSession(session, mergeColumnSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (mergeColumnSession == null) {
                logger.error("MergeColumnSession is null");
                throw new TDGWTServiceException("Error in split column: MergeColumnSession is null");
            }
            logger.debug("StartMergeColumn: " + mergeColumnSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(mergeColumnSession.getColumnDataSource1().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(mergeColumnSession.getColumnDataSource1().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4MergeColumn opEx = new OpExecution4MergeColumn(service, mergeColumnSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocations = director.getListOperationExecution();
            if (invocations == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocations.toString());
            Task trTask = service.executeBatch(invocations, tabularResourceId);
            logger.debug("Merge Column on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.MergeColumn, mergeColumnSession.getColumnDataSource1().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in split column: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setCodelistMappingSession(CodelistMappingSession codelistMappingSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setCodelistMappingSession(session, codelistMappingSession);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error setting CodelistMappingSession parameter: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error setting CodelistMappingSession parameter: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void getFileFromWorkspace(CodelistMappingSession codelistMappingSession) throws TDGWTServiceException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession aslSession = SessionUtil.getAslSession(session);
        Workspace w = null;
        WorkspaceItem wi = null;
        try {
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            HomeManager manager = factory.getHomeManager();
            Home home = manager.getHome(aslSession.getUsername());
            w = home.getWorkspace();
            wi = w.getItem(codelistMappingSession.getItemId());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in import Codelist Mapping getFileFromWorkspace accessing the workspace: " + e.getLocalizedMessage(), e);
        }
        if (wi == null) {
            logger.error("Error retrieving the item on workspace" + codelistMappingSession.getItemId());
            throw new TDGWTServiceException("Error retrieving the item on workspace" + codelistMappingSession.getItemId());
        }
        try {
            logger.debug("WorkspaceItem [id:" + wi.getId() + " name:" + wi.getName() + " remotePath:" + wi.getRemotePath() + "]");
        }
        catch (InternalErrorException e1) {
            e1.printStackTrace();
            throw new TDGWTServiceException("Error retrieving the item on workspace" + wi);
        }
        CodelistMappingFileUploadSession fileUploadSession = new CodelistMappingFileUploadSession();
        FileUploadMonitor fileUploadMonitor = new FileUploadMonitor();
        fileUploadSession.setId(session.getId());
        fileUploadSession.setFileUploadState(FileUploadState.STARTED);
        SessionUtil.setFileUploadMonitor(session, fileUploadMonitor);
        SessionUtil.setCodelistMappingFileUploadSession(session, fileUploadSession);
        try {
            FilesStorage filesStorage = new FilesStorage();
            InputStream is = filesStorage.retriveImputStream(aslSession.getUsername(), wi);
            FileUtil.setImportFileCodelistMapping(fileUploadSession, is, wi.getName(), "application/xml");
        }
        catch (Throwable e) {
            FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
            fum.setFailed("An error occured elaborating the file", FileUtil.exceptionDetailMessage(e));
            SessionUtil.setFileUploadMonitor(session, fum);
            fileUploadSession.setFileUploadState(FileUploadState.FAILED);
            SessionUtil.setCodelistMappingFileUploadSession(session, fileUploadSession);
            logger.error("Error elaborating the input stream", e);
            throw new TDGWTServiceException("Error in import Codelist Mapping getFileFromWorkspace: " + e.getLocalizedMessage(), e);
        }
        logger.trace("changing state");
        FileUploadMonitor fum = SessionUtil.getFileUploadMonitor(session);
        fum.setState(FileUploadState.COMPLETED);
        SessionUtil.setFileUploadMonitor(session, fum);
        SessionUtil.setCodelistMappingFileUploadSession(session, fileUploadSession);
    }

    @Override
    public String startCodelistMappingImport(CodelistMappingSession codelistMappingSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            if (session == null) {
                throw new TDGWTServiceException("Session is null");
            }
            logger.debug("Session:" + session.getId());
            ASLSession aslSession = SessionUtil.getAslSession(session);
            String user = aslSession.getUsername();
            logger.debug("Session User:" + user);
            if (codelistMappingSession == null) {
                throw new TDGWTServiceException("CodelistMappingSession is null");
            }
            logger.debug("StartCodelistMappingImport: " + codelistMappingSession);
            SessionUtil.setCodelistMappingSession(session, codelistMappingSession);
            String taskId = this.importCodelistMappingFileOnService(session, aslSession, user, codelistMappingSession);
            return taskId;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in Codelist Mapping import: " + e.getLocalizedMessage());
        }
    }

    private String importCodelistMappingFileOnService(HttpSession session, ASLSession aslSession, String user, CodelistMappingSession codelistMappingSession) throws Throwable {
        String importUrl = null;
        if (codelistMappingSession.getSource().getId().compareTo(SourceType.URL.toString()) == 0) {
            importUrl = codelistMappingSession.getUrl();
        } else {
            CodelistMappingFileUploadSession codelistMappingFileUploadSession = SessionUtil.getCodelistMappingFileUploadSession(session);
            if (codelistMappingFileUploadSession == null) {
                throw new TDGWTServiceException("Error retrieving the codelistMappingFileUploadSession: null");
            }
            logger.debug("File Storage Access");
            FilesStorage filesStorage = new FilesStorage();
            String fileUrlOnStorage = filesStorage.storageCodelistMappingTempFile(user, codelistMappingFileUploadSession.getCodelistMappingFile());
            logger.debug("File Url On Storage:" + fileUrlOnStorage);
            codelistMappingFileUploadSession.getCodelistMappingFile().delete();
            if (fileUrlOnStorage == null || fileUrlOnStorage.isEmpty()) {
                throw new TDGWTServiceException("Tabular Data Service error loading file on storage");
            }
            importUrl = fileUrlOnStorage;
        }
        AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
        TabularDataService service = TabularDataServiceFactory.getService();
        this.checkTRId(codelistMappingSession.getTrId());
        TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(codelistMappingSession.getTrId().getId()).longValue());
        TabularResource tabularResource = service.getTabularResource(tabularResourceId);
        this.checkTabularResourceIsFlow(tabularResource);
        this.checkTabularResourceLocked(tabularResource);
        this.checkTabularResourceIsFinal(tabularResource);
        OpExecution4CodelistMapping opEx = new OpExecution4CodelistMapping(service, codelistMappingSession, importUrl);
        OpExecutionDirector director = new OpExecutionDirector();
        director.setOperationExecutionBuilder(opEx);
        director.constructOperationExecution();
        OperationExecution invocation = director.getOperationExecution();
        if (invocation == null) {
            throw new TDGWTServiceException("Error in invocation: Operation not supported");
        }
        logger.debug("OperationInvocation: \n" + invocation.toString());
        Task trTask = service.execute(invocation, tabularResourceId);
        logger.debug("Codelist Mapping Import on service: TaskId " + trTask.getId());
        TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.CodelistMappingImport, codelistMappingSession.getTrId());
        SessionUtil.setStartedTask(session, taskWrapper);
        return trTask.getId().getValue();
    }

    public String startGroupBy(GroupBySession groupBySession, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setGroupBySession(session, groupBySession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartGroupBy: " + groupBySession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(groupBySession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(groupBySession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4GroupBy opEx = new OpExecution4GroupBy(service, groupBySession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("GroupBy start on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.GroupBy, groupBySession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in start group by: " + e.getLocalizedMessage());
        }
    }

    public String startTimeAggregation(TimeAggregationSession timeAggregationSession, HttpSession session) throws TDGWTServiceException {
        try {
            SessionUtil.setTimeAggregationSession(session, timeAggregationSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("StartGroupBy: " + timeAggregationSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(timeAggregationSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(timeAggregationSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4TimeAggregation opEx = new OpExecution4TimeAggregation(service, timeAggregationSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("GroupBy start on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.TimeAggregation, timeAggregationSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in start Time Aggregation: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startNormalization(NormalizationSession normalizationSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setNormalizationSession(session, normalizationSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (normalizationSession == null) {
                logger.error("NormalizationSession is null");
                throw new TDGWTServiceException("Error in normalization : NormalizationSession is null");
            }
            logger.debug("StartNormalization: " + normalizationSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(normalizationSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(normalizationSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4Normalization opEx = new OpExecution4Normalization(service, normalizationSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Normalization start on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.Normalize, normalizationSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in start normalization: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startDenormalization(DenormalizationSession denormalizationSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setDenormalizationSession(session, denormalizationSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (denormalizationSession == null) {
                logger.error("DenormalizationSession is null");
                throw new TDGWTServiceException("Error in normalization : DenormalizationSession is null");
            }
            logger.debug("StartDenormalization: " + denormalizationSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(denormalizationSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(denormalizationSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4Denormalization opEx = new OpExecution4Denormalization(service, denormalizationSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Denormalization start on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.Denormalize, denormalizationSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in start denormalization: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startUnion(UnionSession unionSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setUnionSession(session, unionSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(unionSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(unionSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4Union opEx = new OpExecution4Union(service, unionSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Union invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.Union, unionSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in union: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void startChangeColumnsPosition(ChangeColumnsPositionSession changeColumnsPositionSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setChangeColumnsPositionSession(session, changeColumnsPositionSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(changeColumnsPositionSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(changeColumnsPositionSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ChangeColumnsPosition opEx = new OpExecution4ChangeColumnsPosition(service, changeColumnsPositionSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in Change Position invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            service.executeSynchMetadataOperation(invocation, tabularResourceId);
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in change position: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startReplaceByExternal(ReplaceByExternalSession replaceByExternalSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setReplaceByExternalSession(session, replaceByExternalSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(replaceByExternalSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(replaceByExternalSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4ReplaceByExternal opEx = new OpExecution4ReplaceByExternal(service, replaceByExternalSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error replace by external invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ReplaceByExternal, replaceByExternalSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in replace by external: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startStatisticalOperation(StatisticalOperationSession statisticalOperationSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setStatisticalOperationSession(session, statisticalOperationSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(statisticalOperationSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(statisticalOperationSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4StatisticalOperation opEx = new OpExecution4StatisticalOperation(service, aslSession, statisticalOperationSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Statistical Operation invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.StatisticalOperation, statisticalOperationSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in statistical operation: " + e.getLocalizedMessage());
        }
    }

    @Override
    public OperationMonitor getOperationMonitor(OperationMonitorSession operationMonitorSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            TaskWrapper taskWrapper = SessionUtil.getStartedTask(session, operationMonitorSession.getTaskId());
            logger.debug("Start Monitor Time:" + sdfPerformance.format(new Date()));
            OperationMonitorCreator operationMonitorCreator = new OperationMonitorCreator(session, aslSession, taskWrapper, operationMonitorSession);
            OperationMonitor operationMonitor = operationMonitorCreator.create();
            logger.debug("OperationMonitor(): " + operationMonitor);
            return operationMonitor;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in Operation Monitor: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<LicenceData> getLicences() throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.getAslSession(session);
            ArrayList<LicenceData> licences = new ArrayList<LicenceData>();
            Licence[] licencesArray = Licence.values();
            int i = 0;
            while (i < licencesArray.length) {
                Licence licence = licencesArray[i];
                LicenceData licenceData = new LicenceData(i, licence.toString());
                licences.add(licenceData);
                ++i;
            }
            logger.debug("Licences: " + licences.size());
            return licences;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in get Licences: " + e.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OperationMonitor getBackgroundOperationMonitorForSpecificTask(OperationMonitorSession operationMonitorSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            OperationMonitor operationMonitor = null;
            if (operationMonitorSession == null || operationMonitorSession.getTaskId() == null || operationMonitorSession.getTaskId().isEmpty()) throw new TDGWTServiceException("Error in Background Operation Monitor of specific task: operationMonitorSession invalid:" + operationMonitorSession);
            HashMap<String, TaskWrapper> taskInBackgroundMap = SessionUtil.getTaskInBackgroundMap(session);
            if (taskInBackgroundMap == null) throw new TDGWTServiceException("Error in Background Operation Monitor of specific task: No tasks in session");
            TaskWrapper taskWrapper = taskInBackgroundMap.get(operationMonitorSession.getTaskId());
            if (taskWrapper == null) {
                throw new TDGWTServiceException("Error in Background Operation Monitor of specific task: task not found");
            }
            operationMonitorSession.setInBackground(true);
            BackgroundOperationMonitorCreator backgroundOperationMonitorCreator = new BackgroundOperationMonitorCreator(session, aslSession, taskWrapper, operationMonitorSession);
            operationMonitor = backgroundOperationMonitorCreator.create();
            logger.debug("BackgroundOperationMonitorForSpecificTask(): " + operationMonitor);
            return operationMonitor;
        }
        catch (TDGWTServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in Background Operation Monitor of specific task: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<BackgroundOperationMonitor> getBackgroundOperationMonitor(BackgroundOperationMonitorSession backgroundOperationMonitorSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("getBackgroundOperationMonitor(): " + backgroundOperationMonitorSession);
            ArrayList<OperationMonitor> operationMonitorList = new ArrayList<OperationMonitor>();
            HashMap<String, TaskWrapper> taskInBackgroundMap = SessionUtil.getTaskInBackgroundMap(session);
            if (taskInBackgroundMap != null && taskInBackgroundMap.size() > 0) {
                logger.debug("Tasks In Background : " + taskInBackgroundMap.size());
                for (Map.Entry entry : taskInBackgroundMap.entrySet()) {
                    OperationMonitorSession operationMonitorSession = new OperationMonitorSession((String)entry.getKey());
                    operationMonitorSession.setInBackground(true);
                    if (backgroundOperationMonitorSession != null) {
                        ArrayList<OperationMonitorSession> operationMonitorSessionList = backgroundOperationMonitorSession.getOperationMonitorSessionList();
                        for (OperationMonitorSession opMonitorSession : operationMonitorSessionList) {
                            if (opMonitorSession.getTaskId().compareTo((String)entry.getKey()) != 0) continue;
                            operationMonitorSession = opMonitorSession;
                            break;
                        }
                    }
                    BackgroundOperationMonitorCreator backgroundOperationMonitorCreator = new BackgroundOperationMonitorCreator(session, aslSession, (TaskWrapper)entry.getValue(), operationMonitorSession);
                    OperationMonitor operationMonitor = backgroundOperationMonitorCreator.create();
                    logger.debug("getBackgroundOperationMonitor(): " + operationMonitor);
                    operationMonitorList.add(operationMonitor);
                }
            } else {
                logger.debug("Tasks In Background : 0");
            }
            ArrayList<BackgroundOperationMonitor> backgroundOperationMonitorList = new ArrayList<BackgroundOperationMonitor>();
            for (OperationMonitor operationMonitor : operationMonitorList) {
                BackgroundOperationMonitor backgroundOperationMonitor = new BackgroundOperationMonitor(operationMonitor.getTaskId(), operationMonitor.getTask().getProgress(), operationMonitor.getTask().getState(), operationMonitor.getTask().getErrorCause(), operationMonitor.getTask().getSubmitter(), operationMonitor.getTask().getStartTime(), operationMonitor.getTask().getEndTime(), operationMonitor.isInBackground(), operationMonitor.isAbort(), operationMonitor.isHidden(), operationMonitor.getOperationId(), operationMonitor.getTrId(), operationMonitor.getTask().getTabularResourceId(), operationMonitor.getTabularResourceName());
                backgroundOperationMonitorList.add(backgroundOperationMonitor);
            }
            logger.debug("getBackgroundOperationMonitor(): " + backgroundOperationMonitorList.size() + "operation monitor retrieved");
            return backgroundOperationMonitorList;
        }
        catch (TDGWTServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in Background Operation Monitor: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ResourceTDDescriptor> getResourcesTD(TRId trId) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tabularResource);
            List resources = service.getResources(tabularResourceId);
            ResourceTDCreator resourceTDCreator = new ResourceTDCreator();
            ArrayList<ResourceTDDescriptor> resourcesTD = resourceTDCreator.createResourcesDescriptorTD(resources);
            return resourcesTD;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving resources: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving resources: " + e.getLocalizedMessage());
        }
    }

    @Override
    public ArrayList<ResourceTDDescriptor> getResourcesTDByType(TRId trId, ResourceTDType resourceTDType) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceLocked(tabularResource);
            ResourceType resourceType = ResourceTypeMap.getResourceType(resourceTDType);
            List resources = service.getResourcesByType(tabularResourceId, resourceType);
            ResourceTDCreator resourceTDCreator = new ResourceTDCreator();
            ArrayList<ResourceTDDescriptor> resourcesTD = resourceTDCreator.createResourcesDescriptorTD(resources);
            return resourcesTD;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error retrieving resources by type: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error retrieving resources by type: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void removeResource(RemoveResourceSession removeResourceSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("Remove Resource: " + removeResourceSession);
            if (removeResourceSession == null) {
                logger.error("Error removing Resource: removeResourceSession null");
                throw new TDGWTServiceException("Error removing Resource no parameters set");
            }
            TRId trId = removeResourceSession.getTrId();
            if (trId == null) {
                logger.error("Error removing Resource: trId is null");
                throw new TDGWTServiceException("Error removing Resource no tabular resource set");
            }
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(trId);
            TabularResourceId tabResourceId = new TabularResourceId(Long.valueOf(trId.getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabResourceId);
            this.checkTabularResourceLocked(tabularResource);
            String owner = tabularResource.getOwner();
            if (owner != null && owner.compareTo(aslSession.getUsername()) == 0) {
                if (removeResourceSession.getResourceTDDescriptor() == null) {
                    logger.error("Error removing Resource: descriptor null");
                    throw new TDGWTServiceException("Error removing Resource no descriptor set");
                }
            } else {
                throw new TDGWTServiceException("You are not the owner of this tabular resource (owner: " + owner + ")");
            }
            service.removeResurce(removeResourceSession.getResourceTDDescriptor().getId());
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            logger.error("Error deleting the resource: " + e.getLocalizedMessage(), e);
            throw new TDGWTServiceException("Error deleting the resource: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startMapCreation(MapCreationSession mapCreationSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setMapCreationSession(session, mapCreationSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(mapCreationSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(mapCreationSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4MapCreation opEx = new OpExecution4MapCreation(service, mapCreationSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error Generate Map invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.GenerateMap, mapCreationSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error creating the map: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String getUriFromResolver(UriResolverSession uriResolverSession) throws TDGWTServiceException {
        try {
            String link = "";
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("Get uri from resolver: " + uriResolverSession);
            HashMap<String, String> params = new HashMap<String, String>();
            switch (uriResolverSession.getApplicationType()) {
                case GIS: {
                    UriResolverManager resolver = new UriResolverManager(uriResolverSession.getApplicationType().toString());
                    params.put("gis-UUID", uriResolverSession.getUuid());
                    params.put("scope", aslSession.getScope());
                    logger.debug("Uri Resolver params: " + params);
                    link = resolver.getLink(params, true);
                    break;
                }
                case SMP: {
                    UriResolverManager resolver = new UriResolverManager(uriResolverSession.getApplicationType().toString());
                    params.put("smp-uri", uriResolverSession.getUuid());
                    params.put("fileName", uriResolverSession.getFileName());
                    params.put("contentType", "");
                    logger.debug("Uri Resolver params: " + params);
                    link = resolver.getLink(params, true);
                    break;
                }
                default: {
                    logger.debug("No resolver enable on this application type");
                    throw new TDGWTServiceException("Error retrieving uri from resolver: No resolver enable on this application type");
                }
            }
            logger.debug("Retrieved Link: " + link);
            return link;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error retrieving uri from resolver: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startChartTopRating(ChartTopRatingSession chartTopRatingSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setChartTopRatingSession(session, chartTopRatingSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(chartTopRatingSession.getColumn().getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(chartTopRatingSession.getColumn().getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            OpExecution4ChartTopRating opEx = new OpExecution4ChartTopRating(service, chartTopRatingSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in Top Rating Chart invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("Start Task on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.ChartTopRating, chartTopRatingSession.getColumn().getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error creating top rating chart: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void saveResource(SaveResourceSession saveResourceSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setSaveResourceSession(session, saveResourceSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            logger.debug("SaveResource(): " + saveResourceSession);
            FilesStorage storage = new FilesStorage();
            MimeTypeSupport mimeTypeSupport = saveResourceSession.getMime();
            String mimeType = mimeTypeSupport.compareTo((Enum)MimeTypeSupport._unknow) == 0 ? null : mimeTypeSupport.getMimeName();
            ResourceTD resource = saveResourceSession.getResourceTDDescriptor().getResourceTD();
            String uri = null;
            if (resource instanceof StringResourceTD) {
                StringResourceTD stringResourceTD = (StringResourceTD)resource;
                uri = stringResourceTD.getStringValue();
            } else if (resource instanceof InternalURITD) {
                InternalURITD internalURITD = (InternalURITD)resource;
                uri = internalURITD.getUrl();
            } else {
                if (resource instanceof TableResourceTD) {
                    throw new TDGWTServiceException("Save is not supported for this resource!");
                }
                throw new TDGWTServiceException("Save is not supported for this resource!");
            }
            if (uri == null || uri.isEmpty()) {
                throw new TDGWTServiceException("This resource does not have valid uri: " + uri);
            }
            logger.debug("Create Item On Workspace: [uri=" + uri + " ,user: " + aslSession.getUsername() + " ,fileName: " + saveResourceSession.getFileName() + " ,fileDescription: " + saveResourceSession.getFileDescription() + " ,mimetype:" + mimeType + " ,folder: " + saveResourceSession.getItemId() + "]");
            storage.createItemOnWorkspace(uri, aslSession.getUsername(), saveResourceSession.getFileName(), saveResourceSession.getFileDescription(), mimeType, saveResourceSession.getItemId());
            return;
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error saving the resource: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startGeospatialCreateCoordinates(GeospatialCreateCoordinatesSession geospatialCreateCoordinatesSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setGeospatialCreateCoordinatesSession(session, geospatialCreateCoordinatesSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (geospatialCreateCoordinatesSession == null) {
                logger.error("GeospatialCreateCoordinatesSession is null");
                throw new TDGWTServiceException("Error creating geospatial coordinates: GeospatialCreateCoordinatesSession is null");
            }
            logger.debug("StartGeospatialCreateCoordinates: " + geospatialCreateCoordinatesSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(geospatialCreateCoordinatesSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(geospatialCreateCoordinatesSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4GeospatialCreateCoordinates opEx = new OpExecution4GeospatialCreateCoordinates(aslSession, service, geospatialCreateCoordinatesSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("GeospatialCreateCoordinates on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.GeospatialCreateCoordinates, geospatialCreateCoordinatesSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error creating geospatial coordinates: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startGeospatialDownscaleCSquare(GeospatialDownscaleCSquareSession geospatialDownscaleCSquareSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setGeospatialDownscaleCSquareSession(session, geospatialDownscaleCSquareSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (geospatialDownscaleCSquareSession == null) {
                logger.error("GeospatialDownscaleCSquareSession is null");
                throw new TDGWTServiceException("Error in downscale C-Square: GeospatialDownscaleCSquareSession is null");
            }
            logger.debug("StartGeospatialDownscaleCSquare: " + geospatialDownscaleCSquareSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(geospatialDownscaleCSquareSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(geospatialDownscaleCSquareSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4GeospatialDownscaleCSquare opEx = new OpExecution4GeospatialDownscaleCSquare(service, geospatialDownscaleCSquareSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            OperationExecution invocation = director.getOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.execute(invocation, tabularResourceId);
            logger.debug("GeospatialCreateCoordinates on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.DownscaleCSquare, geospatialDownscaleCSquareSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error in downscale C-Square: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String startGeometryCreatePoint(GeometryCreatePointSession geometryCreatePointSession) throws TDGWTServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            SessionUtil.setGeometryCreatePointSession(session, geometryCreatePointSession);
            ASLSession aslSession = SessionUtil.getAslSession(session);
            if (geometryCreatePointSession == null) {
                logger.error("GeometryCreatePointSession is null");
                throw new TDGWTServiceException("Error creating geometry point: GeometryCreatePointSession is null");
            }
            logger.debug("StartGeometryCreatePoint: " + geometryCreatePointSession);
            AuthorizationProvider.instance.set(new AuthorizationToken(aslSession.getUsername(), aslSession.getScope()));
            TabularDataService service = TabularDataServiceFactory.getService();
            this.checkTRId(geometryCreatePointSession.getTrId());
            TabularResourceId tabularResourceId = new TabularResourceId(Long.valueOf(geometryCreatePointSession.getTrId().getId()).longValue());
            TabularResource tabularResource = service.getTabularResource(tabularResourceId);
            this.checkTabularResourceIsFlow(tabularResource);
            this.checkTabularResourceLocked(tabularResource);
            this.checkTabularResourceIsFinal(tabularResource);
            OpExecution4GeometryCreatePoint opEx = new OpExecution4GeometryCreatePoint(service, geometryCreatePointSession);
            OpExecutionDirector director = new OpExecutionDirector();
            director.setOperationExecutionBuilder(opEx);
            director.constructOperationExecution();
            ArrayList<OperationExecution> invocation = director.getListOperationExecution();
            if (invocation == null) {
                throw new TDGWTServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("OperationInvocation: \n" + invocation.toString());
            Task trTask = service.executeBatch(invocation, tabularResourceId);
            logger.debug("GeometryCreatePoint on service: TaskId " + trTask.getId());
            TaskWrapper taskWrapper = new TaskWrapper(trTask, UIOperationsId.GeometryCreatePoint, geometryCreatePointSession.getTrId());
            SessionUtil.setStartedTask(session, taskWrapper);
            return trTask.getId().getValue();
        }
        catch (TDGWTServiceException e) {
            throw e;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new TDGWTServiceException(SECURITY_EXCEPTION_RIGHTS);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new TDGWTServiceException("Error creating geometry point: " + e.getLocalizedMessage());
        }
    }
}

