/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.util.ArrayList;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXRegistryDescriptor;
import org.gcube.datapublishing.sdmx.impl.model.SDMXRegistryDescriptorImpl;
import org.gcube.datapublishing.sdmx.impl.registry.FusionRegistryClient;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Agencies;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Dataset;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;

public class SDMXClient {
    protected SDMXRegistryClient client;
    protected TYPE type;
    protected String url;

    public SDMXClient() {
        this.type = TYPE.INTERNAL;
        this.url = null;
        GCubeSDMXRegistryDescriptor descriptor = new GCubeSDMXRegistryDescriptor();
        this.client = new FusionRegistryClient((SDMXRegistryDescriptor)descriptor);
    }

    public SDMXClient(String url) {
        this.type = TYPE.ANOTHER;
        this.url = url;
        SDMXRegistryDescriptorImpl descriptor = new SDMXRegistryDescriptorImpl();
        descriptor.setUrl(SDMXRegistryInterfaceType.RESTV2_1, url);
        this.client = new FusionRegistryClient((SDMXRegistryDescriptor)descriptor);
    }

    public ArrayList<Codelist> getAllCodelists() throws Exception {
        SdmxBeans beans = this.client.getCodelist("all", "all", "all", SDMXRegistryClient.Detail.allstubs, SDMXRegistryClient.References.none);
        ArrayList<Codelist> codelists = new ArrayList<Codelist>();
        for (CodelistBean codelist : beans.getCodelists()) {
            codelists.add(new Codelist(codelist.getId(), codelist.getName(), codelist.getAgencyId(), codelist.getVersion(), codelist.getDescription()));
        }
        return codelists;
    }

    public ArrayList<Dataset> getAllDatasets() throws Exception {
        SdmxBeans beans = this.client.getProvisionAgreement("all", "all", "latest", SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.children);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (DataflowBean dataflowBean : beans.getDataflows()) {
            datasets.add(new Dataset(dataflowBean.getId(), dataflowBean.getName(), dataflowBean.getAgencyId(), dataflowBean.getVersion(), dataflowBean.getDescription()));
        }
        return datasets;
    }

    public ArrayList<Agencies> getAllAgencies() throws Exception {
        SdmxBeans beans = this.client.getAgencyScheme("SDMX", "AGENCIES", "1.0", SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
        ArrayList<Agencies> agenciesList = new ArrayList<Agencies>();
        for (AgencyBean agency : beans.getAgencies()) {
            agenciesList.add(new Agencies(agency.getId(), agency.getName(), agency.getDescription()));
        }
        return agenciesList;
    }

    public static enum TYPE {
        INTERNAL,
        ANOTHER;

    }
}

