/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype.value;

import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

public class TDGeometry
extends TDTypeValue {
    private static final long serialVersionUID = -6336508039560210266L;
    private static final String GEOMETRY_REGEXPR = "(\\s*POINT\\s*\\(\\s*(-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*\\)\\s*$)|(\\s*LINESTRING\\s*\\((\\s*(-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*,)+\\s*((-)?\\d+(\\.\\d+)?\\s+(-)?\\d+(\\.\\d+)?\\s*)\\)\\s*$)";
    private String value;

    private TDGeometry() {
    }

    public TDGeometry(String geometryAsString) {
        this.value = geometryAsString;
        if (!TDGeometry.validateGeometry(geometryAsString)) {
            throw new IllegalArgumentException("the string represention of the geometry is not valid");
        }
    }

    @Override
    public int compareTo(TDTypeValue o) {
        return this.value.compareTo(((TDGeometry)o).getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDInteger other = (TDInteger)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.value == null || !TDGeometry.validateGeometry(this.value)) {
            throw new MalformedExpressionException("the string represention of the geometry is not valid");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static boolean validateGeometry(String geometryAsString) {
        return geometryAsString.matches(GEOMETRY_REGEXPR);
    }

    @Override
    public DataType getReturnedDataType() {
        return new GeometryType();
    }
}

